/*
 * Decompiled with CFR 0.152.
 */
package scala.build.testrunner;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.build.testrunner.TestRunner$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class DynamicTestRunner$ {
    public static final DynamicTestRunner$ MODULE$ = new DynamicTestRunner$();

    private Option<Fingerprint> matchFingerprints(ClassLoader loader, Class<?> cls, Fingerprint[] fingerprints) {
        boolean definitelyNoTests;
        boolean isModule = cls.getName().endsWith("$");
        int publicConstructorCount = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])cls.getConstructors()), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$matchFingerprints$1(c)));
        boolean noPublicConstructors = publicConstructorCount == 0;
        boolean bl = definitelyNoTests = Modifier.isAbstract(cls.getModifiers()) || cls.isInterface() || publicConstructorCount > 1 || isModule != noPublicConstructors;
        if (definitelyNoTests) {
            return None$.MODULE$;
        }
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])fingerprints), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$matchFingerprints$2(isModule, loader, cls, x0$1)));
    }

    public Iterator<String> listClasses(Path classPathEntry, boolean keepJars) {
        if (Files.isDirectory(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            try (Stream<Path> stream = null;){
                stream = Files.walk(classPathEntry, Integer.MAX_VALUE, new FileVisitOption[0]);
                iterator = CollectionConverters$.MODULE$.IteratorHasAsScala(stream.iterator()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$listClasses$1(x$2))).map((Function1 & Serializable)x$3 -> classPathEntry.relativize((Path)x$3)).map((Function1 & Serializable)p -> {
                    int count = p.getNameCount();
                    return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)x$1 -> p.getName(BoxesRunTime.unboxToInt((Object)x$1))).mkString(".");
                }).map((Function1 & Serializable)x$4 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$4), ".class")).toVector().iterator();
            }
            return iterator;
        }
        if (keepJars && Files.isRegularFile(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            try (ZipFile zf = null;){
                zf = new ZipFile(classPathEntry.toFile());
                iterator = CollectionConverters$.MODULE$.EnumerationHasAsScala(zf.entries()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$listClasses$6(x$5))).map((Function1 & Serializable)ent -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(ent.getName()), ".class").replace("/", ".")).toVector().iterator();
            }
            return iterator;
        }
        return package$.MODULE$.Iterator().empty();
    }

    public Iterator<String> listClasses(Seq<Path> classPath, boolean keepJars) {
        return classPath.iterator().flatMap((Function1 & Serializable)x$6 -> MODULE$.listClasses((Path)x$6, keepJars));
    }

    public Option<Framework> findFrameworkService(ClassLoader loader) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(ServiceLoader.load(Framework.class, loader).iterator()).asScala().take(1).toList().headOption();
    }

    public Framework loadFramework(ClassLoader loader, String className) {
        Class<?> cls = loader.loadClass(className);
        Constructor<?> constructor = cls.getConstructor(new Class[0]);
        return (Framework)constructor.newInstance(new Object[0]);
    }

    public Option<Framework> findFramework(Seq<Path> classPath, ClassLoader loader, Seq<String> preferredClasses) {
        Class<Framework> frameworkCls = Framework.class;
        return preferredClasses.iterator().$plus$plus((Function0 & Serializable)() -> MODULE$.listClasses(classPath, true)).flatMap((Function1 & Serializable)name -> {
            Iterator iterator;
            try {
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{loader.loadClass((String)name)}));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ClassNotFoundException ? true : (throwable2 instanceof UnsupportedClassVersionError ? true : (throwable2 instanceof NoClassDefFoundError ? true : throwable2 instanceof IncompatibleClassChangeError))) {
                    iterator = package$.MODULE$.Iterator().empty();
                }
                throw throwable;
            }
            Iterator it = iterator;
            return it;
        }).flatMap((Function1 & Serializable)cls -> {
            Iterator it = frameworkCls.isAssignableFrom((Class<?>)cls) && !DynamicTestRunner$.isAbstract$1(cls) && DynamicTestRunner$.publicConstructorCount$1(cls) == 1 ? package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{cls})) : package$.MODULE$.Iterator().empty();
            return it;
        }).flatMap((Function1 & Serializable)cls -> {
            Iterator iterator;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Framework[]{(Framework)constructor.newInstance(new Object[0])}));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                iterator = package$.MODULE$.Iterator().empty();
            }
            return iterator;
        }).take(1).toList().headOption();
    }

    private Pattern globPattern(String expr) {
        String[] a = expr.split("\\*", -1);
        StringBuilder b = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), a.length).foreach((Function1 & Serializable)i -> DynamicTestRunner$.$anonfun$globPattern$1(b, a, BoxesRunTime.unboxToInt((Object)i)));
        return Pattern.compile(b.toString());
    }

    public void main(String[] args) {
        Tuple5 tuple5 = this.parse$1((Option)None$.MODULE$, (List)Nil$.MODULE$, false, 0, (Option)None$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])args).toList());
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Option testFrameworkOpt = (Option)tuple5._1();
        boolean requireTests = BoxesRunTime.unboxToBoolean((Object)tuple5._2());
        int verbosity = BoxesRunTime.unboxToInt((Object)tuple5._3());
        Option testOnly = (Option)tuple5._4();
        List args0 = (List)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)testFrameworkOpt, (Object)BoxesRunTime.boxToBoolean((boolean)requireTests), (Object)BoxesRunTime.boxToInteger((int)verbosity), (Object)testOnly, (Object)args0);
        Option testFrameworkOpt2 = (Option)tuple52._1();
        boolean requireTests2 = BoxesRunTime.unboxToBoolean((Object)tuple52._2());
        int verbosity2 = BoxesRunTime.unboxToInt((Object)tuple52._3());
        Option testOnly2 = (Option)tuple52._4();
        List args02 = (List)tuple52._5();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Seq<Path> classPath0 = TestRunner$.MODULE$.classPath(classLoader);
        Framework framework = (Framework)testFrameworkOpt2.map((Function1 & Serializable)x$8 -> MODULE$.loadFramework(classLoader, (String)x$8)).orElse((Function0 & Serializable)() -> MODULE$.findFrameworkService(classLoader)).orElse((Function0 & Serializable)() -> MODULE$.findFramework(classPath0, classLoader, TestRunner$.MODULE$.commonTestFrameworks())).getOrElse((Function0 & Serializable)() -> {
            if (verbosity2 >= 2) {
                return scala.sys.package$.MODULE$.error("No test framework found");
            }
            System.err.println("No test framework found");
            return scala.sys.package$.MODULE$.exit(1);
        });
        PrintStream out = System.out;
        Fingerprint[] fingerprints = framework.fingerprints();
        Runner runner = framework.runner((String[])args02.toArray(ClassTag$.MODULE$.apply(String.class)), (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), classLoader);
        Vector taskDefs = this.clsFingerprints$1(classLoader, fingerprints, classPath0).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$main$8(testOnly2, x0$1))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Class cls = (Class)tuple2._1();
                Fingerprint fp = (Fingerprint)tuple2._2();
                return new TaskDef(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(cls.getName()), "$"), fp, false, (Selector[])((Object[])new Selector[]{new SuiteSelector()}));
            }
            throw new MatchError((Object)tuple2);
        }).toVector();
        Task[] initialTasks = runner.tasks((TaskDef[])taskDefs.toArray(ClassTag$.MODULE$.apply(TaskDef.class)));
        Seq<Event> events = TestRunner$.MODULE$.runTasks((Seq<Task>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)initialTasks), out);
        boolean failed = events.exists((Function1 & Serializable)ev -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$main$11(ev)));
        String doneMsg = runner.done();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(doneMsg))) {
            out.println(doneMsg);
        }
        if (requireTests2 && events.isEmpty()) {
            System.err.println("Error: no tests were run.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (failed) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$matchFingerprints$1(Constructor c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$matchFingerprints$4(Class annotationCls$1, Method m) {
        return m.isAnnotationPresent(annotationCls$1) && Modifier.isPublic(m.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$matchFingerprints$2(boolean isModule$1, ClassLoader loader$1, Class cls$1, Fingerprint x0$1) {
        Fingerprint fingerprint = x0$1;
        if (fingerprint instanceof SubclassFingerprint) {
            SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
            return subclassFingerprint.isModule() == isModule$1 && loader$1.loadClass(subclassFingerprint.superclassName()).isAssignableFrom(cls$1);
        }
        if (fingerprint instanceof AnnotatedFingerprint) {
            AnnotatedFingerprint annotatedFingerprint = (AnnotatedFingerprint)fingerprint;
            Class<?> annotationCls = loader$1.loadClass(annotatedFingerprint.annotationName());
            return annotatedFingerprint.isModule() == isModule$1 && (cls$1.isAnnotationPresent(annotationCls) || ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])cls$1.getDeclaredMethods()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isAnnotationPresent(annotationCls))) || ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])cls$1.getMethods()), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$matchFingerprints$4(annotationCls, m))));
        }
        throw new MatchError((Object)fingerprint);
    }

    public static final /* synthetic */ boolean $anonfun$listClasses$1(Path x$2) {
        return ((Object)x$2.getFileName()).toString().endsWith(".class");
    }

    public static final /* synthetic */ boolean $anonfun$listClasses$6(ZipEntry x$5) {
        return x$5.getName().endsWith(".class");
    }

    private static final boolean isAbstract$1(Class cls$2) {
        return Modifier.isAbstract(cls$2.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$findFramework$4(Constructor c) {
        return Modifier.isPublic(c.getModifiers()) && c.getParameterCount() == 0;
    }

    private static final int publicConstructorCount$1(Class cls$2) {
        return ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])cls$2.getConstructors()), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$findFramework$4(c)));
    }

    public static final /* synthetic */ Object $anonfun$globPattern$1(StringBuilder b$1, String[] a$1, int i) {
        Object object = i != 0 ? b$1.append(".*") : BoxedUnit.UNIT;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(a$1[i]))) {
            return b$1.append(Pattern.quote(a$1[i].replaceAll("\n", "\\n")));
        }
        return BoxedUnit.UNIT;
    }

    private final Tuple5 parse$1(Option testFrameworkOpt, List reverseTestArgs, boolean requireTests, int verbosity, Option testOnly, List args) {
        List list;
        while (true) {
            boolean bl = false;
            .colon.colon colon2 = null;
            list = args;
            if (Nil$.MODULE$.equals(list)) {
                return new Tuple5((Object)testFrameworkOpt, (Object)BoxesRunTime.boxToBoolean((boolean)requireTests), (Object)BoxesRunTime.boxToInteger((int)verbosity), (Object)testOnly, (Object)reverseTestArgs.reverse());
            }
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                String string = (String)colon2.head();
                List t = colon2.next$access$1();
                if ("--".equals(string)) {
                    List list2 = reverseTestArgs.reverse();
                    return new Tuple5((Object)testFrameworkOpt, (Object)BoxesRunTime.boxToBoolean((boolean)requireTests), (Object)BoxesRunTime.boxToInteger((int)verbosity), (Object)testOnly, (Object)t.$colon$colon$colon(list2));
                }
            }
            if (bl) {
                String h = (String)colon2.head();
                List t = colon2.next$access$1();
                if (h.startsWith("--test-framework=")) {
                    args = t;
                    testFrameworkOpt = new Some((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(h), "--test-framework="));
                    continue;
                }
            }
            if (bl) {
                String h = (String)colon2.head();
                List t = colon2.next$access$1();
                if (h.startsWith("--test-only=")) {
                    args = t;
                    testOnly = new Some((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(h), "--test-only="));
                    continue;
                }
            }
            if (bl) {
                String h = (String)colon2.head();
                List t = colon2.next$access$1();
                if (h.startsWith("--verbosity=")) {
                    args = t;
                    verbosity = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(h), "--verbosity=")));
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List t = colon2.next$access$1();
                if ("--require-tests".equals(string)) {
                    args = t;
                    requireTests = true;
                    continue;
                }
            }
            if (!bl) break;
            String h = (String)colon2.head();
            List t = colon2.next$access$1();
            String string = h;
            args = t;
            reverseTestArgs = reverseTestArgs.$colon$colon((Object)string);
        }
        throw new MatchError((Object)list);
    }

    private final Iterator classes$1(Seq classPath0$1, ClassLoader classLoader$1) {
        boolean keepJars = false;
        return this.listClasses((Seq<Path>)classPath0$1, keepJars).map((Function1 & Serializable)name -> classLoader$1.loadClass((String)name));
    }

    private final Iterator clsFingerprints$1(ClassLoader classLoader$1, Fingerprint[] fingerprints$1, Seq classPath0$1) {
        return this.classes$1(classPath0$1, classLoader$1).flatMap((Function1 & Serializable)cls -> MODULE$.matchFingerprints(classLoader$1, (Class<?>)cls, fingerprints$1).map((Function1 & Serializable)x$9 -> new Tuple2(cls, x$9)).iterator());
    }

    public static final /* synthetic */ boolean $anonfun$main$9(Class cls$4, String pattern) {
        return MODULE$.globPattern(pattern).matcher(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(cls$4.getName()), "$")).matches();
    }

    public static final /* synthetic */ boolean $anonfun$main$8(Option testOnly$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Class cls = (Class)tuple2._1();
            return testOnly$1.forall((Function1 & Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)DynamicTestRunner$.$anonfun$main$9(cls, pattern)));
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$main$11(Event ev) {
        Status status = ev.status();
        Status status2 = Status.Error;
        if (status == null) {
            if (status2 == null) return true;
        } else if (status.equals(status2)) return true;
        Status status3 = ev.status();
        Status status4 = Status.Failure;
        if (status3 == null) {
            if (status4 == null) return true;
        } else if (status3.equals(status4)) return true;
        Status status5 = ev.status();
        Status status6 = Status.Canceled;
        if (status5 != null) {
            if (!status5.equals(status6)) return false;
            return true;
        }
        if (status6 == null) return true;
        return false;
    }

    private DynamicTestRunner$() {
    }
}

