/*
 * Decompiled with CFR 0.152.
 */
package scala.build.testrunner;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.build.testrunner.TestRunner$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class DynamicTestRunner$
implements Serializable {
    public static final DynamicTestRunner$ MODULE$ = new DynamicTestRunner$();

    private DynamicTestRunner$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DynamicTestRunner$.class);
    }

    private Option<Fingerprint> matchFingerprints(ClassLoader loader, Class<?> cls, Fingerprint[] fingerprints) {
        boolean definitelyNoTests;
        boolean isModule = cls.getName().endsWith("$");
        Object object = Predef$.MODULE$.refArrayOps((Object[])cls.getConstructors());
        int publicConstructorCount = ArrayOps$.MODULE$.count$extension(object, (Function1 & Serializable)c -> Modifier.isPublic(c.getModifiers()));
        boolean noPublicConstructors = publicConstructorCount == 0;
        boolean bl = definitelyNoTests = Modifier.isAbstract(cls.getModifiers()) || cls.isInterface() || publicConstructorCount > 1 || isModule != noPublicConstructors;
        if (definitelyNoTests) {
            return None$.MODULE$;
        }
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])fingerprints);
        return ArrayOps$.MODULE$.find$extension(object2, (Function1 & Serializable)x$1 -> {
            Fingerprint fingerprint = x$1;
            if (fingerprint instanceof SubclassFingerprint) {
                SubclassFingerprint f = (SubclassFingerprint)fingerprint;
                return f.isModule() == isModule && loader.loadClass(f.superclassName()).isAssignableFrom(cls);
            }
            if (fingerprint instanceof AnnotatedFingerprint) {
                Object object;
                Object object2;
                AnnotatedFingerprint f = (AnnotatedFingerprint)fingerprint;
                Class<?> annotationCls = loader.loadClass(f.annotationName());
                return f.isModule() == isModule && (cls.isAnnotationPresent(annotationCls) || ArrayOps$.MODULE$.exists$extension(object2 = Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredMethods()), (Function1 & Serializable)_$1 -> _$1.isAnnotationPresent(annotationCls)) || ArrayOps$.MODULE$.exists$extension(object = Predef$.MODULE$.refArrayOps((Object[])cls.getMethods()), (Function1 & Serializable)m -> m.isAnnotationPresent(annotationCls) && Modifier.isPublic(m.getModifiers())));
            }
            throw new MatchError((Object)fingerprint);
        });
    }

    public Iterator<String> listClasses(Path classPathEntry, boolean keepJars) {
        if (Files.isDirectory(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            try (Stream<Path> stream = null;){
                stream = Files.walk(classPathEntry, Integer.MAX_VALUE, new FileVisitOption[0]);
                iterator = CollectionConverters$.MODULE$.IteratorHasAsScala(stream.iterator()).asScala().filter((Function1 & Serializable)_$2 -> _$2.getFileName().toString().endsWith(".class")).map((Function1 & Serializable)_$3 -> classPathEntry.relativize((Path)_$3)).map((Function1 & Serializable)p -> {
                    int count = p.getNameCount();
                    return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)x$0 -> this.listClasses$$anonfun$3$$anonfun$1((Path)p, BoxesRunTime.unboxToInt((Object)x$0))).mkString(".");
                }).map((Function1 & Serializable)_$4 -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(_$4), ".class")).toVector().iterator();
            }
            return iterator;
        }
        if (keepJars && Files.isRegularFile(classPathEntry, new LinkOption[0])) {
            Iterator iterator;
            try (ZipFile zf = null;){
                zf = new ZipFile(classPathEntry.toFile());
                iterator = CollectionConverters$.MODULE$.EnumerationHasAsScala(zf.entries()).asScala().filter((Function1 & Serializable)_$5 -> _$5.getName().endsWith(".class")).map((Function1 & Serializable)ent -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(ent.getName()), ".class").replace("/", ".")).toVector().iterator();
            }
            return iterator;
        }
        return package$.MODULE$.Iterator().empty();
    }

    public Iterator<String> listClasses(Seq<Path> classPath, boolean keepJars) {
        return classPath.iterator().flatMap((Function1 & Serializable)_$6 -> this.listClasses((Path)_$6, keepJars));
    }

    public Option<Framework> findFrameworkService(ClassLoader loader) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(ServiceLoader.load(Framework.class, loader).iterator()).asScala().take(1).toList().headOption();
    }

    public Framework loadFramework(ClassLoader loader, String className) {
        Class<?> cls = loader.loadClass(className);
        Constructor<?> constructor = cls.getConstructor(new Class[0]);
        return (Framework)constructor.newInstance(new Object[0]);
    }

    public Option<Framework> findFramework(Seq<Path> classPath, ClassLoader loader, Seq<String> preferredClasses) {
        Class<Framework> frameworkCls = Framework.class;
        return preferredClasses.iterator().$plus$plus(() -> this.findFramework$$anonfun$1(classPath)).flatMap((Function1 & Serializable)name -> {
            Iterator iterator;
            try {
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{loader.loadClass((String)name)}));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ClassNotFoundException || throwable2 instanceof UnsupportedClassVersionError || throwable2 instanceof NoClassDefFoundError || throwable2 instanceof IncompatibleClassChangeError) {
                    iterator = package$.MODULE$.Iterator().empty();
                }
                throw throwable;
            }
            Iterator it = iterator;
            return it;
        }).flatMap((Function1 & Serializable)cls -> {
            Iterator it = frameworkCls.isAssignableFrom((Class<?>)cls) && !this.isAbstract$1((Class)cls) && this.publicConstructorCount$1((Class)cls) == 1 ? package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{cls})) : package$.MODULE$.Iterator().empty();
            return it;
        }).flatMap((Function1 & Serializable)cls -> {
            Iterator iterator;
            try {
                Constructor constructor = cls.getConstructor(new Class[0]);
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Framework[]{(Framework)constructor.newInstance(new Object[0])}));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                iterator = package$.MODULE$.Iterator().empty();
            }
            return iterator;
        }).take(1).toList().headOption();
    }

    private Pattern globPattern(String expr) {
        String[] a = expr.split("\\*", -1);
        StringBuilder b = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), a.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (i != 0) {
                b.append(".*");
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(a[i]))) {
                b.append(Pattern.quote(a[i].replaceAll("\n", "\\n")));
                return;
            }
        });
        return Pattern.compile(b.toString());
    }

    public void main(String[] args) {
        Tuple5 tuple5 = this.parse$1((Option)None$.MODULE$, (List)package$.MODULE$.Nil(), false, 0, (Option)None$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])args).toList());
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Option testFrameworkOpt = (Option)tuple5._1();
        boolean requireTests = BoxesRunTime.unboxToBoolean((Object)tuple5._2());
        int verbosity = BoxesRunTime.unboxToInt((Object)tuple5._3());
        Option testOnly = (Option)tuple5._4();
        List args0 = (List)tuple5._5();
        Tuple5 tuple52 = Tuple5$.MODULE$.apply((Object)testFrameworkOpt, (Object)BoxesRunTime.boxToBoolean((boolean)requireTests), (Object)BoxesRunTime.boxToInteger((int)verbosity), (Object)testOnly, (Object)args0);
        Option testFrameworkOpt2 = (Option)tuple52._1();
        boolean requireTests2 = BoxesRunTime.unboxToBoolean((Object)tuple52._2());
        int verbosity2 = BoxesRunTime.unboxToInt((Object)tuple52._3());
        Option testOnly2 = (Option)tuple52._4();
        List args02 = (List)tuple52._5();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Seq<Path> classPath0 = TestRunner$.MODULE$.classPath(classLoader);
        Framework framework = (Framework)testFrameworkOpt2.map((Function1 & Serializable)_$7 -> this.loadFramework(classLoader, (String)_$7)).orElse(() -> this.$anonfun$3(classLoader)).orElse(() -> this.$anonfun$4(classPath0, classLoader)).getOrElse(() -> this.$anonfun$5(verbosity2));
        PrintStream out = System.out;
        Fingerprint[] fingerprints = framework.fingerprints();
        Runner runner = framework.runner((String[])args02.toArray(ClassTag$.MODULE$.apply(String.class)), new String[0], classLoader);
        Vector taskDefs = this.clsFingerprints$1(classLoader, fingerprints, classPath0).filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Class cls = (Class)tuple2._1();
                return testOnly2.forall((Function1 & Serializable)pattern -> this.globPattern((String)pattern).matcher(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(cls.getName()), "$")).matches());
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Class cls = (Class)tuple2._1();
                Fingerprint fp = (Fingerprint)tuple2._2();
                return new TaskDef(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(cls.getName()), "$"), fp, false, new Selector[]{new SuiteSelector()});
            }
            throw new MatchError((Object)tuple2);
        }).toVector();
        Task[] initialTasks = runner.tasks((TaskDef[])taskDefs.toArray(ClassTag$.MODULE$.apply(TaskDef.class)));
        Seq<Event> events = TestRunner$.MODULE$.runTasks((Seq<Task>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)initialTasks), out);
        boolean failed = events.exists((Function1 & Serializable)ev -> {
            Status status = ev.status();
            Status status2 = Status.Error;
            if (status == null) {
                if (status2 == null) return true;
            } else if (status.equals(status2)) return true;
            Status status3 = ev.status();
            Status status4 = Status.Failure;
            if (status3 == null) {
                if (status4 == null) return true;
            } else if (status3.equals(status4)) return true;
            Status status5 = ev.status();
            Status status6 = Status.Canceled;
            if (status5 != null) {
                if (!status5.equals(status6)) return false;
                return true;
            }
            if (status6 == null) return true;
            return false;
        });
        String doneMsg = runner.done();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(doneMsg))) {
            out.println(doneMsg);
        }
        if (requireTests2 && events.isEmpty()) {
            System.err.println("Error: no tests were run.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (failed) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
    }

    private final /* synthetic */ Path listClasses$$anonfun$3$$anonfun$1(Path p$1, int x$0) {
        return p$1.getName(x$0);
    }

    private final IterableOnce findFramework$$anonfun$1(Seq classPath$1) {
        return this.listClasses((Seq<Path>)classPath$1, true);
    }

    private final boolean isAbstract$1(Class cls$2) {
        return Modifier.isAbstract(cls$2.getModifiers());
    }

    private final int publicConstructorCount$1(Class cls$3) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])cls$3.getConstructors());
        return ArrayOps$.MODULE$.count$extension(object, (Function1 & Serializable)c -> Modifier.isPublic(c.getModifiers()) && c.getParameterCount() == 0);
    }

    private final Tuple5 parse$1(Option testFrameworkOpt, List reverseTestArgs, boolean requireTests, int verbosity, Option testOnly, List args) {
        List list;
        while (true) {
            list = args;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return Tuple5$.MODULE$.apply((Object)testFrameworkOpt, (Object)BoxesRunTime.boxToBoolean((boolean)requireTests), (Object)BoxesRunTime.boxToInteger((int)verbosity), (Object)testOnly, (Object)reverseTestArgs.reverse());
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list3 = colon2.next$access$1();
            if ("--".equals(string)) {
                List t = list3;
                List list4 = reverseTestArgs.reverse();
                return Tuple5$.MODULE$.apply((Object)testFrameworkOpt, (Object)BoxesRunTime.boxToBoolean((boolean)requireTests), (Object)BoxesRunTime.boxToInteger((int)verbosity), (Object)testOnly, (Object)t.$colon$colon$colon(list4));
            }
            String h = string;
            List t = list3;
            if (h.startsWith("--test-framework=")) {
                Some some = Some$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(h), "--test-framework="));
                List list5 = t;
                testFrameworkOpt = some;
                args = list5;
                continue;
            }
            String h2 = string;
            List t2 = list3;
            if (h2.startsWith("--test-only=")) {
                Some some = Some$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(h2), "--test-only="));
                List list6 = t2;
                testOnly = some;
                args = list6;
                continue;
            }
            String h3 = string;
            List t3 = list3;
            if (h3.startsWith("--verbosity=")) {
                int n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(h3), "--verbosity=")));
                List list7 = t3;
                verbosity = n;
                args = list7;
                continue;
            }
            if ("--require-tests".equals(string)) {
                List t4 = list3;
                boolean bl = true;
                List list8 = t4;
                requireTests = bl;
                args = list8;
                continue;
            }
            String h4 = string;
            List t5 = list3;
            List list9 = reverseTestArgs.$colon$colon((Object)h4);
            List list10 = t5;
            reverseTestArgs = list9;
            args = list10;
        }
        throw new MatchError((Object)list);
    }

    private final Option $anonfun$3(ClassLoader classLoader$2) {
        return this.findFrameworkService(classLoader$2);
    }

    private final Option $anonfun$4(Seq classPath0$1, ClassLoader classLoader$3) {
        return this.findFramework((Seq<Path>)classPath0$1, classLoader$3, TestRunner$.MODULE$.commonTestFrameworks());
    }

    private final Framework $anonfun$5(int verbosity$1) {
        if (verbosity$1 >= 2) {
            throw scala.sys.package$.MODULE$.error("No test framework found");
        }
        System.err.println("No test framework found");
        throw scala.sys.package$.MODULE$.exit(1);
    }

    private final Iterator classes$1(Seq classPath0$2, ClassLoader classLoader$4) {
        boolean keepJars = false;
        return this.listClasses((Seq<Path>)classPath0$2, keepJars).map((Function1 & Serializable)name -> classLoader$4.loadClass((String)name));
    }

    private final Iterator clsFingerprints$1(ClassLoader classLoader$6, Fingerprint[] fingerprints$1, Seq classPath0$3) {
        return this.classes$1(classPath0$3, classLoader$6).flatMap((Function1 & Serializable)cls -> this.matchFingerprints(classLoader$6, (Class<?>)cls, fingerprints$1).map((Function1 & Serializable)_$8 -> Tuple2$.MODULE$.apply(cls, _$8)).iterator());
    }
}

