package org.vraptor.spring.logic;

import org.vraptor.annotations.Component;
import org.vraptor.spring.model.SystemUser;
import org.vraptor.spring.model.User;

/**
 * Classe HomeComponent / component name: user
 * 
 * Exemplo para mostrar a injeção de objetos pelo Spring.
 * 
 * Somente tem uma lógica para chamar o view.
 */
@Component("user")
public class HomeComponent {

	private final SystemUser user;

	/**
	 * Injeção do SystemUser pelo Spring.
	 * @param user
	 */
	public HomeComponent(SystemUser user) {
		this.user = user;
	}

	/**
	 * URL: user.home.login
	 * View: user.home.ok (user/home.ok.jsp)
	 *
	 * Unica função é chamar o view ....
	 */
	public void home() {
	}
	
	/**
	 * Ejeção do user.
	 * 
	 * @return
	 */
	public User getUser() {
		return user.getUser();
	}

}
