package org.vraptor.spring.model;

import java.util.HashSet;

/**
 *	Essa classe representa o Spring bean. 
 *
 *  Ela deve ser registrada no applicationContext.xml.
 *
 *	Ela somente cria alguns valores que serão mostrados no user/home.ok.jsp.
 */
public class SystemUser {

	private final User user;

	public SystemUser() {

		HashSet<Dvd> dvds = new HashSet<Dvd>();

		dvds.add(createDvd(1L, "Reverence", "Faithless", DvdType.MUSIC));
		dvds.add(createDvd(2L, "Alegria", "Cirque Du Soleil", DvdType.VIDEO));

		this.user = new User();
		this.user.setName("Guilherme Silveira");
		this.user.setLogin("guilherme");
		this.user.setDvds(dvds);

	}

	private Dvd createDvd(Long id, String title, String desc, DvdType type) {
		Dvd dvd = new Dvd();
		dvd.setId(id);
		dvd.setTitle(title);
		dvd.setDescription(desc);
		dvd.setType(type);
		return dvd;
	}

	public User getUser() {
		return user;
	}
	
	//injected through spring
	public void setDvd(Dvd dvd) {
		this.user.getDvds().add(dvd);
	}

}
