/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client.oauth;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownServiceException;
import org.vx68k.bitbucket.api.client.Client;
import org.vx68k.bitbucket.api.client.Service;
import org.vx68k.bitbucket.api.client.oauth.OAuthCredentials;

public class OAuthClient
extends Client {
    private static final long serialVersionUID = 4L;
    private OAuthCredentials credentials;
    private static final String AUTHORIZATION_ENDPOINT = "https://bitbucket.org/site/oauth2/authorize";
    private static final String TOKEN_ENDPOINT = "https://bitbucket.org/site/oauth2/access_token";
    private static final String BEARER_TOKEN_TYPE = "bearer";

    public OAuthClient() {
    }

    public OAuthClient(String clientId, String clientSecret) {
        this(new OAuthCredentials(clientId, clientSecret));
    }

    public OAuthClient(OAuthCredentials credentials) {
        this.setCredentials(credentials);
    }

    public OAuthCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(OAuthCredentials credentials) {
        this.credentials = credentials;
    }

    public URI getAuthorizationEndpoint(URI redirectionEndpoint, String state) throws URISyntaxException {
        AuthorizationCodeFlow flow = this.getAuthorizationCodeFlow(false);
        AuthorizationCodeRequestUrl request = flow.newAuthorizationUrl();
        if (redirectionEndpoint != null) {
            request.setRedirectUri(redirectionEndpoint.toString());
        }
        if (state != null) {
            request.setState(state);
        }
        return new URI(request.build());
    }

    public Service getService(String authorizationCode, URI redirectionEndpoint) throws IOException {
        TokenResponse tokenResponse;
        String tokenType;
        AuthorizationCodeFlow flow = this.getAuthorizationCodeFlow(true);
        AuthorizationCodeTokenRequest request = flow.newTokenRequest(authorizationCode);
        if (redirectionEndpoint != null) {
            request.setRedirectUri(redirectionEndpoint.toString());
        }
        if (!(tokenType = (tokenResponse = request.execute()).getTokenType()).equals(BEARER_TOKEN_TYPE)) {
            throw new UnknownServiceException("Unsupported token type");
        }
        return new Client.RestService((Client)this, (HttpExecuteInterceptor)flow.createAndStoreCredential(tokenResponse, this.getUser()));
    }

    protected AuthorizationCodeFlow getAuthorizationCodeFlow(boolean forTokenRequest) {
        if (this.credentials == null) {
            throw new NullPointerException("No OAuth client credentials");
        }
        HttpExecuteInterceptor clientAuthentication = forTokenRequest ? this.getBasicAuthentication() : this.getClientParameters();
        return new AuthorizationCodeFlow(BearerToken.authorizationHeaderAccessMethod(), OAuthClient.getHttpTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), new GenericUrl(TOKEN_ENDPOINT), clientAuthentication, this.credentials.getId(), AUTHORIZATION_ENDPOINT);
    }

    protected HttpExecuteInterceptor getClientParameters() {
        return new ClientParametersAuthentication(this.credentials.getId(), null);
    }

    protected HttpExecuteInterceptor getBasicAuthentication() {
        return new BasicAuthentication(this.credentials.getId(), this.credentials.getSecret());
    }
}

