/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client.oauth;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.enterprise.event.Observes;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.vx68k.bitbucket.api.client.Service;
import org.vx68k.bitbucket.api.client.oauth.OAuthClient;
import org.vx68k.bitbucket.api.client.oauth.OAuthRedirection;

public abstract class OAuthUser
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private transient URI redirectionEndpoint;
    private transient Service bitbucketService;

    protected OAuthUser() {
    }

    protected abstract OAuthClient getBitbucketClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getBitbucketService() {
        OAuthUser oAuthUser = this;
        synchronized (oAuthUser) {
            if (this.bitbucketService == null) {
                OAuthClient bitbucketClient = this.getBitbucketClient();
                this.bitbucketService = bitbucketClient.getService();
            }
        }
        return this.bitbucketService;
    }

    protected URI getAuthorizationEndpoint(HttpServletRequest request) throws URISyntaxException, IOException {
        this.redirectionEndpoint = new URI(request.getScheme(), null, request.getServerName(), OAuthUser.getExplicitServerPort(request), OAuthUser.getRedirectionPath(request), null, null);
        HttpSession session = request.getSession();
        OAuthClient bitbucketClient = this.getBitbucketClient();
        return bitbucketClient.getAuthorizationEndpoint(this.redirectionEndpoint, session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestToken(@Observes OAuthRedirection redirection) throws IOException {
        String state;
        HttpServletRequest request = redirection.getRequest();
        HttpSession session = request.getSession(false);
        if (session != null && (state = request.getParameter("state")) != null && state.equals(session.getId())) {
            HttpServletResponse response = redirection.getResponse();
            String authorizationCode = request.getParameter("code");
            if (authorizationCode != null) {
                OAuthClient bitbucketClient = this.getBitbucketClient();
                OAuthUser oAuthUser = this;
                synchronized (oAuthUser) {
                    this.bitbucketService = bitbucketClient.getService(authorizationCode, this.redirectionEndpoint);
                }
                StringBuilder path = new StringBuilder(request.getContextPath());
                if (request.getPathInfo() != null) {
                    path.append(request.getPathInfo());
                }
                response.sendRedirect(path.toString());
            } else {
                response.sendError(401);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBitbucketService() {
        OAuthUser oAuthUser = this;
        synchronized (oAuthUser) {
            this.bitbucketService = null;
        }
    }

    protected static int getExplicitServerPort(HttpServletRequest request) {
        int port = request.getServerPort();
        if (port == 80 && request.getScheme().equals(HTTP_SCHEME)) {
            return -1;
        }
        if (port == 443 && request.getScheme().equals(HTTPS_SCHEME)) {
            port = -1;
        }
        return port;
    }

    protected static String getRedirectionPath(HttpServletRequest request) {
        StringBuilder path = new StringBuilder(request.getContextPath());
        path.append("/authorized");
        if (request.getServletPath() != null) {
            path.append(request.getServletPath());
        }
        if (request.getPathInfo() != null) {
            path.append(request.getPathInfo());
        }
        return path.toString();
    }
}

