/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import javax.json.Json;
import javax.json.JsonReader;
import org.vx68k.bitbucket.api.client.Service;
import org.vx68k.bitbucket.api.client.User;

public class Client
implements Serializable {
    private static final long serialVersionUID = 4L;
    private static final HttpTransport httpTransport = new NetHttpTransport();
    private String user;
    private String password;

    public Client() {
    }

    public Client(String user, String password) {
        this.setUser(user);
        this.setPassword(password);
    }

    protected static HttpTransport getHttpTransport() {
        return httpTransport;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Service getService() {
        if (this.user != null && this.password != null) {
            return this.getService(this.user, this.password);
        }
        return new RestService(null);
    }

    public Service getService(String user, String password) {
        return new RestService((HttpExecuteInterceptor)new BasicAuthentication(user, password));
    }

    protected class RestService
    extends Service {
        private static final String API_ROOT = "https://api.bitbucket.org/";
        private static final String USER_ENDPOINT_PATH = "/2.0/user";
        private static final String USERS_ENDPOINT_PATH = "/2.0/users";
        private final HttpRequestFactory requestFactory = Client.getHttpTransport().createRequestFactory();
        private final HttpExecuteInterceptor authentication;
        private User currentUser;

        public RestService(HttpExecuteInterceptor authentication) {
            this.authentication = authentication;
        }

        protected URI getEndpoint(String path) {
            URI root = URI.create(API_ROOT);
            return root.resolve(URI.create(path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCurrentUser() {
            RestService restService = this;
            synchronized (restService) {
                this.currentUser = null;
            }
        }

        protected User getUser(HttpResponse response) throws IOException {
            JsonReader reader = Json.createReader((InputStream)response.getContent());
            return new User(reader.readObject());
        }

        @Override
        public boolean isAuthenticated() {
            try {
                return this.getCurrentUser() != null;
            }
            catch (IOException exception) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public User getCurrentUser() throws IOException {
            if (this.authentication == null) {
                return null;
            }
            RestService restService = this;
            synchronized (restService) {
                if (this.currentUser == null) {
                    URI endpoint = this.getEndpoint(USER_ENDPOINT_PATH);
                    HttpRequest request = this.requestFactory.buildGetRequest(new GenericUrl(endpoint.toString()));
                    request.setInterceptor(this.authentication);
                    this.currentUser = this.getUser(request.execute());
                }
            }
            return this.currentUser;
        }

        @Override
        public User getUser(String name) throws IOException {
            if (name.contains("/")) {
                throw new IllegalArgumentException("User name must not contains a \"/\"");
            }
            URI endpoint = this.getEndpoint("/2.0/users/" + name);
            HttpRequest request = this.requestFactory.buildGetRequest(new GenericUrl(endpoint.toString()));
            request.setInterceptor(this.authentication);
            return this.getUser(request.execute());
        }
    }
}

