/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;

public class ClientUtilities {
    private static final String PACKAGE_NAME = ClientUtilities.class.getPackage().getName();

    private ClientUtilities() {
    }

    public static Logger getLogger() {
        return Logger.getLogger(PACKAGE_NAME, PACKAGE_NAME + ".resources.LogMessages");
    }

    public static UUID parseUUID(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            string = string.substring(1, string.length() - 1);
        }
        return UUID.fromString(string);
    }

    public static Map<String, URL> parseLinks(JsonObject jsonObject) {
        HashMap<String, URL> links = new HashMap<String, URL>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            try {
                URL link = ClientUtilities.parseLink((JsonObject)entry.getValue());
                links.put((String)entry.getKey(), link);
            }
            catch (MalformedURLException exception) {
                ClientUtilities.getLogger().log(Level.WARNING, "Could not parse a URL value", exception);
            }
        }
        return links;
    }

    protected static URL parseLink(JsonObject jsonObject) throws MalformedURLException {
        return ClientUtilities.parseURL(jsonObject.getString("href"));
    }

    public static URL parseURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        return new URL(string);
    }
}

