/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.json.JsonObject;
import org.vx68k.bitbucket.api.client.ClientUtilities;
import org.vx68k.bitbucket.api.client.Entity;
import org.vx68k.bitbucket.api.client.User;

public class Repository
extends Entity {
    private static final String REPOSITORY_TYPE = "repository";
    private UUID uuid;
    private User owner;
    private String name;
    private String fullName;
    private String scm;
    private boolean Private;
    private Map<String, URL> links;

    public Repository() {
        super(REPOSITORY_TYPE);
        ClientUtilities.getLogger().finer("Creating a blank Repository");
    }

    public Repository(JsonObject jsonObject) {
        super(jsonObject);
        if (!this.getType().equals(REPOSITORY_TYPE)) {
            throw new IllegalArgumentException("Type is not \"repository\"");
        }
        ClientUtilities.getLogger().log(Level.INFO, "Parsing JSON object (\"repository\"): {0}", jsonObject);
        this.uuid = ClientUtilities.parseUUID(jsonObject.getString("uuid"));
        this.owner = new User(jsonObject.getJsonObject("owner"));
        this.name = jsonObject.getString("name");
        this.fullName = jsonObject.getString("full_name");
        this.scm = jsonObject.getString("scm");
        this.Private = jsonObject.getBoolean("is_private");
        this.links = ClientUtilities.parseLinks(jsonObject.getJsonObject("links"));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public User getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getScm() {
        return this.scm;
    }

    public boolean isPrivate() {
        return this.Private;
    }

    public Map<String, URL> getLinks() {
        return this.links;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setOwner(User owner) {
        this.owner = owner;
        this.updateFullName();
    }

    public void setName(String name) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("Repository name must not contain a \"/\"");
        }
        this.name = name;
        this.updateFullName();
    }

    public void setScm(String scm) {
        this.scm = scm;
    }

    public void setPrivate(boolean Private) {
        this.Private = Private;
    }

    public void setLinks(Map<String, URL> links) {
        this.links = links;
    }

    protected void updateFullName() {
        if (this.owner != null && this.name != null && this.owner.getName() != null) {
            this.fullName = this.owner.getName() + "/" + this.name;
        }
    }
}

