/*
 * Decompiled with CFR 0.152.
 */
package org.vx68k.bitbucket.api.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.json.JsonObject;
import org.vx68k.bitbucket.api.client.ClientUtilities;
import org.vx68k.bitbucket.api.client.Entity;

public class User
extends Entity {
    private static final String USER_TYPE = "user";
    private UUID uuid;
    private String name;
    private String displayName;
    private Map<String, URL> links;
    private URL website;
    private String location;
    private Date created;

    public User() {
        super(USER_TYPE);
        ClientUtilities.getLogger().finer("Creating a blank User");
    }

    public User(JsonObject jsonObject) {
        super(jsonObject);
        if (!this.getType().equals(USER_TYPE)) {
            throw new IllegalArgumentException("Type is not \"user\"");
        }
        ClientUtilities.getLogger().log(Level.INFO, "Parsing JSON object (\"user\"): {0}", jsonObject);
        this.uuid = ClientUtilities.parseUUID(jsonObject.getString("uuid"));
        this.name = jsonObject.getString("username");
        this.displayName = jsonObject.getString("display_name");
        this.links = ClientUtilities.parseLinks(jsonObject.getJsonObject("links"));
        try {
            this.website = ClientUtilities.parseURL(jsonObject.getString("website", null));
        }
        catch (MalformedURLException exception) {
            ClientUtilities.getLogger().log(Level.WARNING, "Could not parse the \"website\" value", exception);
        }
        this.location = jsonObject.getString("location", null);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, URL> getLinks() {
        return this.links;
    }

    public URL getWebsite() {
        return this.website;
    }

    public String getLocation() {
        return this.location;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setLinks(Map<String, URL> links) {
        this.links = links;
    }

    public void setWebsite(URL website) {
        this.website = website;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == User.class) {
            User user = (User)object;
            if (this.uuid != null) {
                return this.uuid.equals(user.getUuid());
            }
            if (user.getUuid() != null) {
                return false;
            }
            if (this.name != null) {
                return this.name.equals(user.getName());
            }
            return user.getName() == null;
        }
        return false;
    }

    public int hashCode() {
        int code = this.getClass().hashCode();
        if (this.uuid != null) {
            code ^= this.uuid.hashCode();
        } else if (this.name != null) {
            code ^= this.name.hashCode();
        }
        return code;
    }
}

