/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.sf.saxon.om.NameChecker;

public final class HTMLUtils {
    private static final Set<String> KNOWN_XHTML_NAMESPACES = ImmutableSet.of((Object)"http://www.w3.org/1999/xhtml", (Object)"http://www.w3.org/XML/1998/namespace", (Object)"http://www.idpf.org/2007/ops", (Object)"http://www.w3.org/2000/svg", (Object)"http://www.w3.org/1998/Math/MathML", (Object)"http://www.w3.org/2001/10/synthesis", (Object[])new String[]{"http://www.w3.org/2001/xml-events", "http://www.w3.org/1999/xlink"});
    private static final Set<String> CASE_INSENSITIVE_ATTRIBUTES = ImmutableSet.builder().add((Object)"align").add((Object)"allowfullscreen").add((Object)"allowpaymentrequest").add((Object)"allowusermedia").add((Object)"async").add((Object)"autocapitalize").add((Object)"autocomplete").add((Object)"autofocus").add((Object)"autoplay").add((Object)"checked").add((Object)"contenteditable").add((Object)"controls").add((Object)"crossorigin").add((Object)"default").add((Object)"defer").add((Object)"dir").add((Object)"disabled").add((Object)"draggable").add((Object)"formnovalidate").add((Object)"hidden").add((Object)"http-equiv").add((Object)"ismap").add((Object)"itemscope").add((Object)"kind").add((Object)"loop").add((Object)"multiple").add((Object)"muted").add((Object)"nomodule").add((Object)"novalidate").add((Object)"open").add((Object)"playsinline").add((Object)"preload").add((Object)"readonly").add((Object)"required").add((Object)"reversed").add((Object)"scope").add((Object)"selected").add((Object)"shape").add((Object)"sizes").add((Object)"spellcheck").add((Object)"step").add((Object)"translate").add((Object)"type").add((Object)"typemustmatch").add((Object)"valign").add((Object)"value").add((Object)"wrap").build();

    public static boolean isCustomElement(String namespace, String name) {
        return "http://www.w3.org/1999/xhtml".equals(namespace) && ((String)Preconditions.checkNotNull((Object)name)).contains("-");
    }

    public static boolean isCustomNamespace(String namespace) {
        return namespace != null && !namespace.trim().isEmpty() && !KNOWN_XHTML_NAMESPACES.contains(namespace.trim());
    }

    public static boolean isCaseInsensitiveAttribute(String namespace, String name) {
        return namespace.isEmpty() && CASE_INSENSITIVE_ATTRIBUTES.contains(name);
    }

    public static boolean isDataAttribute(String namespace, String name) {
        return namespace.isEmpty() && name.startsWith("data-");
    }

    public static boolean isITSAttribute(String namespace, String name) {
        return namespace.isEmpty() && name.startsWith("its-");
    }

    public static boolean isValidDataAttribute(String name) {
        Preconditions.checkArgument((name != null && name.startsWith("data-") ? 1 : 0) != 0);
        name = name.substring(5);
        return !name.isEmpty() && NameChecker.isValidNCName((String)name) && !name.matches(".*[A-Z].*");
    }

    private HTMLUtils() {
    }
}

