/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.walkers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.javalang.ast.BlockComment;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.ImportDeclaration;
import org.walkmod.javalang.ast.LineComment;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.PackageDeclaration;
import org.walkmod.javalang.ast.TypeParameter;
import org.walkmod.javalang.ast.body.AnnotationDeclaration;
import org.walkmod.javalang.ast.body.AnnotationMemberDeclaration;
import org.walkmod.javalang.ast.body.ClassOrInterfaceDeclaration;
import org.walkmod.javalang.ast.body.ConstructorDeclaration;
import org.walkmod.javalang.ast.body.EmptyMemberDeclaration;
import org.walkmod.javalang.ast.body.EmptyTypeDeclaration;
import org.walkmod.javalang.ast.body.EnumConstantDeclaration;
import org.walkmod.javalang.ast.body.EnumDeclaration;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.InitializerDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.MultiTypeParameter;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.expr.ArrayAccessExpr;
import org.walkmod.javalang.ast.expr.ArrayCreationExpr;
import org.walkmod.javalang.ast.expr.ArrayInitializerExpr;
import org.walkmod.javalang.ast.expr.AssignExpr;
import org.walkmod.javalang.ast.expr.BinaryExpr;
import org.walkmod.javalang.ast.expr.BooleanLiteralExpr;
import org.walkmod.javalang.ast.expr.CastExpr;
import org.walkmod.javalang.ast.expr.CharLiteralExpr;
import org.walkmod.javalang.ast.expr.ClassExpr;
import org.walkmod.javalang.ast.expr.ConditionalExpr;
import org.walkmod.javalang.ast.expr.DoubleLiteralExpr;
import org.walkmod.javalang.ast.expr.EnclosedExpr;
import org.walkmod.javalang.ast.expr.FieldAccessExpr;
import org.walkmod.javalang.ast.expr.InstanceOfExpr;
import org.walkmod.javalang.ast.expr.IntegerLiteralExpr;
import org.walkmod.javalang.ast.expr.IntegerLiteralMinValueExpr;
import org.walkmod.javalang.ast.expr.LambdaExpr;
import org.walkmod.javalang.ast.expr.LongLiteralExpr;
import org.walkmod.javalang.ast.expr.LongLiteralMinValueExpr;
import org.walkmod.javalang.ast.expr.MarkerAnnotationExpr;
import org.walkmod.javalang.ast.expr.MemberValuePair;
import org.walkmod.javalang.ast.expr.MethodCallExpr;
import org.walkmod.javalang.ast.expr.MethodReferenceExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.expr.NormalAnnotationExpr;
import org.walkmod.javalang.ast.expr.NullLiteralExpr;
import org.walkmod.javalang.ast.expr.ObjectCreationExpr;
import org.walkmod.javalang.ast.expr.QualifiedNameExpr;
import org.walkmod.javalang.ast.expr.SingleMemberAnnotationExpr;
import org.walkmod.javalang.ast.expr.StringLiteralExpr;
import org.walkmod.javalang.ast.expr.SuperExpr;
import org.walkmod.javalang.ast.expr.ThisExpr;
import org.walkmod.javalang.ast.expr.UnaryExpr;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.AssertStmt;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.BreakStmt;
import org.walkmod.javalang.ast.stmt.CatchClause;
import org.walkmod.javalang.ast.stmt.ContinueStmt;
import org.walkmod.javalang.ast.stmt.DoStmt;
import org.walkmod.javalang.ast.stmt.EmptyStmt;
import org.walkmod.javalang.ast.stmt.ExplicitConstructorInvocationStmt;
import org.walkmod.javalang.ast.stmt.ExpressionStmt;
import org.walkmod.javalang.ast.stmt.ForStmt;
import org.walkmod.javalang.ast.stmt.ForeachStmt;
import org.walkmod.javalang.ast.stmt.IfStmt;
import org.walkmod.javalang.ast.stmt.LabeledStmt;
import org.walkmod.javalang.ast.stmt.ReturnStmt;
import org.walkmod.javalang.ast.stmt.SwitchEntryStmt;
import org.walkmod.javalang.ast.stmt.SwitchStmt;
import org.walkmod.javalang.ast.stmt.SynchronizedStmt;
import org.walkmod.javalang.ast.stmt.ThrowStmt;
import org.walkmod.javalang.ast.stmt.TryStmt;
import org.walkmod.javalang.ast.stmt.TypeDeclarationStmt;
import org.walkmod.javalang.ast.stmt.WhileStmt;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.ast.type.PrimitiveType;
import org.walkmod.javalang.ast.type.ReferenceType;
import org.walkmod.javalang.ast.type.VoidType;
import org.walkmod.javalang.ast.type.WildcardType;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.walkers.VisitorContext;

public class ChangeLogVisitor
extends VoidVisitorAdapter<VisitorContext> {
    private Map<String, Integer> addedNodes = new HashMap<String, Integer>();
    private Map<String, Integer> deletedNodes = new HashMap<String, Integer>();
    private Map<String, Integer> updatedNodes = new HashMap<String, Integer>();
    private Map<String, Integer> unmodifiedNodes = new HashMap<String, Integer>();
    public static final String NODE_TO_COMPARE_KEY = "node_to_compare_key";
    public static final String MAP_TO_UPDATE_KEY = "map_to_update_key";
    public static final String UPDATE_ACTION_KEY = "update_action_key";
    public static final String ADD_ACTION_KEY = "add_action_key";
    public static final String DELETE_ACTION_KEY = "delete_action_key";
    private boolean isUpdated = false;
    private static Properties properties = null;
    private static Logger log = Logger.getLogger(ChangeLogVisitor.class);
    private String reportingPropertiesPath = "reporting.properties";

    public ChangeLogVisitor() {
        this.setReportingPropertiesPath(this.reportingPropertiesPath);
    }

    public String getReportingPropertiesPath() {
        return this.reportingPropertiesPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReportingPropertiesPath(String reportingPropertiesPath) {
        block11: {
            this.reportingPropertiesPath = reportingPropertiesPath;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream stream = loader.getResourceAsStream(this.reportingPropertiesPath);
            try {
                if (stream != null) {
                    properties = new Properties();
                    try {
                        properties.load(stream);
                        break block11;
                    }
                    catch (IOException e) {
                        throw new WalkModException((Throwable)e);
                    }
                }
                properties = null;
                log.warn((Object)"The system cannot found the reporting.properties in the classpath. It will report all code changes");
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new WalkModException((Throwable)e);
                }
            }
        }
    }

    public void increaseAddedNodes(Class<?> clazz) {
        String name = clazz.getSimpleName();
        Integer count = this.addedNodes.get(name);
        if (count == null) {
            count = 0;
        }
        this.addedNodes.put(name, count + 1);
        this.setIsUpdated(true);
    }

    public void increaseDeletedNodes(Class<?> clazz) {
        String name = clazz.getSimpleName();
        Integer count = this.deletedNodes.get(name);
        if (count == null) {
            count = 0;
        }
        this.deletedNodes.put(name, count + 1);
        this.setIsUpdated(true);
    }

    public void increaseUpdatedNodes(Class<?> clazz) {
        String name = clazz.getSimpleName();
        Integer count = this.updatedNodes.get(name);
        if (count == null) {
            count = 0;
        }
        this.updatedNodes.put(name, count + 1);
        this.setIsUpdated(true);
    }

    public void increaseUnmodifiedNodes(Class<?> clazz) {
        String name = clazz.getSimpleName();
        Integer count = this.unmodifiedNodes.get(name);
        if (count == null) {
            count = 0;
        }
        this.unmodifiedNodes.put(name, count + 1);
    }

    private <T extends Node> void inferASTChanges(List<T> nodes1, List<T> nodes2) {
        block7: {
            block6: {
                if (nodes1 == null) break block6;
                for (Node id : nodes1) {
                    if (!id.isNewNode()) continue;
                    VisitorContext vc = new VisitorContext();
                    vc.put(NODE_TO_COMPARE_KEY, null);
                    vc.put(MAP_TO_UPDATE_KEY, (Object)ADD_ACTION_KEY);
                    id.accept((VoidVisitor)this, (Object)vc);
                }
                if (nodes2 == null) break block7;
                for (Node oi : nodes2) {
                    VisitorContext vc;
                    boolean found = false;
                    Iterator<T> it = nodes1.iterator();
                    Node id = null;
                    while (it.hasNext() && !found) {
                        id = (Node)it.next();
                        found = id.isInEqualLocation(oi);
                    }
                    if (found) {
                        vc = new VisitorContext();
                        vc.put(NODE_TO_COMPARE_KEY, (Object)oi);
                        id.accept((VoidVisitor)this, (Object)vc);
                        continue;
                    }
                    vc = new VisitorContext();
                    vc.put(NODE_TO_COMPARE_KEY, null);
                    vc.put(MAP_TO_UPDATE_KEY, (Object)DELETE_ACTION_KEY);
                    oi.accept((VoidVisitor)this, (Object)vc);
                }
                break block7;
            }
            if (nodes2 != null) {
                for (Node elem : nodes2) {
                    VisitorContext vc = new VisitorContext();
                    vc.put(NODE_TO_COMPARE_KEY, null);
                    vc.put(MAP_TO_UPDATE_KEY, (Object)DELETE_ACTION_KEY);
                    elem.accept((VoidVisitor)this, (Object)vc);
                }
            }
        }
    }

    private <T extends Node> void inferASTChangesList(List<List<T>> nodes1, List<List<T>> nodes2) {
        block8: {
            block7: {
                if (nodes1 == null) break block7;
                if (nodes2 == null) {
                    for (List<T> elem : nodes1) {
                        this.inferASTChanges(null, (T)elem);
                    }
                } else {
                    Iterator<List<T>> it1 = nodes1.iterator();
                    Iterator<List<T>> it2 = nodes2.iterator();
                    while (it1.hasNext() || it2.hasNext()) {
                        if (it1.hasNext() && it2.hasNext()) {
                            this.inferASTChanges((T)it1.next(), (T)it2.next());
                            continue;
                        }
                        if (!it1.hasNext()) {
                            this.inferASTChanges(null, (T)it2.next());
                            continue;
                        }
                        this.inferASTChanges((T)it1.next(), null);
                    }
                }
                break block8;
            }
            if (nodes2 == null) break block8;
            for (List<T> elem : nodes2) {
                this.inferASTChanges(null, (T)elem);
            }
        }
    }

    private <T extends Node> void inferASTChanges(T n1, T n2) {
        if (n1 != null) {
            VisitorContext vc = new VisitorContext();
            vc.put(NODE_TO_COMPARE_KEY, n2);
            if (n2 == null) {
                vc.put(MAP_TO_UPDATE_KEY, (Object)ADD_ACTION_KEY);
            }
            n1.accept((VoidVisitor)this, (Object)vc);
        } else {
            VisitorContext vc = new VisitorContext();
            vc.put(NODE_TO_COMPARE_KEY, n1);
            if (n1 == null) {
                vc.put(MAP_TO_UPDATE_KEY, (Object)DELETE_ACTION_KEY);
            }
            if (n2 != null) {
                n2.accept((VoidVisitor)this, (Object)vc);
            }
        }
    }

    public void setIsUpdated(boolean isUpdated) {
        this.isUpdated = isUpdated;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void visit(CompilationUnit n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof CompilationUnit) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (o instanceof CompilationUnit) {
                CompilationUnit oldCU = (CompilationUnit)o;
                this.inferASTChanges(n.getPackage(), oldCU.getPackage());
                this.inferASTChanges((Node)n.getImports(), (Node)oldCU.getImports());
                this.inferASTChanges((Node)n.getTypes(), (Node)oldCU.getTypes());
                this.inferASTChanges((Node)n.getComments(), (Node)oldCU.getComments());
                if (!this.isUpdated()) {
                    this.increaseUnmodifiedNodes(CompilationUnit.class);
                } else {
                    this.increaseUpdatedNodes(CompilationUnit.class);
                }
            }
            this.setIsUpdated(backup || this.isUpdated);
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(CompilationUnit.class);
                    this.inferASTChanges((T)n.getPackage(), (T)null);
                    this.inferASTChanges((Node)n.getImports(), null);
                    this.inferASTChanges((Node)n.getTypes(), null);
                    this.inferASTChanges((Node)n.getComments(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(CompilationUnit.class);
                    this.inferASTChanges(null, n.getPackage());
                    this.inferASTChanges(null, (Node)n.getImports());
                    this.inferASTChanges(null, (Node)n.getTypes());
                    this.inferASTChanges(null, (Node)n.getComments());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(PackageDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof PackageDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            PackageDeclaration aux = (PackageDeclaration)o;
            this.inferASTChanges(n.getName(), aux.getName());
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(PackageDeclaration.class);
            } else {
                this.increaseUpdatedNodes(PackageDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated);
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(PackageDeclaration.class);
                    this.inferASTChanges((T)n.getName(), (T)null);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(PackageDeclaration.class);
                    this.inferASTChanges(null, n.getName());
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ImportDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ImportDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            ImportDeclaration aux = (ImportDeclaration)o;
            this.inferASTChanges(n.getName(), aux.getName());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ImportDeclaration.class);
            } else {
                this.increaseUpdatedNodes(ImportDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ImportDeclaration.class);
                    this.inferASTChanges((T)n.getName(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ImportDeclaration.class);
                    this.inferASTChanges(null, n.getName());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ClassOrInterfaceDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ClassOrInterfaceDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            ClassOrInterfaceDeclaration aux = (ClassOrInterfaceDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges((Node)n.getExtends(), (Node)aux.getExtends());
            this.inferASTChanges((Node)n.getImplements(), (Node)aux.getImplements());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges((Node)n.getMembers(), (Node)aux.getMembers());
            this.inferASTChanges((Node)n.getTypeParameters(), (Node)aux.getTypeParameters());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName()) && n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(ClassOrInterfaceDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(ClassOrInterfaceDeclaration.class);
                }
            } else {
                this.increaseUpdatedNodes(ClassOrInterfaceDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ClassOrInterfaceDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((Node)n.getExtends(), null);
                    this.inferASTChanges((Node)n.getImplements(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((Node)n.getMembers(), null);
                    this.inferASTChanges((Node)n.getTypeParameters(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ClassOrInterfaceDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, (Node)n.getExtends());
                    this.inferASTChanges(null, (Node)n.getImplements());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, (Node)n.getMembers());
                    this.inferASTChanges(null, (Node)n.getTypeParameters());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(TypeParameter n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && n instanceof TypeParameter) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            TypeParameter aux = (TypeParameter)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges((Node)n.getTypeBound(), (Node)aux.getTypeBound());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName())) {
                    this.increaseUnmodifiedNodes(TypeParameter.class);
                } else {
                    this.increaseUpdatedNodes(TypeParameter.class);
                }
            } else {
                this.increaseUpdatedNodes(TypeParameter.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(TypeParameter.class);
                    this.inferASTChanges((Node)n.getTypeBound(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(TypeParameter.class);
                    this.inferASTChanges(null, (Node)n.getTypeBound());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(MethodDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && n instanceof MethodDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            MethodDeclaration aux = (MethodDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getBody(), aux.getBody());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges((Node)n.getParameters(), (Node)aux.getParameters());
            this.inferASTChanges((Node)n.getThrows(), (Node)aux.getThrows());
            this.inferASTChanges(n.getType(), aux.getType());
            this.inferASTChanges((Node)n.getTypeParameters(), (Node)aux.getTypeParameters());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName()) && n.getArrayCount() == aux.getArrayCount() && n.getModifiers() == aux.getModifiers() && n.isDefault() == aux.isDefault()) {
                    this.increaseUnmodifiedNodes(MethodDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(MethodDeclaration.class);
                }
            } else {
                this.increaseUpdatedNodes(MethodDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(MethodDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getBody(), (T)null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((Node)n.getParameters(), null);
                    this.inferASTChanges((Node)n.getThrows(), null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                    this.inferASTChanges((Node)n.getTypeParameters(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(MethodDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getBody());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, (Node)n.getParameters());
                    this.inferASTChanges(null, (Node)n.getThrows());
                    this.inferASTChanges(null, n.getType());
                    this.inferASTChanges(null, (Node)n.getTypeParameters());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(FieldDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && n instanceof FieldDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            FieldDeclaration aux = (FieldDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges(n.getType(), aux.getType());
            this.inferASTChanges((Node)n.getVariables(), (Node)aux.getVariables());
            if (!this.isUpdated && n.getModifiers() == aux.getModifiers()) {
                this.increaseUnmodifiedNodes(FieldDeclaration.class);
            } else {
                this.increaseUpdatedNodes(FieldDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(FieldDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                    this.inferASTChanges((Node)n.getVariables(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(FieldDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, n.getType());
                    this.inferASTChanges(null, (Node)n.getVariables());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(LineComment n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof LineComment) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            LineComment aux = (LineComment)o;
            if (n.getContent().equals(aux.getContent())) {
                this.increaseUnmodifiedNodes(LineComment.class);
            } else {
                this.increaseUpdatedNodes(LineComment.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(LineComment.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(LineComment.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(BlockComment n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof BlockComment) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            BlockComment aux = (BlockComment)o;
            if (n.getContent().equals(aux.getContent())) {
                this.increaseUnmodifiedNodes(BlockComment.class);
            } else {
                this.increaseUpdatedNodes(BlockComment.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(BlockComment.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(BlockComment.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(EnumDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof EnumDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            EnumDeclaration aux = (EnumDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges((Node)n.getImplements(), (Node)aux.getImplements());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges((Node)n.getMembers(), (Node)aux.getMembers());
            this.inferASTChanges((Node)n.getEntries(), (Node)aux.getEntries());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName()) && n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(EnumDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(EnumDeclaration.class);
                }
            } else {
                this.increaseUpdatedNodes(EnumDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(EnumDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((Node)n.getImplements(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((Node)n.getMembers(), null);
                    this.inferASTChanges((Node)n.getEntries(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(EnumDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, (Node)n.getImplements());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, (Node)n.getMembers());
                    this.inferASTChanges((Node)n.getEntries(), null);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(EmptyTypeDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof EmptyTypeDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            EmptyTypeDeclaration aux = (EmptyTypeDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges((Node)n.getMembers(), (Node)aux.getMembers());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName()) && n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(EmptyTypeDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(EmptyTypeDeclaration.class);
                }
            } else {
                this.increaseUpdatedNodes(EmptyTypeDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(EmptyTypeDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((Node)n.getMembers(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(EmptyTypeDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, (Node)n.getMembers());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(EnumConstantDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof EnumConstantDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            EnumConstantDeclaration aux = (EnumConstantDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges((Node)n.getArgs(), (Node)aux.getArgs());
            this.inferASTChanges((Node)n.getClassBody(), (Node)aux.getClassBody());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName())) {
                    this.increaseUnmodifiedNodes(EnumConstantDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(EnumConstantDeclaration.class);
                }
            } else {
                this.increaseUpdatedNodes(EnumConstantDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(EnumConstantDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((Node)n.getArgs(), null);
                    this.inferASTChanges((Node)n.getClassBody(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(EnumConstantDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, (Node)n.getArgs());
                    this.inferASTChanges(null, (Node)n.getClassBody());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(AnnotationDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof AnnotationDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            AnnotationDeclaration aux = (AnnotationDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges((Node)n.getMembers(), (Node)aux.getMembers());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName()) && n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(AnnotationDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(AnnotationDeclaration.class);
                    this.setIsUpdated(true);
                }
            } else {
                this.increaseUpdatedNodes(AnnotationDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(AnnotationDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((Node)n.getMembers(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(AnnotationDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, (Node)n.getMembers());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(AnnotationMemberDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof AnnotationMemberDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            AnnotationMemberDeclaration aux = (AnnotationMemberDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges(n.getDefaultValue(), aux.getDefaultValue());
            this.inferASTChanges(n.getType(), aux.getType());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName()) && n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(AnnotationMemberDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(AnnotationMemberDeclaration.class);
                }
            } else {
                this.increaseUpdatedNodes(AnnotationMemberDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(AnnotationMemberDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((T)n.getDefaultValue(), (T)null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(AnnotationMemberDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, n.getDefaultValue());
                    this.inferASTChanges(null, n.getType());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(VariableDeclarator n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof VariableDeclarator) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            VariableDeclarator aux = (VariableDeclarator)o;
            this.inferASTChanges(n.getId(), aux.getId());
            this.inferASTChanges(n.getInit(), aux.getInit());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(VariableDeclarator.class);
            } else {
                this.increaseUpdatedNodes(VariableDeclarator.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(VariableDeclarator.class);
                    this.inferASTChanges((T)n.getId(), (T)null);
                    this.inferASTChanges((T)n.getInit(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(VariableDeclarator.class);
                    this.inferASTChanges(null, n.getId());
                    this.inferASTChanges(null, n.getInit());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(VariableDeclaratorId n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof VariableDeclaratorId) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            VariableDeclaratorId aux = (VariableDeclaratorId)o;
            if (n.getName().equals(aux.getName())) {
                this.increaseUnmodifiedNodes(VariableDeclaratorId.class);
            } else {
                this.increaseUpdatedNodes(VariableDeclaratorId.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(VariableDeclaratorId.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(VariableDeclaratorId.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ConstructorDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ConstructorDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            ConstructorDeclaration aux = (ConstructorDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getBlock(), aux.getBlock());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            this.inferASTChanges((Node)n.getParameters(), (Node)aux.getParameters());
            this.inferASTChanges((Node)n.getThrows(), (Node)aux.getThrows());
            this.inferASTChanges((Node)n.getTypeParameters(), (Node)aux.getTypeParameters());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName()) && n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(ConstructorDeclaration.class);
                } else {
                    this.increaseUpdatedNodes(ConstructorDeclaration.class);
                }
            } else {
                this.increaseUpdatedNodes(ConstructorDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ConstructorDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getBlock(), (T)null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                    this.inferASTChanges((Node)n.getParameters(), null);
                    this.inferASTChanges((Node)n.getThrows(), null);
                    this.inferASTChanges((Node)n.getTypeParameters(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ConstructorDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getBlock());
                    this.inferASTChanges(null, n.getJavaDoc());
                    this.inferASTChanges(null, (Node)n.getParameters());
                    this.inferASTChanges(null, (Node)n.getThrows());
                    this.inferASTChanges(null, (Node)n.getTypeParameters());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(MultiTypeParameter n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof MultiTypeParameter) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            MultiTypeParameter aux = (MultiTypeParameter)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getId(), aux.getId());
            this.inferASTChanges((Node)n.getTypes(), (Node)aux.getTypes());
            if (!this.isUpdated()) {
                if (n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(Parameter.class);
                } else {
                    this.increaseUpdatedNodes(Parameter.class);
                }
            } else {
                this.increaseUpdatedNodes(Parameter.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(Parameter.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getId(), (T)null);
                    this.inferASTChanges((Node)n.getTypes(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(Parameter.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getId());
                    this.inferASTChanges(null, (Node)n.getTypes());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(Parameter n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof Parameter) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            Parameter aux = (Parameter)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getId(), aux.getId());
            this.inferASTChanges(n.getType(), aux.getType());
            if (!this.isUpdated()) {
                if (n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(Parameter.class);
                } else {
                    this.increaseUpdatedNodes(Parameter.class);
                }
            } else {
                this.increaseUpdatedNodes(Parameter.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(Parameter.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getId(), (T)null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(Parameter.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getId());
                    this.inferASTChanges(null, n.getType());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(EmptyMemberDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof EmptyMemberDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            EmptyMemberDeclaration aux = (EmptyMemberDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(EmptyMemberDeclaration.class);
            } else {
                this.increaseUpdatedNodes(EmptyMemberDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(EmptyMemberDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(EmptyMemberDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getJavaDoc());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(InitializerDeclaration n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof InitializerDeclaration) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            InitializerDeclaration aux = (InitializerDeclaration)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            this.inferASTChanges(n.getBlock(), aux.getBlock());
            this.inferASTChanges(n.getJavaDoc(), aux.getJavaDoc());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(InitializerDeclaration.class);
            } else {
                this.increaseUpdatedNodes(InitializerDeclaration.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(InitializerDeclaration.class);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getBlock(), (T)null);
                    this.inferASTChanges((T)n.getJavaDoc(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(InitializerDeclaration.class);
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getBlock());
                    this.inferASTChanges(null, n.getJavaDoc());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(JavadocComment n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof JavadocComment) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            JavadocComment aux = (JavadocComment)o;
            if (n.getContent().equals(aux.getContent())) {
                this.increaseUnmodifiedNodes(JavadocComment.class);
            } else {
                this.increaseUpdatedNodes(JavadocComment.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(JavadocComment.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(JavadocComment.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ClassOrInterfaceType n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ClassOrInterfaceType) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            ClassOrInterfaceType aux = (ClassOrInterfaceType)o;
            this.inferASTChanges(n.getScope(), aux.getScope());
            this.inferASTChanges((Node)n.getTypeArgs(), (Node)aux.getTypeArgs());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName())) {
                    this.increaseUnmodifiedNodes(ClassOrInterfaceType.class);
                } else {
                    this.increaseUpdatedNodes(ClassOrInterfaceType.class);
                }
            } else {
                this.increaseUpdatedNodes(ClassOrInterfaceType.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ClassOrInterfaceType.class);
                    this.inferASTChanges((T)n.getScope(), (T)null);
                    this.inferASTChanges((Node)n.getTypeArgs(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ClassOrInterfaceType.class);
                    this.inferASTChanges(null, n.getScope());
                    this.inferASTChanges(null, (Node)n.getTypeArgs());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(PrimitiveType n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof PrimitiveType) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            PrimitiveType aux = (PrimitiveType)o;
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            if (n.getType().equals((Object)aux.getType())) {
                this.increaseUnmodifiedNodes(PrimitiveType.class);
            } else {
                this.increaseUpdatedNodes(PrimitiveType.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(PrimitiveType.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(PrimitiveType.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ReferenceType n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ReferenceType) {
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            ReferenceType aux = (ReferenceType)o;
            this.inferASTChangesList(n.getArraysAnnotations(), aux.getArraysAnnotations());
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            if (n.getType().equals((Object)aux.getType()) && n.getArrayCount() == aux.getArrayCount()) {
                this.increaseUnmodifiedNodes(PrimitiveType.class);
            } else {
                this.increaseUpdatedNodes(PrimitiveType.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ReferenceType.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ReferenceType.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(VoidType n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null) {
            this.increaseUnmodifiedNodes(VoidType.class);
            this.setIsUpdated(false);
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(VoidType.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(VoidType.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(WildcardType n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof WildcardType) {
            WildcardType aux = (WildcardType)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExtends(), aux.getExtends());
            this.inferASTChanges(n.getSuper(), aux.getSuper());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(WildcardType.class);
            } else {
                this.increaseUpdatedNodes(WildcardType.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(WildcardType.class);
                    this.inferASTChanges((T)n.getExtends(), (T)null);
                    this.inferASTChanges((T)n.getSuper(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(WildcardType.class);
                    this.inferASTChanges(null, n.getExtends());
                    this.inferASTChanges(null, n.getSuper());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ArrayAccessExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ArrayAccessExpr) {
            ArrayAccessExpr aux = (ArrayAccessExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getIndex(), aux.getIndex());
            this.inferASTChanges(n.getName(), aux.getName());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ArrayAccessExpr.class);
            } else {
                this.increaseUpdatedNodes(ArrayAccessExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ArrayAccessExpr.class);
                    this.inferASTChanges((T)n.getIndex(), (T)null);
                    this.inferASTChanges((T)n.getName(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ArrayAccessExpr.class);
                    this.inferASTChanges(null, n.getIndex());
                    this.inferASTChanges(null, n.getName());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ArrayCreationExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ArrayCreationExpr) {
            ArrayCreationExpr aux = (ArrayCreationExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChangesList(n.getArraysAnnotations(), aux.getArraysAnnotations());
            this.inferASTChanges((Node)n.getDimensions(), (Node)aux.getDimensions());
            this.inferASTChanges(n.getType(), aux.getType());
            this.inferASTChanges(n.getInitializer(), aux.getInitializer());
            if (!this.isUpdated()) {
                if (n.getArrayCount() == aux.getArrayCount()) {
                    this.increaseUnmodifiedNodes(ArrayCreationExpr.class);
                } else {
                    this.increaseUpdatedNodes(ArrayCreationExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(ArrayCreationExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ArrayCreationExpr.class);
                    this.inferASTChanges((Node)n.getDimensions(), null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                    this.inferASTChanges((T)n.getInitializer(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ArrayCreationExpr.class);
                    this.inferASTChanges(null, (Node)n.getDimensions());
                    this.inferASTChanges(null, n.getType());
                    this.inferASTChanges(null, n.getInitializer());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ArrayInitializerExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ArrayInitializerExpr) {
            ArrayInitializerExpr aux = (ArrayInitializerExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges((Node)n.getValues(), (Node)aux.getValues());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ArrayInitializerExpr.class);
            } else {
                this.increaseUpdatedNodes(ArrayInitializerExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ArrayInitializerExpr.class);
                    this.inferASTChanges((Node)n.getValues(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ArrayInitializerExpr.class);
                    this.inferASTChanges(null, (Node)n.getValues());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(AssignExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof AssignExpr) {
            AssignExpr aux = (AssignExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getTarget(), aux.getTarget());
            this.inferASTChanges(n.getValue(), aux.getValue());
            if (!this.isUpdated()) {
                if (n.getOperator().name().equals(aux.getOperator().name())) {
                    this.increaseUnmodifiedNodes(AssignExpr.class);
                } else {
                    this.increaseUpdatedNodes(AssignExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(AssignExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(AssignExpr.class);
                    this.inferASTChanges((T)n.getTarget(), (T)null);
                    this.inferASTChanges((T)n.getValue(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(AssignExpr.class);
                    this.inferASTChanges(null, n.getTarget());
                    this.inferASTChanges(null, n.getValue());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(BinaryExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof BinaryExpr) {
            BinaryExpr aux = (BinaryExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getRight(), aux.getRight());
            this.inferASTChanges(n.getLeft(), aux.getLeft());
            if (!this.isUpdated()) {
                if (n.getOperator().name().equals(aux.getOperator().name())) {
                    this.increaseUnmodifiedNodes(BinaryExpr.class);
                } else {
                    this.increaseUpdatedNodes(BinaryExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(BinaryExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(BinaryExpr.class);
                    this.inferASTChanges((T)n.getRight(), (T)null);
                    this.inferASTChanges((T)n.getLeft(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(BinaryExpr.class);
                    this.inferASTChanges(null, n.getRight());
                    this.inferASTChanges(null, n.getLeft());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(CastExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof CastExpr) {
            CastExpr aux = (CastExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpr(), aux.getExpr());
            this.inferASTChanges(n.getType(), aux.getType());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(CastExpr.class);
            } else {
                this.increaseUpdatedNodes(CastExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(CastExpr.class);
                    this.inferASTChanges((T)n.getExpr(), (T)null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(CastExpr.class);
                    this.inferASTChanges(null, n.getExpr());
                    this.inferASTChanges(null, n.getType());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ClassExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ClassExpr) {
            ClassExpr aux = (ClassExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getType(), aux.getType());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ClassExpr.class);
            } else {
                this.increaseUpdatedNodes(ClassExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ClassExpr.class);
                    this.inferASTChanges((T)n.getType(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ClassExpr.class);
                    this.inferASTChanges(null, n.getType());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ConditionalExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ConditionalExpr) {
            ConditionalExpr aux = (ConditionalExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getCondition(), aux.getCondition());
            this.inferASTChanges(n.getThenExpr(), aux.getThenExpr());
            this.inferASTChanges(n.getElseExpr(), aux.getElseExpr());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ConditionalExpr.class);
            } else {
                this.increaseUpdatedNodes(ConditionalExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ConditionalExpr.class);
                    this.inferASTChanges((T)n.getCondition(), (T)null);
                    this.inferASTChanges((T)n.getThenExpr(), (T)null);
                    this.inferASTChanges((T)n.getElseExpr(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ConditionalExpr.class);
                    this.inferASTChanges(null, n.getCondition());
                    this.inferASTChanges(null, n.getThenExpr());
                    this.inferASTChanges(null, n.getElseExpr());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(EnclosedExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof EnclosedExpr) {
            EnclosedExpr aux = (EnclosedExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getInner(), aux.getInner());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(EnclosedExpr.class);
            } else {
                this.increaseUpdatedNodes(EnclosedExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(EnclosedExpr.class);
                    this.inferASTChanges((T)n.getInner(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(EnclosedExpr.class);
                    this.inferASTChanges(null, n.getInner());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(FieldAccessExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof FieldAccessExpr) {
            FieldAccessExpr aux = (FieldAccessExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getScope(), aux.getScope());
            this.inferASTChanges((Node)n.getTypeArgs(), (Node)aux.getTypeArgs());
            if (!this.isUpdated()) {
                if (n.getField().equals(aux.getField())) {
                    this.increaseUnmodifiedNodes(FieldAccessExpr.class);
                } else {
                    this.increaseUpdatedNodes(FieldAccessExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(FieldAccessExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(FieldAccessExpr.class);
                    this.inferASTChanges((T)n.getScope(), (T)null);
                    this.inferASTChanges((Node)n.getTypeArgs(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(FieldAccessExpr.class);
                    this.inferASTChanges(null, n.getScope());
                    this.inferASTChanges(null, (Node)n.getTypeArgs());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(InstanceOfExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof InstanceOfExpr) {
            InstanceOfExpr aux = (InstanceOfExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpr(), aux.getExpr());
            this.inferASTChanges(n.getType(), aux.getType());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(InstanceOfExpr.class);
            } else {
                this.increaseUpdatedNodes(InstanceOfExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(InstanceOfExpr.class);
                    this.inferASTChanges((T)n.getExpr(), (T)null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(InstanceOfExpr.class);
                    this.inferASTChanges(null, n.getExpr());
                    this.inferASTChanges(null, n.getType());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(StringLiteralExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof StringLiteralExpr) {
            StringLiteralExpr aux = (StringLiteralExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue().equals(aux.getValue())) {
                this.increaseUnmodifiedNodes(StringLiteralExpr.class);
            } else {
                this.increaseUpdatedNodes(StringLiteralExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(StringLiteralExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(StringLiteralExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(IntegerLiteralExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof IntegerLiteralExpr) {
            IntegerLiteralExpr aux = (IntegerLiteralExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue().equals(aux.getValue())) {
                this.increaseUnmodifiedNodes(IntegerLiteralExpr.class);
            } else {
                this.increaseUpdatedNodes(IntegerLiteralExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(IntegerLiteralExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(IntegerLiteralExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(LongLiteralExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof LongLiteralExpr) {
            LongLiteralExpr aux = (LongLiteralExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue().equals(aux.getValue())) {
                this.increaseUnmodifiedNodes(LongLiteralExpr.class);
            } else {
                this.increaseUpdatedNodes(LongLiteralExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(LongLiteralExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(LongLiteralExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(IntegerLiteralMinValueExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof IntegerLiteralMinValueExpr) {
            IntegerLiteralMinValueExpr aux = (IntegerLiteralMinValueExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue().equals(aux.getValue())) {
                this.increaseUnmodifiedNodes(IntegerLiteralMinValueExpr.class);
            } else {
                this.increaseUpdatedNodes(IntegerLiteralMinValueExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(IntegerLiteralMinValueExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(IntegerLiteralMinValueExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(LongLiteralMinValueExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof LongLiteralMinValueExpr) {
            LongLiteralMinValueExpr aux = (LongLiteralMinValueExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue().equals(aux.getValue())) {
                this.increaseUnmodifiedNodes(LongLiteralMinValueExpr.class);
            } else {
                this.increaseUpdatedNodes(LongLiteralMinValueExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(LongLiteralMinValueExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(LongLiteralMinValueExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(CharLiteralExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof CharLiteralExpr) {
            CharLiteralExpr aux = (CharLiteralExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue().equals(aux.getValue())) {
                this.increaseUnmodifiedNodes(CharLiteralExpr.class);
            } else {
                this.increaseUpdatedNodes(CharLiteralExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(CharLiteralExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(CharLiteralExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(DoubleLiteralExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof DoubleLiteralExpr) {
            DoubleLiteralExpr aux = (DoubleLiteralExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue().equals(aux.getValue())) {
                this.increaseUnmodifiedNodes(DoubleLiteralExpr.class);
            } else {
                this.increaseUpdatedNodes(DoubleLiteralExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(DoubleLiteralExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(DoubleLiteralExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(BooleanLiteralExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof BooleanLiteralExpr) {
            BooleanLiteralExpr aux = (BooleanLiteralExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getValue() == aux.getValue()) {
                this.increaseUnmodifiedNodes(BooleanLiteralExpr.class);
            } else {
                this.increaseUpdatedNodes(BooleanLiteralExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(BooleanLiteralExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(BooleanLiteralExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(NullLiteralExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null) {
            this.increaseUnmodifiedNodes(NullLiteralExpr.class);
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(NullLiteralExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(NullLiteralExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(MethodCallExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof MethodCallExpr) {
            MethodCallExpr aux = (MethodCallExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getScope(), aux.getScope());
            this.inferASTChanges((Node)n.getTypeArgs(), (Node)aux.getTypeArgs());
            this.inferASTChanges((Node)n.getArgs(), (Node)aux.getArgs());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName())) {
                    this.increaseUnmodifiedNodes(MethodCallExpr.class);
                } else {
                    this.increaseUpdatedNodes(MethodCallExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(MethodCallExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(MethodCallExpr.class);
                    this.inferASTChanges((T)n.getScope(), (T)null);
                    this.inferASTChanges((Node)n.getTypeArgs(), null);
                    this.inferASTChanges((Node)n.getArgs(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(MethodCallExpr.class);
                    this.inferASTChanges(null, n.getScope());
                    this.inferASTChanges(null, (Node)n.getTypeArgs());
                    this.inferASTChanges((Node)n.getArgs(), null);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(NameExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof NameExpr) {
            NameExpr aux = (NameExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            if (n.getName().equals(aux.getName())) {
                this.increaseUnmodifiedNodes(NameExpr.class);
            } else {
                this.increaseUpdatedNodes(NameExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(NameExpr.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(NameExpr.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ObjectCreationExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ObjectCreationExpr) {
            ObjectCreationExpr aux = (ObjectCreationExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getScope(), aux.getScope());
            this.inferASTChanges(n.getType(), aux.getType());
            this.inferASTChanges((Node)n.getTypeArgs(), (Node)aux.getTypeArgs());
            this.inferASTChanges((Node)n.getArgs(), (Node)aux.getArgs());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ObjectCreationExpr.class);
            } else {
                this.increaseUpdatedNodes(ObjectCreationExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ObjectCreationExpr.class);
                    this.inferASTChanges((T)n.getScope(), (T)null);
                    this.inferASTChanges((Node)n.getTypeArgs(), null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                    this.inferASTChanges((Node)n.getArgs(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ObjectCreationExpr.class);
                    this.inferASTChanges(null, n.getScope());
                    this.inferASTChanges(null, (Node)n.getTypeArgs());
                    this.inferASTChanges(null, n.getType());
                    this.inferASTChanges((Node)n.getArgs(), null);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(QualifiedNameExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof QualifiedNameExpr) {
            QualifiedNameExpr aux = (QualifiedNameExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getQualifier(), aux.getQualifier());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName())) {
                    this.increaseUnmodifiedNodes(QualifiedNameExpr.class);
                } else {
                    this.increaseUpdatedNodes(QualifiedNameExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(QualifiedNameExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(QualifiedNameExpr.class);
                    this.inferASTChanges((T)n.getQualifier(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(QualifiedNameExpr.class);
                    this.inferASTChanges(null, n.getQualifier());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ThisExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ThisExpr) {
            ThisExpr aux = (ThisExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getClassExpr(), aux.getClassExpr());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ThisExpr.class);
            } else {
                this.increaseUpdatedNodes(ThisExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ThisExpr.class);
                    this.inferASTChanges((T)n.getClassExpr(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ThisExpr.class);
                    this.inferASTChanges(null, n.getClassExpr());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(SuperExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof SuperExpr) {
            SuperExpr aux = (SuperExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getClassExpr(), aux.getClassExpr());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(SuperExpr.class);
            } else {
                this.increaseUpdatedNodes(SuperExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(SuperExpr.class);
                    this.inferASTChanges((T)n.getClassExpr(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(SuperExpr.class);
                    this.inferASTChanges(null, n.getClassExpr());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(UnaryExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof UnaryExpr) {
            UnaryExpr aux = (UnaryExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpr(), aux.getExpr());
            if (!this.isUpdated()) {
                if (n.getOperator().name().equals(aux.getOperator().name())) {
                    this.increaseUnmodifiedNodes(UnaryExpr.class);
                } else {
                    this.increaseUpdatedNodes(UnaryExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(UnaryExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(UnaryExpr.class);
                    this.inferASTChanges((T)n.getExpr(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(UnaryExpr.class);
                    this.inferASTChanges(null, n.getExpr());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(VariableDeclarationExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof VariableDeclarationExpr) {
            VariableDeclarationExpr aux = (VariableDeclarationExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges((Node)n.getVars(), (Node)aux.getVars());
            this.inferASTChanges(n.getType(), aux.getType());
            this.inferASTChanges((Node)n.getAnnotations(), (Node)aux.getAnnotations());
            if (!this.isUpdated()) {
                if (n.getModifiers() == aux.getModifiers()) {
                    this.increaseUnmodifiedNodes(VariableDeclarationExpr.class);
                } else {
                    this.increaseUpdatedNodes(VariableDeclarationExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(VariableDeclarationExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(VariableDeclarationExpr.class);
                    this.inferASTChanges((Node)n.getVars(), null);
                    this.inferASTChanges((Node)n.getAnnotations(), null);
                    this.inferASTChanges((T)n.getType(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(VariableDeclarationExpr.class);
                    this.inferASTChanges(null, (Node)n.getVars());
                    this.inferASTChanges(null, (Node)n.getAnnotations());
                    this.inferASTChanges(null, n.getType());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(MarkerAnnotationExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof MarkerAnnotationExpr) {
            MarkerAnnotationExpr aux = (MarkerAnnotationExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getName(), aux.getName());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(MarkerAnnotationExpr.class);
            } else {
                this.increaseUpdatedNodes(MarkerAnnotationExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(MarkerAnnotationExpr.class);
                    this.inferASTChanges((T)n.getName(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(MarkerAnnotationExpr.class);
                    this.inferASTChanges(null, n.getName());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(SingleMemberAnnotationExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof SingleMemberAnnotationExpr) {
            SingleMemberAnnotationExpr aux = (SingleMemberAnnotationExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getMemberValue(), aux.getMemberValue());
            this.inferASTChanges(n.getName(), aux.getName());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(SingleMemberAnnotationExpr.class);
            } else {
                this.increaseUpdatedNodes(SingleMemberAnnotationExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(SingleMemberAnnotationExpr.class);
                    this.inferASTChanges((T)n.getMemberValue(), (T)null);
                    this.inferASTChanges((T)n.getName(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(SingleMemberAnnotationExpr.class);
                    this.inferASTChanges(null, n.getMemberValue());
                    this.inferASTChanges(null, n.getName());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(NormalAnnotationExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof NormalAnnotationExpr) {
            NormalAnnotationExpr aux = (NormalAnnotationExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges((Node)n.getPairs(), (Node)aux.getPairs());
            this.inferASTChanges(n.getName(), aux.getName());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(NormalAnnotationExpr.class);
            } else {
                this.increaseUpdatedNodes(NormalAnnotationExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(NormalAnnotationExpr.class);
                    this.inferASTChanges((Node)n.getPairs(), null);
                    this.inferASTChanges((T)n.getName(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(NormalAnnotationExpr.class);
                    this.inferASTChanges(null, (Node)n.getPairs());
                    this.inferASTChanges(null, n.getName());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(MemberValuePair n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof MemberValuePair) {
            MemberValuePair aux = (MemberValuePair)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getValue(), aux.getValue());
            if (!this.isUpdated()) {
                if (n.getName().equals(aux.getName())) {
                    this.increaseUnmodifiedNodes(MemberValuePair.class);
                } else {
                    this.increaseUpdatedNodes(MemberValuePair.class);
                }
            } else {
                this.increaseUpdatedNodes(MemberValuePair.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(MemberValuePair.class);
                    this.inferASTChanges((T)n.getValue(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(MemberValuePair.class);
                    this.inferASTChanges(null, n.getValue());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ExplicitConstructorInvocationStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ExplicitConstructorInvocationStmt) {
            ExplicitConstructorInvocationStmt aux = (ExplicitConstructorInvocationStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpr(), aux.getExpr());
            this.inferASTChanges((Node)n.getArgs(), (Node)aux.getArgs());
            this.inferASTChanges((Node)n.getTypeArgs(), (Node)aux.getTypeArgs());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ExplicitConstructorInvocationStmt.class);
            } else {
                this.increaseUpdatedNodes(ExplicitConstructorInvocationStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ExplicitConstructorInvocationStmt.class);
                    this.inferASTChanges((T)n.getExpr(), (T)null);
                    this.inferASTChanges((Node)n.getArgs(), null);
                    this.inferASTChanges((Node)n.getTypeArgs(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ExplicitConstructorInvocationStmt.class);
                    this.inferASTChanges(null, n.getExpr());
                    this.inferASTChanges(null, (Node)n.getArgs());
                    this.inferASTChanges(null, (Node)n.getTypeArgs());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(TypeDeclarationStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof TypeDeclarationStmt) {
            TypeDeclarationStmt aux = (TypeDeclarationStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getTypeDeclaration(), aux.getTypeDeclaration());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(TypeDeclarationStmt.class);
            } else {
                this.increaseUpdatedNodes(TypeDeclarationStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(TypeDeclarationStmt.class);
                    this.inferASTChanges((T)n.getTypeDeclaration(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(TypeDeclarationStmt.class);
                    this.inferASTChanges(null, n.getTypeDeclaration());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(AssertStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof AssertStmt) {
            AssertStmt aux = (AssertStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getCheck(), aux.getCheck());
            this.inferASTChanges(n.getMessage(), aux.getMessage());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(AssertStmt.class);
            } else {
                this.increaseUpdatedNodes(AssertStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(AssertStmt.class);
                    this.inferASTChanges((T)n.getCheck(), (T)null);
                    this.inferASTChanges((T)n.getMessage(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(AssertStmt.class);
                    this.inferASTChanges(null, n.getCheck());
                    this.inferASTChanges(null, n.getMessage());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(BlockStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof BlockStmt) {
            BlockStmt aux = (BlockStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges((Node)n.getStmts(), (Node)aux.getStmts());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(BlockStmt.class);
            } else {
                this.increaseUpdatedNodes(BlockStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(BlockStmt.class);
                    this.inferASTChanges((Node)n.getStmts(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(BlockStmt.class);
                    this.inferASTChanges(null, (Node)n.getStmts());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(LabeledStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof LabeledStmt) {
            LabeledStmt aux = (LabeledStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getStmt(), aux.getStmt());
            if (!this.isUpdated()) {
                if (n.getLabel().equals(aux.getLabel())) {
                    this.increaseUnmodifiedNodes(LabeledStmt.class);
                } else {
                    this.increaseUpdatedNodes(LabeledStmt.class);
                }
            } else {
                this.increaseUpdatedNodes(LabeledStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(LabeledStmt.class);
                    this.inferASTChanges((T)n.getStmt(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(LabeledStmt.class);
                    this.inferASTChanges(null, n.getStmt());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(EmptyStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof EmptyStmt) {
            this.increaseUnmodifiedNodes(EmptyStmt.class);
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(EmptyStmt.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(EmptyStmt.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ExpressionStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ExpressionStmt) {
            ExpressionStmt aux = (ExpressionStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpression(), aux.getExpression());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ExpressionStmt.class);
            } else {
                this.increaseUpdatedNodes(ExpressionStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ExpressionStmt.class);
                    this.inferASTChanges((T)n.getExpression(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ExpressionStmt.class);
                    this.inferASTChanges(null, n.getExpression());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(SwitchStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof SwitchStmt) {
            SwitchStmt aux = (SwitchStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getSelector(), aux.getSelector());
            this.inferASTChanges((Node)n.getEntries(), (Node)aux.getEntries());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(SwitchStmt.class);
            } else {
                this.increaseUpdatedNodes(SwitchStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(SwitchStmt.class);
                    this.inferASTChanges((T)n.getSelector(), (T)null);
                    this.inferASTChanges((Node)n.getEntries(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(SwitchStmt.class);
                    this.inferASTChanges(null, n.getSelector());
                    this.inferASTChanges(null, (Node)n.getEntries());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(SwitchEntryStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof SwitchEntryStmt) {
            SwitchEntryStmt aux = (SwitchEntryStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getLabel(), aux.getLabel());
            this.inferASTChanges((Node)n.getStmts(), (Node)aux.getStmts());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(SwitchEntryStmt.class);
            } else {
                this.increaseUpdatedNodes(SwitchEntryStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(SwitchEntryStmt.class);
                    this.inferASTChanges((T)n.getLabel(), (T)null);
                    this.inferASTChanges((Node)n.getStmts(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(SwitchEntryStmt.class);
                    this.inferASTChanges(null, n.getLabel());
                    this.inferASTChanges(null, (Node)n.getStmts());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(BreakStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof BreakStmt) {
            BreakStmt aux = (BreakStmt)o;
            if (n.getId() == null || n.getId().equals(aux.getId())) {
                this.increaseUnmodifiedNodes(BreakStmt.class);
            } else {
                this.increaseUpdatedNodes(BreakStmt.class);
            }
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(BreakStmt.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(BreakStmt.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ReturnStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ReturnStmt) {
            ReturnStmt aux = (ReturnStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpr(), aux.getExpr());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ReturnStmt.class);
            } else {
                this.increaseUpdatedNodes(ReturnStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ReturnStmt.class);
                    this.inferASTChanges((T)n.getExpr(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ReturnStmt.class);
                    this.inferASTChanges(null, n.getExpr());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(IfStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && n instanceof IfStmt) {
            IfStmt aux = (IfStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getCondition(), aux.getCondition());
            this.inferASTChanges(n.getThenStmt(), aux.getThenStmt());
            this.inferASTChanges(n.getElseStmt(), aux.getElseStmt());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(IfStmt.class);
            } else {
                this.increaseUpdatedNodes(IfStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(IfStmt.class);
                    this.inferASTChanges((T)n.getCondition(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(IfStmt.class);
                    this.inferASTChanges(null, n.getCondition());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(WhileStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof WhileStmt) {
            WhileStmt aux = (WhileStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getCondition(), aux.getCondition());
            this.inferASTChanges(n.getBody(), aux.getBody());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(WhileStmt.class);
            } else {
                this.increaseUpdatedNodes(WhileStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(WhileStmt.class);
                    this.inferASTChanges((T)n.getBody(), (T)null);
                    this.inferASTChanges((T)n.getCondition(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(WhileStmt.class);
                    this.inferASTChanges(null, n.getCondition());
                    this.inferASTChanges(null, n.getBody());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ContinueStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ContinueStmt) {
            ContinueStmt aux = (ContinueStmt)o;
            if (n.getId() == null || n.getId().equals(aux.getId())) {
                this.increaseUnmodifiedNodes(ContinueStmt.class);
            } else {
                this.increaseUpdatedNodes(ContinueStmt.class);
            }
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ContinueStmt.class);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ContinueStmt.class);
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(DoStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof DoStmt) {
            DoStmt aux = (DoStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getCondition(), aux.getCondition());
            this.inferASTChanges(n.getBody(), aux.getBody());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(DoStmt.class);
            } else {
                this.increaseUpdatedNodes(DoStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(DoStmt.class);
                    this.inferASTChanges((T)n.getBody(), (T)null);
                    this.inferASTChanges((T)n.getCondition(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(DoStmt.class);
                    this.inferASTChanges(null, n.getCondition());
                    this.inferASTChanges(null, n.getBody());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ForeachStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ForeachStmt) {
            ForeachStmt aux = (ForeachStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getIterable(), aux.getIterable());
            this.inferASTChanges(n.getVariable(), aux.getVariable());
            this.inferASTChanges(n.getBody(), aux.getBody());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ForeachStmt.class);
            } else {
                this.increaseUpdatedNodes(ForeachStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ForeachStmt.class);
                    this.inferASTChanges((T)n.getBody(), (T)null);
                    this.inferASTChanges((T)n.getIterable(), (T)null);
                    this.inferASTChanges((T)n.getVariable(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ForeachStmt.class);
                    this.inferASTChanges(null, n.getVariable());
                    this.inferASTChanges(null, n.getIterable());
                    this.inferASTChanges(null, n.getBody());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ForStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ForStmt) {
            ForStmt aux = (ForStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges((Node)n.getInit(), (Node)aux.getInit());
            this.inferASTChanges((Node)n.getUpdate(), (Node)aux.getUpdate());
            this.inferASTChanges(n.getCompare(), aux.getCompare());
            this.inferASTChanges(n.getBody(), aux.getBody());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ForeachStmt.class);
            } else {
                this.increaseUpdatedNodes(ForeachStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ForeachStmt.class);
                    this.inferASTChanges((T)n.getBody(), (T)null);
                    this.inferASTChanges((Node)n.getInit(), null);
                    this.inferASTChanges((Node)n.getUpdate(), null);
                    this.inferASTChanges((T)n.getCompare(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ForeachStmt.class);
                    this.inferASTChanges(null, (Node)n.getInit());
                    this.inferASTChanges(null, (Node)n.getUpdate());
                    this.inferASTChanges(null, n.getBody());
                    this.inferASTChanges(null, n.getCompare());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(ThrowStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof ThrowStmt) {
            ThrowStmt aux = (ThrowStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpr(), aux.getExpr());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(ThrowStmt.class);
            } else {
                this.increaseUpdatedNodes(ThrowStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(ThrowStmt.class);
                    this.inferASTChanges((T)n.getExpr(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(ThrowStmt.class);
                    this.inferASTChanges(null, n.getExpr());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(SynchronizedStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof SynchronizedStmt) {
            SynchronizedStmt aux = (SynchronizedStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getExpr(), aux.getExpr());
            this.inferASTChanges(n.getBlock(), aux.getBlock());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(SynchronizedStmt.class);
            } else {
                this.increaseUpdatedNodes(SynchronizedStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(SynchronizedStmt.class);
                    this.inferASTChanges((T)n.getExpr(), (T)null);
                    this.inferASTChanges((T)n.getBlock(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(SynchronizedStmt.class);
                    this.inferASTChanges(null, n.getExpr());
                    this.inferASTChanges(null, n.getBlock());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(TryStmt n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof TryStmt) {
            TryStmt aux = (TryStmt)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getTryBlock(), aux.getTryBlock());
            this.inferASTChanges((Node)n.getCatchs(), (Node)aux.getCatchs());
            this.inferASTChanges(n.getFinallyBlock(), aux.getFinallyBlock());
            this.inferASTChanges((Node)n.getResources(), (Node)aux.getResources());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(TryStmt.class);
            } else {
                this.increaseUpdatedNodes(TryStmt.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(TryStmt.class);
                    this.inferASTChanges((T)n.getTryBlock(), (T)null);
                    this.inferASTChanges((Node)n.getCatchs(), null);
                    this.inferASTChanges((T)n.getFinallyBlock(), (T)null);
                    this.inferASTChanges((Node)n.getResources(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(TryStmt.class);
                    this.inferASTChanges(null, n.getTryBlock());
                    this.inferASTChanges(null, (Node)n.getCatchs());
                    this.inferASTChanges(null, n.getFinallyBlock());
                    this.inferASTChanges(null, (Node)n.getResources());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(CatchClause n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof CatchClause) {
            CatchClause aux = (CatchClause)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getCatchBlock(), aux.getCatchBlock());
            this.inferASTChanges(n.getExcept(), aux.getExcept());
            if (!this.isUpdated()) {
                this.increaseUnmodifiedNodes(CatchClause.class);
            } else {
                this.increaseUpdatedNodes(CatchClause.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(CatchClause.class);
                    this.inferASTChanges((T)n.getCatchBlock(), (T)null);
                    this.inferASTChanges((T)n.getExcept(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(CatchClause.class);
                    this.inferASTChanges(null, n.getCatchBlock());
                    this.inferASTChanges(null, n.getExcept());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(LambdaExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof LambdaExpr) {
            LambdaExpr aux = (LambdaExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges((Node)n.getParameters(), (Node)aux.getParameters());
            this.inferASTChanges(n.getBody(), aux.getBody());
            if (!this.isUpdated()) {
                if (n.isParametersEnclosed() == aux.isParametersEnclosed()) {
                    this.increaseUnmodifiedNodes(LambdaExpr.class);
                } else {
                    this.increaseUpdatedNodes(LambdaExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(LambdaExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(LambdaExpr.class);
                    this.inferASTChanges((Node)n.getParameters(), null);
                    this.inferASTChanges((T)n.getBody(), (T)null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(LambdaExpr.class);
                    this.inferASTChanges(null, (Node)n.getParameters());
                    this.inferASTChanges(null, n.getBody());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public void visit(MethodReferenceExpr n, VisitorContext ctx) {
        Object o = ctx.get((Object)NODE_TO_COMPARE_KEY);
        if (o != null && o instanceof MethodReferenceExpr) {
            MethodReferenceExpr aux = (MethodReferenceExpr)o;
            boolean backup = this.isUpdated();
            this.setIsUpdated(false);
            this.inferASTChanges(n.getScope(), aux.getScope());
            this.inferASTChanges((Node)n.getTypeParameters(), (Node)aux.getTypeParameters());
            if (!this.isUpdated()) {
                if (n.getIdentifier().equals(aux.getIdentifier())) {
                    this.increaseUnmodifiedNodes(MethodReferenceExpr.class);
                } else {
                    this.increaseUpdatedNodes(MethodReferenceExpr.class);
                }
            } else {
                this.increaseUpdatedNodes(MethodReferenceExpr.class);
            }
            this.setIsUpdated(backup || this.isUpdated());
        } else {
            o = ctx.get((Object)MAP_TO_UPDATE_KEY);
            if (o != null) {
                String action = (String)o;
                if (action.equals(ADD_ACTION_KEY)) {
                    this.increaseAddedNodes(MethodReferenceExpr.class);
                    this.inferASTChanges((T)n.getScope(), (T)null);
                    this.inferASTChanges((Node)n.getTypeParameters(), null);
                } else if (action.equals(DELETE_ACTION_KEY)) {
                    this.increaseDeletedNodes(MethodReferenceExpr.class);
                    this.inferASTChanges(null, n.getScope());
                    this.inferASTChanges(null, (Node)n.getTypeParameters());
                }
            }
            this.setIsUpdated(true);
        }
    }

    public Map<String, Integer> getAddedNodes() {
        if (properties == null) {
            return this.addedNodes;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Set<Object> keys = properties.keySet();
        if (keys != null) {
            for (Object e : keys) {
                if (!"true".equalsIgnoreCase(properties.getProperty(e.toString()).toString())) continue;
                if (this.addedNodes.containsKey(e.toString())) {
                    result.put(e.toString(), this.addedNodes.get(e));
                    continue;
                }
                result.put(e.toString(), 0);
            }
        }
        return result;
    }

    public Map<String, Integer> getDeletedNodes() {
        if (properties == null) {
            return this.deletedNodes;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Set<Object> keys = properties.keySet();
        if (keys != null) {
            for (Object e : keys) {
                if (!"true".equalsIgnoreCase(properties.getProperty(e.toString()).toString())) continue;
                if (this.deletedNodes.containsKey(e.toString())) {
                    result.put(e.toString(), this.deletedNodes.get(e));
                    continue;
                }
                result.put(e.toString(), 0);
            }
        }
        return result;
    }

    public Map<String, Integer> getUpdatedNodes() {
        if (properties == null) {
            return this.updatedNodes;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Set<Object> keys = properties.keySet();
        if (keys != null) {
            for (Object e : keys) {
                if (!"true".equalsIgnoreCase(properties.getProperty(e.toString()).toString())) continue;
                if (this.updatedNodes.containsKey(e.toString())) {
                    result.put(e.toString(), this.updatedNodes.get(e));
                    continue;
                }
                result.put(e.toString(), 0);
            }
        }
        return result;
    }

    public Map<String, Integer> getUnmodifiedNodes() {
        if (properties == null) {
            return this.unmodifiedNodes;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Set<Object> keys = properties.keySet();
        if (keys != null) {
            for (Object e : keys) {
                if (!"true".equalsIgnoreCase(properties.getProperty(e.toString()).toString())) continue;
                if (this.unmodifiedNodes.containsKey(e.toString())) {
                    result.put(e.toString(), this.unmodifiedNodes.get(e));
                    continue;
                }
                result.put(e.toString(), 0);
            }
        }
        return result;
    }
}

