/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.templates.groovy;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.javalang.visitors.VisitorSupport;
import org.walkmod.query.QueryEngine;
import org.walkmod.templates.TemplateEngine;
import org.walkmod.walkers.VisitorContext;

public class GroovyTemplateEngine
extends VisitorSupport<VisitorContext>
implements TemplateEngine {
    private VisitorContext context;
    private GStringTemplateEngine engine;
    private Map<String, Template> cache = new HashMap<String, Template>();

    @Override
    public void initialize(VisitorContext context, Object rootNode) {
        this.context = context;
        this.engine = new GStringTemplateEngine(context.getClassLoader());
        super.initialize(context, rootNode);
    }

    public String applyTemplate(File file) {
        Template template = this.cache.get(file.getAbsolutePath());
        if (template == null) {
            try {
                template = this.engine.createTemplate(file);
            }
            catch (Exception e) {
                throw new WalkModException((Throwable)e);
            }
        }
        HashMap<String, QueryEngine> bindings = new HashMap<String, QueryEngine>();
        bindings.putAll((Map<String, QueryEngine>)this.context);
        bindings.put("query", this.getQueryEngine());
        Writable wr = template.make(bindings);
        StringWriter sw = new StringWriter();
        try {
            wr.writeTo((Writer)sw);
        }
        catch (IOException e) {
            throw new WalkModException((Throwable)e);
        }
        return sw.toString();
    }

    public String applyTemplate(File template, File properties) {
        return this.applyTemplate(template);
    }
}

