/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cdi;

import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BeanManagerLookup {
    private static final Logger LOGGER = Logger.getLogger(BeanManagerLookup.class.getName());
    public static final String BEAN_MANAGER_JNDI = "java:comp/BeanManager";
    private static BeanManager BEAN_MANAGER = null;

    public static void setBeanManager(BeanManager aMgr) {
        BEAN_MANAGER = aMgr;
    }

    public static BeanManager lookup() {
        if (BEAN_MANAGER == null) {
            try {
                InitialContext ctx = new InitialContext();
                BEAN_MANAGER = (BeanManager)ctx.lookup(BEAN_MANAGER_JNDI);
                LOGGER.info("Beanmanager successfully located");
            }
            catch (NamingException e) {
                LOGGER.warning("No beanmanager was found, using null");
                BEAN_MANAGER = null;
            }
        }
        return BEAN_MANAGER;
    }
}

