/*
 * Decompiled with CFR 0.152.
 */
package org.wartremover;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.plugins.PluginPhase;
import dotty.tools.dotc.quoted.QuotesCache$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.transform.MegaPhase;
import dotty.tools.dotc.typer.TyperPhase$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wartremover.LogLevel;
import org.wartremover.LogLevel$Debug$;
import org.wartremover.LogLevel$Disable$;
import org.wartremover.LogLevel$Info$;
import org.wartremover.WartTraverser;
import org.wartremover.WartUniverse;
import org.wartremover.WartUniverse$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.quoted.Quotes;
import scala.quoted.runtime.impl.QuotesImpl$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class WartremoverPhase
extends MegaPhase.MiniPhase
implements PluginPhase {
    private final List<WartTraverser> errorWarts;
    private final List<WartTraverser> warningWarts;
    private final List<Tuple2<String, Throwable>> loadFailureWarts;
    private final List<String> excluded;
    private final LogLevel logLevel;
    private final AtomicBoolean initialLog;
    private final Set runsAfter;

    public WartremoverPhase(List<WartTraverser> errorWarts, List<WartTraverser> warningWarts, List<Tuple2<String, Throwable>> loadFailureWarts, List<String> excluded, LogLevel logLevel, AtomicBoolean initialLog) {
        this.errorWarts = errorWarts;
        this.warningWarts = warningWarts;
        this.loadFailureWarts = loadFailureWarts;
        this.excluded = excluded;
        this.logLevel = logLevel;
        this.initialLog = initialLog;
        this.runsAfter = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{TyperPhase$.MODULE$.name()}));
    }

    public String phaseName() {
        return "wartremover";
    }

    public void run(Contexts.Context c) {
        LogLevel logLevel = this.logLevel;
        if (LogLevel$Info$.MODULE$.equals(logLevel) || LogLevel$Debug$.MODULE$.equals(logLevel)) {
            if (this.initialLog.getAndSet(false)) {
                if (this.errorWarts.nonEmpty()) {
                    report$.MODULE$.echo(this::run$$anonfun$1, report$.MODULE$.echo$default$2(), c);
                }
                if (this.warningWarts.nonEmpty()) {
                    report$.MODULE$.echo(this::run$$anonfun$2, report$.MODULE$.echo$default$2(), c);
                }
                if (this.loadFailureWarts.nonEmpty()) {
                    report$.MODULE$.warning(this::run$$anonfun$3, report$.MODULE$.warning$default$2(), c);
                }
                if (this.excluded.nonEmpty()) {
                    report$.MODULE$.echo(this::run$$anonfun$4, report$.MODULE$.echo$default$2(), c);
                }
            }
        } else if (!LogLevel$Disable$.MODULE$.equals(logLevel)) {
            throw new MatchError((Object)logLevel);
        }
        String string = c.source().file().absolute().path();
        boolean skip = this.excluded.exists((Function1 & Serializable)x$0 -> string.startsWith((String)x$0));
        LogLevel logLevel2 = this.logLevel;
        if (!LogLevel$Info$.MODULE$.equals(logLevel2) && !LogLevel$Disable$.MODULE$.equals(logLevel2)) {
            if (LogLevel$Debug$.MODULE$.equals(logLevel2)) {
                if (skip) {
                    report$.MODULE$.echo(() -> WartremoverPhase.run$$anonfun$5(c), report$.MODULE$.echo$default$2(), c);
                } else {
                    report$.MODULE$.echo(() -> WartremoverPhase.run$$anonfun$6(c), report$.MODULE$.echo$default$2(), c);
                }
            } else {
                throw new MatchError((Object)logLevel2);
            }
        }
        if (!skip) {
            super.run(c);
            return;
        }
    }

    public Set<String> runsAfter() {
        return this.runsAfter;
    }

    public Contexts.Context prepareForUnit(Trees.Tree<Types.Type> tree, Contexts.Context c) {
        Contexts.FreshContext c2 = QuotesCache$.MODULE$.init(c.fresh());
        Quotes q = QuotesImpl$.MODULE$.apply((Contexts.Context)c2);
        this.errorWarts.foreach((Function1)(JProcedure1 & Serializable)w -> this.runWart$1((Trees.Tree)tree, c, q, (WartTraverser)w, false));
        this.warningWarts.foreach((Function1)(JProcedure1 & Serializable)w -> this.runWart$1((Trees.Tree)tree, c, q, (WartTraverser)w, true));
        return c;
    }

    private final String run$$anonfun$1() {
        return new StringBuilder(14).append("error warts = ").append(this.errorWarts.map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(_$1.getClass().getName()), 1)).mkString(", ")).toString();
    }

    private final String run$$anonfun$2() {
        return new StringBuilder(16).append("warning warts = ").append(this.warningWarts.map((Function1 & Serializable)_$2 -> StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(_$2.getClass().getName()), 1)).mkString(", ")).toString();
    }

    private final String run$$anonfun$3() {
        return new StringBuilder(21).append("load failure warts = ").append(this.loadFailureWarts.mkString(", ")).toString();
    }

    private final String run$$anonfun$4() {
        return new StringBuilder(11).append("excluded = ").append(this.excluded.mkString(", ")).toString();
    }

    private static final String run$$anonfun$5(Contexts.Context c$1) {
        return new StringBuilder(17).append("skip wartremover ").append(c$1.compilationUnit().source().file().toString()).toString();
    }

    private static final String run$$anonfun$6(Contexts.Context c$2) {
        return new StringBuilder(16).append("run wartremover ").append(c$2.compilationUnit().source().file().toString()).toString();
    }

    private static final String runWart$1$$anonfun$1(Throwable e$1) {
        return e$1.toString();
    }

    private final void runWart$1(Trees.Tree tree$1, Contexts.Context c$3, Quotes q$1, WartTraverser w, boolean onlyWarning) {
        block4: {
            WartUniverse universe = WartUniverse$.MODULE$.apply(onlyWarning, this.logLevel, q$1);
            WartUniverse.Traverser traverser = w.apply(universe);
            Trees.Tree t = tree$1;
            try {
                traverser.traverseTree(t, traverser.q().reflect().TreeMethods().symbol((Object)t));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    LogLevel logLevel = this.logLevel;
                    if (LogLevel$Disable$.MODULE$.equals(logLevel)) break block4;
                    if (LogLevel$Info$.MODULE$.equals(logLevel) || LogLevel$Debug$.MODULE$.equals(logLevel)) {
                        report$.MODULE$.warning(() -> WartremoverPhase.runWart$1$$anonfun$1(e), tree$1.srcPos(), c$3);
                    }
                    throw new MatchError((Object)logLevel);
                }
                throw throwable;
            }
        }
    }
}

