/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.watertemplate.Template;
import org.watertemplate.TemplateObject;

public abstract class TemplateMap<T> {
    final Map<String, T> map = new HashMap<String, T>();

    final void add(String key, T value) {
        this.map.put(key, value);
    }

    public static final class Arguments
    extends TemplateMap<TemplateObject> {
        public Arguments() {
        }

        public Arguments(Arguments arguments) {
            this.map.putAll(arguments.map);
        }

        public final <T> void addCollection(String key, Collection<T> iterable) {
            this.add(key, new TemplateObject.Collection<Object>(iterable, (a, b) -> {}));
        }

        public final <T> void addCollection(String key, Collection<T> iterable, BiConsumer<T, Arguments> mapper) {
            this.add(key, new TemplateObject.Collection<T>(iterable, mapper));
        }

        public final <T> void addMappedObject(String key, T object, BiConsumer<T, Arguments> mapper) {
            this.add(key, new TemplateObject.Mapped<T>(object, mapper));
        }

        public final <T> void addLocaleSensitiveObject(String key, T object, BiFunction<T, Locale, String> function) {
            this.add(key, new TemplateObject.LocaleSensitive<T>(object, function));
        }

        @Override
        public final void add(String key, String value) {
            this.add(key, new TemplateObject.Value(value));
        }

        @Override
        public final void add(String key, Boolean value) {
            this.add(key, new TemplateObject.Condition(value));
        }

        public final TemplateObject get(String key) {
            return (TemplateObject)this.map.get(key);
        }

        final void addTemplateWhichWontRenderItsMasterTemplate(String key, Template subTemplate) {
            this.add(key, new TemplateObject.SubTemplate.WithoutMaster(subTemplate));
        }
    }

    public static class SubTemplates
    extends TemplateMap<TemplateObject.SubTemplate> {
        List<TemplateObject.SubTemplate> list = new ArrayList<TemplateObject.SubTemplate>();

        SubTemplates() {
        }

        @Override
        public final void add(String key, Template subTemplate) {
            TemplateObject.SubTemplate templateObject = new TemplateObject.SubTemplate(subTemplate);
            this.add(key, templateObject);
            this.list.add(templateObject);
        }
    }
}

