/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate;

import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.watertemplate.Template;
import org.watertemplate.TemplateMap;
import org.watertemplate.exception.InvalidTemplateObjectEvaluationException;

public interface TemplateObject {
    public String evaluate(Locale var1);

    public static abstract class Mappable<T> {
        private final BiConsumer<T, TemplateMap.Arguments> mapper;

        Mappable(BiConsumer<T, TemplateMap.Arguments> mapper) {
            this.mapper = mapper;
        }

        public TemplateMap.Arguments map(T object) {
            TemplateMap.Arguments arguments = new TemplateMap.Arguments();
            this.mapper.accept(object, arguments);
            return arguments;
        }

        public BiConsumer<T, TemplateMap.Arguments> getMapper() {
            return this.mapper;
        }
    }

    public static class SubTemplate
    implements TemplateObject {
        final Template subTemplate;

        public SubTemplate(Template subTemplate) {
            this.subTemplate = subTemplate;
        }

        @Override
        public String evaluate(Locale locale) {
            return this.subTemplate.render(locale);
        }

        public static class WithoutMaster
        extends SubTemplate {
            public WithoutMaster(Template subTemplate) {
                super(subTemplate);
            }

            @Override
            public String evaluate(Locale locale) {
                return this.subTemplate.renderWithoutMaster(locale);
            }
        }
    }

    public static class Value
    implements TemplateObject {
        private final String value;

        public Value(String value) {
            this.value = value;
        }

        @Override
        public String evaluate(Locale locale) {
            return this.value;
        }
    }

    public static class Condition
    implements TemplateObject {
        private final Boolean value;

        public Condition(Boolean value) {
            this.value = value;
        }

        public Boolean isTrue() {
            return this.value;
        }

        @Override
        public String evaluate(Locale locale) {
            throw new InvalidTemplateObjectEvaluationException("Booleans should not be evaluated");
        }
    }

    public static final class Collection<T>
    extends Mappable<T>
    implements TemplateObject {
        private final java.util.Collection<T> collection;

        public Collection(java.util.Collection<T> collection, BiConsumer<T, TemplateMap.Arguments> mapper) {
            super(mapper);
            this.collection = collection;
        }

        public Boolean isEmpty() {
            return this.collection == null || !this.collection.iterator().hasNext();
        }

        public java.util.Collection<T> getCollection() {
            return this.collection;
        }

        @Override
        public String evaluate(Locale locale) {
            throw new InvalidTemplateObjectEvaluationException("Collections should not be evaluated");
        }
    }

    public static final class Mapped<T>
    extends Mappable<T>
    implements TemplateObject {
        private final T object;
        private final TemplateMap.Arguments mappedProperties;

        Mapped(T object, BiConsumer<T, TemplateMap.Arguments> mapper) {
            super(mapper);
            this.object = object;
            this.mappedProperties = this.map(object);
        }

        public TemplateMap.Arguments map() {
            return this.mappedProperties;
        }

        @Override
        public String evaluate(Locale locale) {
            if (this.object instanceof String) {
                return (String)this.object;
            }
            if (this.object instanceof SubTemplate) {
                return ((SubTemplate)this.object).evaluate(locale);
            }
            throw new InvalidTemplateObjectEvaluationException("Mapped objects should not be evaluated. If you're iterating, make sure your collection contains only Strings.");
        }
    }

    public static class LocaleSensitive<T>
    implements TemplateObject {
        private final BiFunction<T, Locale, String> function;
        private final T object;

        protected LocaleSensitive(T object, BiFunction<T, Locale, String> function) {
            this.function = function;
            this.object = object;
        }

        @Override
        public String evaluate(Locale locale) {
            return this.function.apply(this.object, locale);
        }
    }
}

