/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter;

import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import org.watertemplate.TemplateMap;
import org.watertemplate.interpreter.DefaultWaterInterpreter;
import org.watertemplate.interpreter.DeveloperWaterInterpreter;
import org.watertemplate.interpreter.exception.TemplateFileNotFoundException;
import org.watertemplate.interpreter.parser.AbstractSyntaxTree;
import org.watertemplate.interpreter.parser.Lexer;
import org.watertemplate.interpreter.parser.Parser;
import org.watertemplate.interpreter.parser.Token;

public abstract class WaterInterpreter {
    protected final String templateFilePath;
    protected final Locale defaultLocale;
    private static final BiFunction<String, Locale, WaterInterpreter> interpreter = System.getProperty("dev-mode") != null ? WaterInterpreter::newDeveloperInterpreter : WaterInterpreter::newDefaultInterpreter;

    WaterInterpreter(String templateFilePath, Locale defaultLocale) {
        this.templateFilePath = templateFilePath;
        this.defaultLocale = defaultLocale;
    }

    public abstract String string(TemplateMap.Arguments var1, Locale var2);

    AbstractSyntaxTree parse(List<Token> tokens) {
        return new Parser().parse(tokens);
    }

    List<Token> lex(InputStream stream) {
        return new Lexer().lex(stream);
    }

    InputStream templateFileWith(Locale locale) {
        String templateFileURI = "templates/" + locale + "/" + this.templateFilePath;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(templateFileURI);
        if (stream == null && !locale.equals(this.defaultLocale)) {
            stream = this.templateFileWith(this.defaultLocale);
        }
        if (stream == null) {
            throw new TemplateFileNotFoundException(this.templateFilePath);
        }
        return stream;
    }

    public static WaterInterpreter instantiate(String filePath, Locale defaultLocale) {
        return interpreter.apply(filePath, defaultLocale);
    }

    private static WaterInterpreter newDefaultInterpreter(String filePath, Locale defaultLocale) {
        return new DefaultWaterInterpreter(filePath, defaultLocale);
    }

    private static WaterInterpreter newDeveloperInterpreter(String filePath, Locale defaultLocale) {
        return new DeveloperWaterInterpreter(filePath, defaultLocale);
    }
}

