/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.watertemplate.TemplateMap;
import org.watertemplate.TemplateObject;
import org.watertemplate.interpreter.parser.exception.IdCouldNotBeResolvedException;

public abstract class AbstractSyntaxTree {
    static final AbstractSyntaxTree EMPTY = new Empty();

    public abstract String string(TemplateMap.Arguments var1, Locale var2);

    private static class Empty
    extends AbstractSyntaxTree {
        private Empty() {
        }

        @Override
        public String string(TemplateMap.Arguments arguments, Locale locale) {
            return "";
        }
    }

    static class Text
    extends AbstractSyntaxTree {
        private final String value;

        public Text(String value) {
            this.value = value;
        }

        @Override
        public String string(TemplateMap.Arguments arguments, Locale locale) {
            return this.value;
        }
    }

    static class Statements
    extends AbstractSyntaxTree {
        private final List<AbstractSyntaxTree> abstractSyntaxTrees;

        public Statements(List<AbstractSyntaxTree> abstractSyntaxTrees) {
            this.abstractSyntaxTrees = abstractSyntaxTrees.stream().flatMap(this::flatten).collect(Collectors.toList());
        }

        private Stream<AbstractSyntaxTree> flatten(AbstractSyntaxTree ast) {
            if (ast instanceof Statements) {
                return ((Statements)ast).abstractSyntaxTrees.stream();
            }
            if (ast != EMPTY) {
                return Stream.of(ast);
            }
            return Stream.of(new AbstractSyntaxTree[0]);
        }

        @Override
        public String string(TemplateMap.Arguments arguments, Locale locale) {
            StringBuilder sb = new StringBuilder();
            for (AbstractSyntaxTree ast : this.abstractSyntaxTrees) {
                sb.append(ast.string(arguments, locale));
            }
            return sb.toString();
        }
    }

    static class If
    extends AbstractSyntaxTree {
        private final Id conditionId;
        private final AbstractSyntaxTree ifStatements;
        private final AbstractSyntaxTree elseStatements;

        public If(Id conditionId, AbstractSyntaxTree ifStatements) {
            this(conditionId, ifStatements, EMPTY);
        }

        public If(Id conditionId, AbstractSyntaxTree ifStatements, AbstractSyntaxTree elseStatements) {
            this.conditionId = conditionId;
            this.ifStatements = ifStatements;
            this.elseStatements = elseStatements;
        }

        @Override
        public String string(TemplateMap.Arguments arguments, Locale locale) {
            TemplateObject.Condition condition = (TemplateObject.Condition)this.conditionId.templateObject(arguments);
            if (condition.isTrue().booleanValue()) {
                return this.ifStatements.string(arguments, locale);
            }
            return this.elseStatements.string(arguments, locale);
        }
    }

    static class Id
    extends AbstractSyntaxTree {
        private final String propertyKey;
        private final Id nestedId;

        public Id(String propertyKey) {
            this(propertyKey, null);
        }

        public Id(String propertyKey, Id nestedId) {
            this.propertyKey = propertyKey;
            this.nestedId = nestedId;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        private String getFullId() {
            if (this.nestedId == null) {
                return this.propertyKey;
            }
            return this.propertyKey + "." + this.nestedId.getFullId();
        }

        TemplateObject templateObject(TemplateMap.Arguments arguments) {
            TemplateObject object = arguments.get(this.propertyKey);
            if (object == null) {
                throw new IdCouldNotBeResolvedException(this.getFullId());
            }
            if (this.nestedId == null) {
                return object;
            }
            if (!(object instanceof TemplateObject.Mapped)) {
                throw new IdCouldNotBeResolvedException(this.getFullId());
            }
            try {
                TemplateMap.Arguments mappedProperties = ((TemplateObject.Mapped)object).map();
                return this.nestedId.templateObject(mappedProperties);
            }
            catch (IdCouldNotBeResolvedException e) {
                throw new IdCouldNotBeResolvedException(this.getFullId());
            }
        }

        @Override
        public String string(TemplateMap.Arguments arguments, Locale locale) {
            return this.templateObject(arguments).evaluate(locale);
        }
    }

    static class For
    extends AbstractSyntaxTree {
        private final String variableName;
        private final Id collectionId;
        private final AbstractSyntaxTree forStatements;
        private final AbstractSyntaxTree elseStatements;

        public For(String variableName, Id collectionId, AbstractSyntaxTree forStatements) {
            this(variableName, collectionId, forStatements, EMPTY);
        }

        @Override
        public String string(TemplateMap.Arguments arguments, Locale locale) {
            TemplateObject.Collection collection = (TemplateObject.Collection)this.collectionId.templateObject(arguments);
            if (collection.isEmpty().booleanValue()) {
                return this.elseStatements.string(arguments, locale);
            }
            TemplateMap.Arguments forArguments = new TemplateMap.Arguments(arguments);
            BiConsumer mapper = collection.getMapper();
            StringBuilder sb = new StringBuilder();
            for (Object item : collection.getCollection()) {
                forArguments.addMappedObject(this.variableName, item, mapper);
                sb.append(this.forStatements.string(forArguments, locale));
            }
            return sb.toString();
        }

        public For(String variableName, Id collectionId, AbstractSyntaxTree forStatements, AbstractSyntaxTree elseStatements) {
            this.variableName = variableName;
            this.collectionId = collectionId;
            this.forStatements = forStatements;
            this.elseStatements = elseStatements;
        }
    }
}

