/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.watertemplate.interpreter.parser.AbstractSyntaxTree;
import org.watertemplate.interpreter.parser.GrammarSymbol;
import org.watertemplate.interpreter.parser.NonTerminal;
import org.watertemplate.interpreter.parser.Terminal;
import org.watertemplate.interpreter.parser.TokenStream;
import org.watertemplate.interpreter.parser.exception.ParseException;

abstract class Production
implements GrammarSymbol {
    private final List<GrammarSymbol> symbols;

    Production(GrammarSymbol ... symbols) {
        this.symbols = Arrays.asList(symbols);
    }

    @Override
    public AbstractSyntaxTree buildAbstractSyntaxTree(TokenStream tokenStream) {
        ArrayList<AbstractSyntaxTree> abstractSyntaxTrees = new ArrayList<AbstractSyntaxTree>();
        int save = tokenStream.getCurrentTokenPosition();
        try {
            for (GrammarSymbol symbol : this.symbols) {
                abstractSyntaxTrees.add(symbol.buildAbstractSyntaxTree(tokenStream));
            }
        }
        catch (ParseException e) {
            tokenStream.reset(save);
            throw e;
        }
        return this.zip(abstractSyntaxTrees);
    }

    abstract AbstractSyntaxTree zip(List<AbstractSyntaxTree> var1);

    static class Empty
    extends Production {
        Empty() {
            super(new GrammarSymbol[0]);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            return AbstractSyntaxTree.EMPTY;
        }
    }

    static class Statements
    extends Production {
        public Statements(GrammarSymbol ... statements) {
            super(statements);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            return new AbstractSyntaxTree.Statements(statements);
        }
    }

    static class Evaluation
    extends Production {
        Evaluation() {
            super(Terminal.WAVE, NonTerminal.ID, Terminal.WAVE);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            return statements.get(1);
        }
    }

    static class NestedProperty
    extends Production {
        NestedProperty() {
            super(Terminal.ACCESSOR, NonTerminal.ID);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            return statements.get(1);
        }
    }

    static class Id
    extends Production {
        Id() {
            super(Terminal.PROPERTY_KEY, NonTerminal.NESTED_PROP);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            AbstractSyntaxTree.Id propertyKey = (AbstractSyntaxTree.Id)statements.get(0);
            AbstractSyntaxTree nested = statements.get(1);
            if (nested == AbstractSyntaxTree.EMPTY) {
                return propertyKey;
            }
            return new AbstractSyntaxTree.Id(propertyKey.getPropertyKey(), (AbstractSyntaxTree.Id)nested);
        }
    }

    static class ForElse
    extends Production {
        ForElse() {
            super(Terminal.WAVE, Terminal.FOR, Terminal.BLANK, Terminal.PROPERTY_KEY, Terminal.BLANK, Terminal.IN, Terminal.BLANK, NonTerminal.ID, Terminal.COLON, NonTerminal.STATEMENTS, Terminal.ELSE, NonTerminal.STATEMENTS, Terminal.END_OF_BLOCK);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            String propertyKey = ((AbstractSyntaxTree.Id)statements.get(3)).getPropertyKey();
            AbstractSyntaxTree.Id collectionId = (AbstractSyntaxTree.Id)statements.get(7);
            AbstractSyntaxTree forStatements = statements.get(9);
            AbstractSyntaxTree elseStatements = statements.get(11);
            return new AbstractSyntaxTree.For(propertyKey, collectionId, forStatements, elseStatements);
        }
    }

    static class For
    extends Production {
        For() {
            super(Terminal.WAVE, Terminal.FOR, Terminal.BLANK, Terminal.PROPERTY_KEY, Terminal.BLANK, Terminal.IN, Terminal.BLANK, NonTerminal.ID, Terminal.COLON, NonTerminal.STATEMENTS, Terminal.END_OF_BLOCK);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            String propertyKey = ((AbstractSyntaxTree.Id)statements.get(3)).getPropertyKey();
            AbstractSyntaxTree.Id collectionId = (AbstractSyntaxTree.Id)statements.get(7);
            AbstractSyntaxTree forStatements = statements.get(9);
            return new AbstractSyntaxTree.For(propertyKey, collectionId, forStatements);
        }
    }

    static class IfElse
    extends Production {
        IfElse() {
            super(Terminal.WAVE, Terminal.IF, Terminal.BLANK, NonTerminal.ID, Terminal.COLON, NonTerminal.STATEMENTS, Terminal.ELSE, NonTerminal.STATEMENTS, Terminal.END_OF_BLOCK);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            AbstractSyntaxTree.Id conditionId = (AbstractSyntaxTree.Id)statements.get(3);
            AbstractSyntaxTree ifStatements = statements.get(5);
            AbstractSyntaxTree elseStatements = statements.get(7);
            return new AbstractSyntaxTree.If(conditionId, ifStatements, elseStatements);
        }
    }

    static class If
    extends Production {
        If() {
            super(Terminal.WAVE, Terminal.IF, Terminal.BLANK, NonTerminal.ID, Terminal.COLON, NonTerminal.STATEMENTS, Terminal.END_OF_BLOCK);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            AbstractSyntaxTree.Id conditionId = (AbstractSyntaxTree.Id)statements.get(3);
            AbstractSyntaxTree ifStatements = statements.get(5);
            return new AbstractSyntaxTree.If(conditionId, ifStatements);
        }
    }
}

