/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.watertemplate.interpreter.parser.AbstractSyntaxTree;
import org.watertemplate.interpreter.parser.GrammarSymbol;
import org.watertemplate.interpreter.parser.Token;
import org.watertemplate.interpreter.parser.TokenStream;
import org.watertemplate.interpreter.parser.exception.IncorrectLocationForToken;

enum Terminal implements GrammarSymbol
{
    IF("if"::startsWith, "if"::equals),
    IN("in"::startsWith, "in"::equals),
    FOR("for"::startsWith, "for"::equals),
    ELSE(":else:"::startsWith, ":else:"::equals),
    END_OF_BLOCK(":~"::startsWith, ":~"::equals),
    ACCESSOR("."::equals),
    COLON(":"::equals),
    WAVE("~"::equals),
    BLANK(s -> s.trim().isEmpty()),
    PROPERTY_KEY(Terminal::propertyKeyPatternMatches){

        @Override
        public AbstractSyntaxTree buildAbstractSyntaxTree(Token token) {
            return new AbstractSyntaxTree.Id(token.getValue());
        }
    }
    ,
    TEXT(s -> s.length() == 1 || !s.endsWith("\u0000") && !s.endsWith(":") && !s.endsWith("~")){

        @Override
        public AbstractSyntaxTree buildAbstractSyntaxTree(Token token) {
            return new AbstractSyntaxTree.Text(token.getValue());
        }
    }
    ,
    END_OF_INPUT("\u0000"::equals);

    private static final Pattern PROPERTY_KEY_PATTERN;
    private final Function<String, Boolean> isCandidate;
    private final Function<String, Boolean> isAcceptable;

    private Terminal(Function<String, Boolean> isCandidate) {
        this(isCandidate, isCandidate);
    }

    private Terminal(Function<String, Boolean> isCandidate, Function<String, Boolean> isAcceptable) {
        this.isCandidate = isCandidate;
        this.isAcceptable = isAcceptable;
    }

    public final Boolean isCandidateFrom(String s) {
        return this.isCandidate.apply(s);
    }

    public final Boolean isAcceptableFrom(String s) {
        return this.isAcceptable.apply(s);
    }

    private static Boolean propertyKeyPatternMatches(String s) {
        return PROPERTY_KEY_PATTERN.matcher(s).matches();
    }

    @Override
    public final AbstractSyntaxTree buildAbstractSyntaxTree(TokenStream tokenStream) {
        Token current = tokenStream.current();
        if (!current.canBe(this)) {
            throw new IncorrectLocationForToken(this, current);
        }
        tokenStream.shift();
        return this.buildAbstractSyntaxTree(current);
    }

    AbstractSyntaxTree buildAbstractSyntaxTree(Token current) {
        return AbstractSyntaxTree.EMPTY;
    }

    static {
        PROPERTY_KEY_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    }
}

