/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.Collections;
import java.util.List;
import org.watertemplate.interpreter.parser.Terminal;

public class Token {
    static final Token END_OF_INPUT = new Token("\u0000", Terminal.END_OF_INPUT);
    private final String value;
    private final List<Terminal> possibleTerminals;

    Token(String value, Terminal possibleTerminals) {
        this.possibleTerminals = Collections.singletonList(possibleTerminals);
        this.value = value;
    }

    Token(String value, List<Terminal> possibleTerminals) {
        this.possibleTerminals = possibleTerminals;
        this.value = value;
    }

    String getValue() {
        return this.value;
    }

    boolean canBe(Terminal terminal) {
        return this.possibleTerminals.contains(terminal);
    }

    public String toString() {
        return "[" + this.possibleTerminals.stream().map(Enum::toString).reduce((a, b) -> a + "|" + b).get() + "] -> [" + this.value + "]";
    }
}

