/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.Arrays;
import java.util.List;
import org.watertemplate.interpreter.parser.Token;
import org.watertemplate.interpreter.parser.exception.NoMoreTokensOnStreamException;

class TokenStream {
    private final List<Token> tokens;
    private int currentTokenPosition;

    TokenStream(Token ... tokens) {
        this(Arrays.asList(tokens));
    }

    TokenStream(List<Token> tokens) {
        this.tokens = tokens;
        this.currentTokenPosition = 0;
    }

    boolean hasAny() {
        return !this.tokens.isEmpty();
    }

    public Token current() throws NoMoreTokensOnStreamException {
        if (this.currentTokenPosition >= this.tokens.size()) {
            throw new NoMoreTokensOnStreamException();
        }
        return this.tokens.get(this.currentTokenPosition);
    }

    public void reset(int save) {
        this.currentTokenPosition = save;
    }

    public void shift() {
        ++this.currentTokenPosition;
    }

    public int remaining() {
        return this.tokens.size() - this.currentTokenPosition;
    }

    public int getCurrentTokenPosition() {
        return this.currentTokenPosition;
    }
}

