package org.weakref.jmx.guice;

import org.weakref.jmx.internal.guava.reflect.TypeParameter;
import org.weakref.jmx.internal.guava.reflect.TypeToken;
import com.google.inject.Key;

import java.lang.reflect.Type;
import java.util.Set;

class SetMapping<T>
{
    private final ObjectNameFunction<T> objectNameFunction;
    private final Class<T> clazz;

    SetMapping(Class<T> key, ObjectNameFunction<T> objectNameFunction)
    {
        this.clazz = key;
        this.objectNameFunction = objectNameFunction;
    }

    public ObjectNameFunction<T> getObjectNameFunction()
    {
        return objectNameFunction;
    }

    public Key<Set<T>> getKey()
    {
        return (Key<Set<T>>) Key.get(setOf(clazz));
    }

    private static <K> Type setOf(Class<K> clazz)
    {
        return new TypeToken<Set<K>>() {}.where(new TypeParameter<K>() {}, TypeToken.of(clazz)).getType();
    }

}
