package org.weakref.jmx.guice;

import org.weakref.jmx.internal.guava.base.Throwables;
import com.google.inject.multibindings.Multibinder;
import org.weakref.jmx.ObjectNames;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import java.util.Map;
import java.util.Map.Entry;

public class StringMapExportBinder<V>
    extends MapExportBinder<String, V>
{
    private final Class<V> valueClass;

    StringMapExportBinder(Multibinder<MapMapping<?, ?>> binder, Class<V> valueClass)
    {
        super(binder, String.class, valueClass);
        this.valueClass = valueClass;
    }

    public void withGeneratedName()
    {
        ObjectNameFunction<Entry<String, V>> namingFunction = new ObjectNameFunction<Map.Entry<String, V>>()
        {
            public ObjectName name(Map.Entry<String, V> entry)
            {
                try {
                    return new ObjectName(ObjectNames.generatedNameOf(valueClass, entry.getKey()));
                }
                catch (MalformedObjectNameException e) {
                    throw Throwables.propagate(e);
                }
            }
        };

        binder.addBinding().toInstance(new MapMapping<String, V>(String.class, valueClass, namingFunction));
    }
}
