/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Concurrency utilities.
 *
 * <p>Commonly used types include {@link
 * org.weakref.jmx.internal.guava.util.concurrent.ListenableFuture} and {@link
 * org.weakref.jmx.internal.guava.util.concurrent.Service}.
 *
 * <p>Commonly used utilities include {@link
 * org.weakref.jmx.internal.guava.util.concurrent.Futures}, {@link
 * org.weakref.jmx.internal.guava.util.concurrent.MoreExecutors}, and {@link
 * org.weakref.jmx.internal.guava.util.concurrent.ThreadFactoryBuilder}.
 *
 * <p>This package is a part of the open-source
 * <a href="http://guava-libraries.googlecode.com">Guava libraries</a>.
 */
@ParametersAreNonnullByDefault
package org.weakref.jmx.internal.guava.util.concurrent;

import javax.annotation.ParametersAreNonnullByDefault;

