/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains generic collection interfaces and implementations, and other utilities for
 * working with collections. It is a part of the open-source <a
 * href="http://github.com/google/guava">Guava</a> library.
 *
 * <h2>Collection Types</h2>
 *
 * <dl>
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.BiMap}
 *   <dd>An extension of {@link java.util.Map} that guarantees the uniqueness of its values as well
 *       as that of its keys. This is sometimes called an "invertible map," since the restriction on
 *       values enables it to support an {@linkplain org.weakref.jmx.$internal.guava.collect.BiMap#inverse inverse
 *       view} -- which is another instance of {@code BiMap}.
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.Multiset}
 *   <dd>An extension of {@link java.util.Collection} that may contain duplicate values like a
 *       {@link java.util.List}, yet has order-independent equality like a {@link java.util.Set}.
 *       One typical use for a multiset is to represent a histogram.
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.Multimap}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but may contain multiple entries
 *       with the same key. Some behaviors of {@link org.weakref.jmx.$internal.guava.collect.Multimap} are left
 *       unspecified and are provided only by the subtypes mentioned below.
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.ListMultimap}
 *   <dd>An extension of {@link org.weakref.jmx.$internal.guava.collect.Multimap} which permits duplicate entries,
 *       supports random access of values for a particular key, and has <i>partially order-dependent
 *       equality</i> as defined by {@link org.weakref.jmx.$internal.guava.collect.ListMultimap#equals(Object)}.
 *       {@code ListMultimap} takes its name from the fact that the {@linkplain
 *       org.weakref.jmx.$internal.guava.collect.ListMultimap#get collection of values} associated with a given
 *       key fulfills the {@link java.util.List} contract.
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.SetMultimap}
 *   <dd>An extension of {@link org.weakref.jmx.$internal.guava.collect.Multimap} which has order-independent
 *       equality and does not allow duplicate entries; that is, while a key may appear twice in a
 *       {@code SetMultimap}, each must map to a different value. {@code SetMultimap} takes its name
 *       from the fact that the {@linkplain org.weakref.jmx.$internal.guava.collect.SetMultimap#get collection of
 *       values} associated with a given key fulfills the {@link java.util.Set} contract.
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.SortedSetMultimap}
 *   <dd>An extension of {@link org.weakref.jmx.$internal.guava.collect.SetMultimap} for which the {@linkplain
 *       org.weakref.jmx.$internal.guava.collect.SortedSetMultimap#get collection values} associated with a given
 *       key is a {@link java.util.SortedSet}.
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.Table}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but which indexes its values by an
 *       ordered pair of keys, a row key and column key.
 *   <dt>{@link org.weakref.jmx.$internal.guava.collect.ClassToInstanceMap}
 *   <dd>An extension of {@link java.util.Map} that associates a raw type with an instance of that
 *       type.
 * </dl>
 *
 * <h2>Collection Implementations</h2>
 *
 * <h3>of {@link java.util.List}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableList}
 * </ul>
 *
 * <h3>of {@link java.util.Set}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableSet}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableSortedSet}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ContiguousSet} (see {@code Range})
 * </ul>
 *
 * <h3>of {@link java.util.Map}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableSortedMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.MapMaker}
 * </ul>
 *
 * <h3>of {@link org.weakref.jmx.$internal.guava.collect.BiMap}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableBiMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.HashBiMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.EnumBiMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.EnumHashBiMap}
 * </ul>
 *
 * <h3>of {@link org.weakref.jmx.$internal.guava.collect.Multiset}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableSortedMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.HashMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.LinkedHashMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.TreeMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.EnumMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ConcurrentHashMultiset}
 * </ul>
 *
 * <h3>of {@link org.weakref.jmx.$internal.guava.collect.Multimap}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableListMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableSetMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ArrayListMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.HashMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.TreeMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.LinkedHashMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.LinkedListMultimap}
 * </ul>
 *
 * <h3>of {@link org.weakref.jmx.$internal.guava.collect.Table}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableTable}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ArrayTable}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.HashBasedTable}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.TreeBasedTable}
 * </ul>
 *
 * <h3>of {@link org.weakref.jmx.$internal.guava.collect.ClassToInstanceMap}</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableClassToInstanceMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.MutableClassToInstanceMap}
 * </ul>
 *
 * <h2>Classes of static utility methods</h2>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Collections2}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Iterators}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Iterables}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Lists}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Maps}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Queues}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Sets}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Multisets}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Multimaps}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Tables}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ObjectArrays}
 * </ul>
 *
 * <h2>Comparison</h2>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Ordering}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ComparisonChain}
 * </ul>
 *
 * <h2>Abstract implementations</h2>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.AbstractIterator}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.AbstractSequentialIterator}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ImmutableCollection}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.UnmodifiableIterator}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.UnmodifiableListIterator}
 * </ul>
 *
 * <h2>Ranges</h2>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Range}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.RangeMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.DiscreteDomain}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ContiguousSet}
 * </ul>
 *
 * <h2>Other</h2>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.Interner}, {@link org.weakref.jmx.$internal.guava.collect.Interners}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.MapDifference}, {@link
 *       org.weakref.jmx.$internal.guava.collect.SortedMapDifference}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.MinMaxPriorityQueue}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.PeekingIterator}
 * </ul>
 *
 * <h2>Forwarding collections</h2>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingCollection}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingConcurrentMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingIterator}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingList}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingListIterator}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingListMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingMapEntry}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingNavigableMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingNavigableSet}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingObject}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingQueue}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingSet}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingSetMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingSortedMap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingSortedMultiset}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingSortedSet}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingSortedSetMultimap}
 *   <li>{@link org.weakref.jmx.$internal.guava.collect.ForwardingTable}
 * </ul>
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package org.weakref.jmx.$internal.guava.collect;

import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
