/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source <a href="http://github.com/google/guava">Guava</a>
 * library.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Ascii}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.CaseFormat}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.CharMatcher}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Charsets}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Joiner}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Splitter}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Function}, {@link org.weakref.jmx.\$internal.guava.base.Functions}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Predicate}, {@link org.weakref.jmx.\$internal.guava.base.Predicates}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Equivalence}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Converter}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Supplier}, {@link org.weakref.jmx.\$internal.guava.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Defaults}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Enums}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Objects}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Optional}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Preconditions}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Stopwatch}
 *   <li>{@link org.weakref.jmx.\$internal.guava.base.Throwables}
 * </ul>
 *
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package org.weakref.jmx.\$internal.guava.base;

import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
