/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.web3j.abi.TypeMappingException;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Fixed;
import org.web3j.abi.datatypes.Int;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.StructType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.reflection.Parameterized;

public class Utils {
    private Utils() {
    }

    static <T extends Type> String getTypeName(TypeReference<T> typeReference) {
        try {
            java.lang.reflect.Type reflectedType = typeReference.getType();
            if (reflectedType instanceof ParameterizedType) {
                Class type = (Class)((ParameterizedType)reflectedType).getRawType();
                return Utils.getParameterizedTypeName(typeReference, type);
            }
            if (typeReference.getSubTypeReference() != null) {
                return Utils.getParameterizedTypeName(typeReference, typeReference.getClassType());
            }
            Class<?> type = Class.forName(Utils.getTypeName(reflectedType));
            if (StructType.class.isAssignableFrom(type)) {
                return Utils.getStructType(type);
            }
            return Utils.getSimpleTypeName(type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    public static String getStructType(Class type) {
        StringBuilder sb = new StringBuilder("(");
        Constructor constructor = Utils.findStructConstructor(type);
        Class<?>[] itemTypes = constructor.getParameterTypes();
        for (int i = 0; i < itemTypes.length; ++i) {
            Class<?> cls = itemTypes[i];
            if (StructType.class.isAssignableFrom(cls)) {
                sb.append(Utils.getStructType(cls));
            } else {
                Class parameterAnnotation = Utils.extractParameterFromAnnotation(constructor.getParameterAnnotations()[i]);
                if (parameterAnnotation != null) {
                    sb.append(Utils.getTypeName(Utils.getDynamicArrayTypeReference(parameterAnnotation)));
                } else {
                    sb.append(Utils.getTypeName(TypeReference.create(cls)));
                }
            }
            if (i >= itemTypes.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static TypeReference<DynamicArray> getDynamicArrayTypeReference(final Class parameter) {
        return new TypeReference<DynamicArray>(){

            @Override
            TypeReference getSubTypeReference() {
                return TypeReference.create(parameter);
            }
        };
    }

    public static <T extends Type> Class<T> extractParameterFromAnnotation(Annotation[] parameterAnnotation) {
        for (Annotation a : parameterAnnotation) {
            if (!Parameterized.class.isInstance(a)) continue;
            return ((Parameterized)a).type();
        }
        return null;
    }

    public static Constructor findStructConstructor(Class classType) {
        return Arrays.stream(classType.getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom)).findAny().orElseThrow(() -> new RuntimeException("TypeReferenced struct must contain a constructor with types that extend Type"));
    }

    static String getSimpleTypeName(Class<?> type) {
        String simpleName = type.getSimpleName().toLowerCase();
        if (type.equals(Uint.class) || type.equals(Int.class) || type.equals(Ufixed.class) || type.equals(Fixed.class)) {
            return simpleName + "256";
        }
        if (type.equals(Utf8String.class)) {
            return "string";
        }
        if (type.equals(DynamicBytes.class)) {
            return "bytes";
        }
        if (StructType.class.isAssignableFrom(type)) {
            return type.getName();
        }
        return simpleName;
    }

    static <T extends Type, U extends Type> String getParameterizedTypeName(TypeReference<T> typeReference, Class<?> type) {
        try {
            if (type.equals(DynamicArray.class)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.simpleNameOrStruct(parameterizedType);
                return parameterizedTypeName + "[]";
            }
            if (StaticArray.class.isAssignableFrom(type)) {
                Class<T> parameterizedType = Utils.getParameterizedTypeFromArray(typeReference);
                String parameterizedTypeName = Utils.simpleNameOrStruct(parameterizedType);
                int length = TypeReference.StaticArrayTypeReference.class.isAssignableFrom(typeReference.getClass()) ? ((TypeReference.StaticArrayTypeReference)typeReference).getSize() : Integer.parseInt(type.getSimpleName().replaceAll("\\D+", ""));
                return parameterizedTypeName + "[" + length + "]";
            }
            throw new UnsupportedOperationException("Invalid type provided " + type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static <U extends Type> String simpleNameOrStruct(Class<U> parameterizedType) {
        if (StructType.class.isAssignableFrom(parameterizedType)) {
            return Utils.getStructType(parameterizedType);
        }
        return Utils.getSimpleTypeName(parameterizedType);
    }

    static <T extends Type> Class<T> getParameterizedTypeFromArray(TypeReference typeReference) throws ClassNotFoundException {
        if (typeReference.getSubTypeReference() != null) {
            return typeReference.getSubTypeReference().getClassType();
        }
        java.lang.reflect.Type type = typeReference.getType();
        java.lang.reflect.Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
        if (typeArguments[0] instanceof ParameterizedType) {
            return Class.forName(Utils.getTypeName(((ParameterizedType)typeArguments[0]).getRawType()));
        }
        String parameterizedTypeName = Utils.getTypeName(typeArguments[0]);
        return Class.forName(parameterizedTypeName);
    }

    static <T extends Type> Class<T> getFullParameterizedTypeFromArray(TypeReference typeReference) throws ClassNotFoundException {
        java.lang.reflect.Type type = typeReference.getType();
        java.lang.reflect.Type typeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
        return Class.forName(((ParameterizedType)typeArgument).getActualTypeArguments()[0].getTypeName());
    }

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(input.size());
        result.addAll(input.stream().map(typeReference -> typeReference).collect(Collectors.toList()));
        return result;
    }

    public static <T, R extends Type<T>, E extends Type<T>> List<E> typeMap(List<List<T>> input, Class<E> outerDestType, Class<R> innerType) {
        ArrayList<Type> result = new ArrayList<Type>();
        try {
            Constructor<E> constructor = outerDestType.getDeclaredConstructor(Class.class, List.class);
            for (List<T> ts : input) {
                Type e = (Type)constructor.newInstance(innerType, Utils.typeMap(ts, innerType));
                result.add(e);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TypeMappingException(e);
        }
        return result;
    }

    public static <T, R extends Type<T>> List<R> typeMap(List<T> input, Class<R> destType) throws TypeMappingException {
        ArrayList<Type> result = new ArrayList<Type>(input.size());
        if (!input.isEmpty()) {
            try {
                Constructor<R> constructor = destType.getDeclaredConstructor(input.get(0).getClass());
                for (T value : input) {
                    result.add((Type)constructor.newInstance(value));
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TypeMappingException(e);
            }
        }
        return result;
    }

    public static List<Field> staticStructNestedPublicFieldsFlatList(Class<Type> classType) {
        return Utils.staticStructsNestedFieldsFlatList(classType).stream().filter(field -> Modifier.isPublic(field.getModifiers())).collect(Collectors.toList());
    }

    public static List<Field> staticStructsNestedFieldsFlatList(Class<Type> classType) {
        List canonicalFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> !StaticStruct.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
        List nestedFields = Arrays.stream(classType.getDeclaredFields()).filter(field -> StaticStruct.class.isAssignableFrom(field.getType())).map(field -> Utils.staticStructsNestedFieldsFlatList(field.getType())).flatMap(Collection::stream).collect(Collectors.toList());
        return Stream.concat(canonicalFields.stream(), nestedFields.stream()).collect(Collectors.toList());
    }

    public static String getTypeName(java.lang.reflect.Type type) {
        try {
            return type.getTypeName();
        }
        catch (NoSuchMethodError e) {
            return Utils.getClassName((Class)type);
        }
    }

    private static String getClassName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }
}

