/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.aion.tx;

import java.math.BigInteger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import org.aion.rlp.RLP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.aion.VirtualMachine;
import org.web3j.aion.crypto.AionTransaction;
import org.web3j.aion.crypto.Ed25519KeyPair;
import org.web3j.aion.protocol.Aion;
import org.web3j.crypto.Hash;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.exceptions.TxHashMismatchException;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J>\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JG\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&*\u00020#H\u0002\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/web3j/aion/tx/AionTransactionManager;", "Lorg/web3j/tx/TransactionManager;", "aion", "Lorg/web3j/aion/protocol/Aion;", "keyPair", "Lorg/web3j/aion/crypto/Ed25519KeyPair;", "targetVm", "Lorg/web3j/aion/VirtualMachine;", "(Lorg/web3j/aion/protocol/Aion;Lorg/web3j/aion/crypto/Ed25519KeyPair;Lorg/web3j/aion/VirtualMachine;)V", "attempts", "", "sleepDuration", "", "(Lorg/web3j/aion/protocol/Aion;Lorg/web3j/aion/crypto/Ed25519KeyPair;Lorg/web3j/aion/VirtualMachine;IJ)V", "getNonce", "Ljava/math/BigInteger;", "getNrgPrice", "sendCall", "", "to", "data", "defaultBlockParameter", "Lorg/web3j/protocol/core/DefaultBlockParameter;", "sendTransaction", "Lorg/web3j/protocol/core/methods/response/EthSendTransaction;", "gasPrice", "gasLimit", "value", "constructor", "", "nrgPrice", "nrgLimit", "(Ljava/lang/Long;JLjava/lang/String;Ljava/lang/String;Ljava/lang/Long;Z)Lorg/web3j/protocol/core/methods/response/EthSendTransaction;", "sign", "transaction", "Lorg/web3j/aion/crypto/AionTransaction;", "sign$web3j_aion_common", "toRplElements", "", "", "(Lorg/web3j/aion/crypto/AionTransaction;)[[B", "Companion", "web3j-aion-common"})
public final class AionTransactionManager
extends TransactionManager {
    private final Aion aion;
    private final Ed25519KeyPair keyPair;
    private final VirtualMachine targetVm;
    public static final byte TRANSACTION_TYPE_OTHER = 1;
    public static final byte TRANSACTION_TYPE_AVM_CONSTRUCTOR = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EthSendTransaction sendTransaction(@Nullable Long nrgPrice, long nrgLimit, @NotNull String to, @NotNull String data, @Nullable Long value, boolean constructor) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        boolean bl;
        AionTransactionManager aionTransactionManager;
        long l;
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        AionTransactionManager aionTransactionManager2 = this;
        Long l2 = nrgPrice;
        if (l2 != null) {
            l = l2;
            aionTransactionManager = aionTransactionManager2;
            bl = false;
            BigInteger bigInteger4 = BigInteger.valueOf(l);
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger4, (String)"BigInteger.valueOf(this)");
            bigInteger3 = bigInteger4;
            aionTransactionManager2 = aionTransactionManager;
            bigInteger2 = bigInteger3;
        } else {
            bigInteger2 = null;
        }
        l = nrgLimit;
        bigInteger3 = bigInteger2;
        aionTransactionManager = aionTransactionManager2;
        bl = false;
        BigInteger bigInteger5 = BigInteger.valueOf(l);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger5, (String)"BigInteger.valueOf(this)");
        BigInteger bigInteger6 = bigInteger5;
        AionTransactionManager aionTransactionManager3 = aionTransactionManager;
        BigInteger bigInteger7 = bigInteger3;
        BigInteger bigInteger8 = bigInteger6;
        String string = to;
        String string2 = data;
        Long l3 = value;
        if (l3 != null) {
            l = l3;
            String string3 = string2;
            String string4 = string;
            bigInteger6 = bigInteger8;
            bigInteger3 = bigInteger7;
            aionTransactionManager = aionTransactionManager3;
            bl = false;
            BigInteger bigInteger9 = BigInteger.valueOf(l);
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger9, (String)"BigInteger.valueOf(this)");
            BigInteger bigInteger10 = bigInteger9;
            aionTransactionManager3 = aionTransactionManager;
            bigInteger7 = bigInteger3;
            bigInteger8 = bigInteger6;
            string = string4;
            string2 = string3;
            bigInteger = bigInteger10;
        } else {
            bigInteger = null;
        }
        return aionTransactionManager3.sendTransaction(bigInteger7, bigInteger8, string, string2, bigInteger, constructor);
    }

    public static /* synthetic */ EthSendTransaction sendTransaction$default(AionTransactionManager aionTransactionManager, Long l, long l2, String string, String string2, Long l3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        if ((n & 2) != 0) {
            l2 = 90000L;
        }
        if ((n & 0x10) != 0) {
            l3 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return aionTransactionManager.sendTransaction(l, l2, string, string2, l3, bl);
    }

    @NotNull
    public EthSendTransaction sendTransaction(@Nullable BigInteger gasPrice, @NotNull BigInteger gasLimit, @Nullable String to, @NotNull String data, @Nullable BigInteger value, boolean constructor) {
        String txHashRemote;
        String txHashLocal;
        Intrinsics.checkParameterIsNotNull((Object)gasLimit, (String)"gasLimit");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        boolean bl = constructor;
        long l = 0L;
        BigInteger bigInteger = gasLimit;
        BigInteger bigInteger2 = gasPrice;
        VirtualMachine virtualMachine = this.targetVm;
        BigInteger bigInteger3 = value;
        String string = data;
        String string2 = to;
        AionTransaction transaction = new AionTransaction(null, bigInteger2, bigInteger, string2, bigInteger3, string, bl, l, virtualMachine, 129, null);
        String rawTx = this.sign$web3j_aion_common(transaction);
        EthSendTransaction result = (EthSendTransaction)this.aion.ethSendRawTransaction(rawTx).send();
        if (result != null && !result.hasError() && Intrinsics.areEqual((Object)(txHashLocal = Numeric.toHexString((byte[])Hash.blake2b256((byte[])Numeric.hexStringToByteArray((String)rawTx)))), (Object)(txHashRemote = result.getTransactionHash())) ^ true) {
            throw (Throwable)new TxHashMismatchException(txHashLocal, txHashRemote);
        }
        EthSendTransaction ethSendTransaction = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)ethSendTransaction, (String)"result");
        return ethSendTransaction;
    }

    @NotNull
    public String sendCall(@NotNull String to, @NotNull String data, @NotNull DefaultBlockParameter defaultBlockParameter) {
        Transaction transaction;
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)defaultBlockParameter, (String)"defaultBlockParameter");
        Transaction transaction2 = transaction = Transaction.createEthCallTransaction((String)this.getFromAddress(), (String)to, (String)data);
        Intrinsics.checkExpressionValueIsNotNull((Object)transaction2, (String)"transaction");
        Response response = this.aion.ethCall(transaction2, defaultBlockParameter).send();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"aion.ethCall(transaction\u2026ultBlockParameter).send()");
        String string = ((EthCall)response).getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aion.ethCall(transaction\u2026ckParameter).send().value");
        return string;
    }

    @NotNull
    public final String sign$web3j_aion_common(@NotNull AionTransaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)transaction), (String)"transaction");
        byte[][] rlpTransaction = this.toRplElements(transaction);
        byte[] rplEncoded = RLP.encodeList((byte[][])((byte[][])Arrays.copyOf(rlpTransaction, rlpTransaction.length)));
        byte[] hash = Hash.blake2b256((byte[])rplEncoded);
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"hash");
        byte[] signature = this.keyPair.sign(hash);
        if (!this.keyPair.verify(hash, signature)) {
            String string = "Invalid signature";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] rlpSignature = RLP.encodeElement((byte[])ArraysKt.plus((byte[])this.keyPair.getPublicKey(), (byte[])signature));
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)rlpTransaction);
        spreadBuilder.add((Object)rlpSignature);
        byte[] encodedWithPayload = RLP.encodeList((byte[][])((byte[][])spreadBuilder.toArray((Object[])new byte[spreadBuilder.size()][])));
        String string = Numeric.toHexString((byte[])encodedWithPayload);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Numeric.toHexString(encodedWithPayload)");
        return string;
    }

    private final long getNrgPrice() {
        Response response = this.aion.ethGasPrice().send();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"aion.ethGasPrice().send()");
        return ((EthGasPrice)response).getGasPrice().longValueExact();
    }

    private final BigInteger getNonce() {
        Response response = this.aion.ethGetTransactionCount(this.keyPair.getAddress(), (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"aion.ethGetTransactionCo\u2026r.address, LATEST).send()");
        BigInteger bigInteger = ((EthGetTransactionCount)response).getTransactionCount();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"aion.ethGetTransactionCo\u2026).send().transactionCount");
        return bigInteger;
    }

    private final byte[][] toRplElements(@NotNull AionTransaction $this$toRplElements) {
        BigInteger bigInteger = $this$toRplElements.getNonce();
        if (bigInteger == null) {
            bigInteger = this.getNonce();
        }
        BigInteger nonce = bigInteger;
        BigInteger timestamp = BigInteger.valueOf($this$toRplElements.getTimestamp());
        Long l = $this$toRplElements.getNrgPrice();
        long nrgPrice = l != null ? l.longValue() : this.getNrgPrice();
        String data = Numeric.prependHexPrefix((String)$this$toRplElements.getData());
        BigInteger value = Intrinsics.areEqual((Object)$this$toRplElements.getValue(), (Object)BigInteger.ZERO) ? null : $this$toRplElements.getValue();
        byte type = $this$toRplElements.getTargetVm() == VirtualMachine.AVM && $this$toRplElements.getConstructor() ? (byte)2 : 1;
        byte[][] byArrayArray = new byte[8][];
        byte[] byArray = RLP.encodeElement((byte[])nonce.toByteArray());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"RLP.encodeElement(nonce.toByteArray())");
        byArrayArray[0] = byArray;
        byte[] byArray2 = RLP.encodeElement((byte[])AionTransactionManager.Companion.toByteArray($this$toRplElements.getTo()));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"RLP.encodeElement(to.toByteArray())");
        byArrayArray[1] = byArray2;
        BigInteger bigInteger2 = value;
        byte[] byArray3 = RLP.encodeElement((byte[])((byte[])(bigInteger2 != null ? bigInteger2.toByteArray() : null)));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"RLP.encodeElement(value?.toByteArray())");
        byArrayArray[2] = byArray3;
        byte[] byArray4 = RLP.encodeElement((byte[])AionTransactionManager.Companion.toByteArray(data));
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"RLP.encodeElement(data.toByteArray())");
        byArrayArray[3] = byArray4;
        byte[] byArray5 = RLP.encodeElement((byte[])timestamp.toByteArray());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray5, (String)"RLP.encodeElement(timestamp.toByteArray())");
        byArrayArray[4] = byArray5;
        byte[] byArray6 = RLP.encodeLong((long)$this$toRplElements.getNrg());
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray6, (String)"RLP.encodeLong(nrg)");
        byArrayArray[5] = byArray6;
        byte[] byArray7 = RLP.encodeLong((long)nrgPrice);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray7, (String)"RLP.encodeLong(nrgPrice)");
        byArrayArray[6] = byArray7;
        byte[] byArray8 = RLP.encodeByte((byte)type);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray8, (String)"RLP.encodeByte(type)");
        byArrayArray[7] = byArray8;
        return byArrayArray;
    }

    public AionTransactionManager(@NotNull Aion aion, @NotNull Ed25519KeyPair keyPair, @NotNull VirtualMachine targetVm, int attempts, long sleepDuration) {
        Intrinsics.checkParameterIsNotNull((Object)aion, (String)"aion");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)((Object)targetVm), (String)"targetVm");
        super((Web3j)aion, attempts, sleepDuration, keyPair.getAddress());
        this.aion = aion;
        this.keyPair = keyPair;
        this.targetVm = targetVm;
    }

    public /* synthetic */ AionTransactionManager(Aion aion, Ed25519KeyPair ed25519KeyPair, VirtualMachine virtualMachine, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            virtualMachine = VirtualMachine.AVM;
        }
        this(aion, ed25519KeyPair, virtualMachine, n, l);
    }

    public AionTransactionManager(@NotNull Aion aion, @NotNull Ed25519KeyPair keyPair, @NotNull VirtualMachine targetVm) {
        Intrinsics.checkParameterIsNotNull((Object)aion, (String)"aion");
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)((Object)targetVm), (String)"targetVm");
        this(aion, keyPair, targetVm, 40, 15000L);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/web3j/aion/tx/AionTransactionManager$Companion;", "", "()V", "TRANSACTION_TYPE_AVM_CONSTRUCTOR", "", "TRANSACTION_TYPE_OTHER", "toByteArray", "", "", "web3j-aion-common"})
    public static final class Companion {
        private final byte[] toByteArray(@Nullable String $this$toByteArray) {
            Object object;
            block3: {
                block2: {
                    object = $this$toByteArray;
                    if (object == null) break block2;
                    String string = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    String $this$run = string;
                    boolean bl3 = false;
                    String string2 = Numeric.cleanHexPrefix((String)$this$run);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Numeric.cleanHexPrefix(this)");
                    CharSequence charSequence = string2;
                    String string3 = "\\s";
                    boolean bl4 = false;
                    string3 = new Regex(string3);
                    String string4 = "";
                    boolean bl5 = false;
                    String cleanData = string3.replace(charSequence, string4);
                    byte[] biBytes = new BigInteger("10" + cleanData, 16).toByteArray();
                    byte[] byArray = Arrays.copyOfRange(biBytes, 1, biBytes.length);
                    object = byArray;
                    if (byArray != null) break block3;
                }
                object = new byte[0];
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

