/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen.kotlin;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.web3j.codegen.unit.gen.Parser;
import org.web3j.codegen.unit.gen.utils.MappingHelper;
import org.web3j.codegen.unit.gen.utils.NameUtils;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class KotlinParser
extends Parser {
    public KotlinParser(Class<?> theContract, Method method, MappingHelper mappingHelper) {
        super(theContract, method, mappingHelper);
    }

    public String generateAssertionKotlinPoetStringTypes() {
        Type returnType = this.getMethodReturnType();
        Object[] body = this.generatePlaceholderValues();
        StringBuilder symbolBuilder = new StringBuilder();
        symbolBuilder.append("%T.");
        if (returnType == TransactionReceipt.class) {
            symbolBuilder.append("assertTrue(%L.isStatusOK())");
        } else {
            symbolBuilder.append("assertEquals(");
            if (returnType.getTypeName().contains("Tuple")) {
                symbolBuilder.append(" %T(");
                for (Type t : this.getTypeArray(returnType)) {
                    symbolBuilder.append(this.mappingHelper.getPoetFormat().get(t)).append(", ");
                }
                symbolBuilder.deleteCharAt(symbolBuilder.lastIndexOf(", "));
                symbolBuilder.append(")");
            } else {
                symbolBuilder.append(this.mappingHelper.getPoetFormat().get(body[0]));
            }
            symbolBuilder.append(", ");
            symbolBuilder.append("%L");
            symbolBuilder.append(")");
        }
        return symbolBuilder.toString();
    }

    protected final Object[] adjustPlaceholderValues() {
        if (this.getMethodReturnType().equals(this.theContract)) {
            return this.mergePlaceholderValues(this.concludeMethodReturnType(), this.replaceTypeWithDefaultValue());
        }
        return this.mergePlaceholderValues(Arrays.copyOfRange(this.concludeMethodReturnType(), 1, this.concludeMethodReturnType().length), this.replaceTypeWithDefaultValue());
    }

    @Override
    protected String generatePoetStringTypes() {
        StringBuilder symbolBuilder = new StringBuilder();
        if (this.getMethodReturnType().equals(this.theContract)) {
            symbolBuilder.append(" %L = %T.");
        } else {
            symbolBuilder.append("val %L = %L.");
        }
        symbolBuilder.append(this.method.getName()).append("(").append(this.getPoetFormatSpecifier()).append(").send()");
        return symbolBuilder.toString();
    }

    @Override
    protected String getPoetFormatSpecifier() {
        ArrayList generated = new ArrayList();
        Arrays.asList(this.method.getParameterTypes()).forEach(type -> generated.add(this.mappingHelper.getPoetFormat().getOrDefault(type, "%L")));
        return String.join((CharSequence)", ", generated);
    }

    @Override
    protected Object getDefaultValueForType(Class<?> type) {
        if (this.mappingHelper.getDefaultValueMap().containsKey(type)) {
            return this.mappingHelper.getDefaultValueMap().get(type);
        }
        return NameUtils.toCamelCase(type);
    }
}

