/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.compat;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.Charset;

public final class Compat {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final int BYTES = 8;

    private Compat() {
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        if (elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(7 * elements.length);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter);
            sb.append(elements[i]);
        }
        return sb.toString();
    }

    public static long longValueExact(BigInteger value) {
        if (value.compareTo(LONG_MIN) >= 0 && value.compareTo(LONG_MAX) <= 0) {
            return value.longValue();
        }
        throw new ArithmeticException("BigInteger out of long range");
    }

    public static String getTypeName(Type type) {
        if (type instanceof Class) {
            return Compat.getClassName((Class)type);
        }
        return type.toString();
    }

    private static String getClassName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

