/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DLSequence;
import org.web3j.crypto.ECDSASignature;

public class CryptoUtils {
    public static byte[] toDerFormat(ECDSASignature signature) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)baos);
            seq.addObject((ASN1Primitive)new ASN1Integer(signature.r));
            seq.addObject((ASN1Primitive)new ASN1Integer(signature.s));
            seq.close();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return new byte[0];
            }
        }
        baos.close();
        return byArray;
    }

    public static ECDSASignature fromDerFormat(byte[] bytes) {
        ECDSASignature eCDSASignature;
        ASN1InputStream decoder = new ASN1InputStream(bytes);
        try {
            ASN1Integer s;
            ASN1Integer r;
            DLSequence seq = (DLSequence)decoder.readObject();
            if (seq == null) {
                throw new RuntimeException("Reached past end of ASN.1 stream.");
            }
            try {
                r = (ASN1Integer)seq.getObjectAt(0);
                s = (ASN1Integer)seq.getObjectAt(1);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e);
            }
            eCDSASignature = new ECDSASignature(r.getPositiveValue(), s.getPositiveValue());
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        decoder.close();
        return eCDSASignature;
    }
}

