/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;

public class StructuredData {

    public static class EIP712Message {
        private final HashMap<String, List<Entry>> types;
        private final String primaryType;
        private final Object message;
        private final EIP712Domain domain;

        @JsonCreator
        public EIP712Message(@JsonProperty(value="types") HashMap<String, List<Entry>> types, @JsonProperty(value="primaryType") String primaryType, @JsonProperty(value="message") Object message, @JsonProperty(value="domain") EIP712Domain domain) {
            this.types = types;
            this.primaryType = primaryType;
            this.message = message;
            this.domain = domain;
        }

        public HashMap<String, List<Entry>> getTypes() {
            return this.types;
        }

        public String getPrimaryType() {
            return this.primaryType;
        }

        public Object getMessage() {
            return this.message;
        }

        public EIP712Domain getDomain() {
            return this.domain;
        }

        public String toString() {
            return "EIP712Message{primaryType='" + this.primaryType + "', message='" + String.valueOf(this.message) + "'}";
        }
    }

    public static class EIP712Domain {
        private final String name;
        private final String version;
        private final String chainId;
        private final String verifyingContract;
        private final String salt;

        @JsonCreator
        public EIP712Domain(@JsonProperty(value="name") String name, @JsonProperty(value="version") String version, @JsonProperty(value="chainId") String chainId, @JsonProperty(value="verifyingContract") String verifyingContract, @JsonProperty(value="salt") String salt) {
            this.name = name;
            this.version = version;
            this.chainId = chainId;
            this.verifyingContract = verifyingContract;
            this.salt = salt;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getChainId() {
            return this.chainId;
        }

        public String getVerifyingContract() {
            return this.verifyingContract;
        }

        public String getSalt() {
            return this.salt;
        }
    }

    public static class Entry {
        private final String name;
        private final String type;

        @JsonCreator
        public Entry(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

