/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto.transaction.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.web3j.crypto.AccessListObject;
import org.web3j.crypto.AuthorizationTuple;
import org.web3j.crypto.Sign;
import org.web3j.crypto.transaction.type.ITransaction;
import org.web3j.crypto.transaction.type.Transaction1559;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;

public class Transaction7702
extends Transaction1559
implements ITransaction {
    private final List<AuthorizationTuple> authorizationList;

    protected Transaction7702(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, List<AccessListObject> accessList, List<AuthorizationTuple> authorizationList) {
        super(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas);
        this.authorizationList = authorizationList;
    }

    @Override
    public List<RlpType> asRlpValues(Sign.SignatureData signatureData) {
        ArrayList<RlpType> values = new ArrayList<RlpType>();
        values.add((RlpType)RlpString.create((long)this.getChainId()));
        values.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        values.add((RlpType)RlpString.create((BigInteger)this.getMaxPriorityFeePerGas()));
        values.add((RlpType)RlpString.create((BigInteger)this.getMaxFeePerGas()));
        values.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String to = this.getTo();
        if (to != null && !to.isEmpty()) {
            values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            values.add((RlpType)RlpString.create((String)""));
        }
        values.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] dataBytes = Numeric.hexStringToByteArray((String)this.getData());
        values.add((RlpType)RlpString.create((byte[])dataBytes));
        List<RlpType> accessListRlp = this.rlpAccessListRlp();
        values.add((RlpType)new RlpList(accessListRlp));
        List<RlpType> authorizationRlp = this.convertAuthorizationListToRlp(this.authorizationList);
        values.add((RlpType)new RlpList(authorizationRlp));
        if (signatureData != null) {
            int recId = Sign.getRecId(signatureData, this.getChainId());
            values.add((RlpType)RlpString.create((long)recId));
            values.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            values.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        return values;
    }

    private List<RlpType> convertAuthorizationListToRlp(List<AuthorizationTuple> authList) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        if (authList == null) {
            return result;
        }
        for (AuthorizationTuple at : authList) {
            ArrayList<RlpString> tuple = new ArrayList<RlpString>();
            tuple.add(RlpString.create((BigInteger)at.getChainId()));
            tuple.add(RlpString.create((byte[])Numeric.hexStringToByteArray((String)at.getAddress())));
            tuple.add(RlpString.create((BigInteger)at.getNonce()));
            tuple.add(RlpString.create((BigInteger)at.getYParity()));
            tuple.add(RlpString.create((BigInteger)at.getR()));
            tuple.add(RlpString.create((BigInteger)at.getS()));
            result.add((RlpType)new RlpList(tuple));
        }
        return result;
    }

    @Override
    public TransactionType getType() {
        return TransactionType.EIP7702;
    }

    public static Transaction7702 createTransaction(long chainId, BigInteger nonce, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, BigInteger value, String data, List<AccessListObject> accessList, List<AuthorizationTuple> authorizationList) {
        return new Transaction7702(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, value, data, accessList, authorizationList);
    }

    public List<AuthorizationTuple> getAuthorizationList() {
        return this.authorizationList;
    }
}

