/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class Base64String {
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private final byte[] enclaveB64Value;

    public static Base64String wrap(String base64String) {
        return new Base64String(base64String);
    }

    public static Base64String wrap(byte[] base64Array) {
        return new Base64String(ENCODER.encodeToString(base64Array));
    }

    public static List<Base64String> wrapList(List<String> base64Strings) {
        return base64Strings.stream().map(Base64String::wrap).collect(Collectors.toList());
    }

    public static List<Base64String> wrapList(String ... base64Strings) {
        return Arrays.stream(base64Strings).map(Base64String::wrap).collect(Collectors.toList());
    }

    public static List<String> unwrapList(List<Base64String> base64Strings) {
        return base64Strings.stream().map(Base64String::toString).collect(Collectors.toList());
    }

    public static RlpList unwrapListToRlp(List<Base64String> base64Strings) {
        return new RlpList(base64Strings.stream().map(Base64String::asRlp).collect(Collectors.toList()));
    }

    private Base64String(String base64String) {
        if (!this.isValid(base64String)) {
            throw new IllegalArgumentException(base64String + " is not a valid base 64 value");
        }
        this.enclaveB64Value = DECODER.decode(base64String);
    }

    public String toString() {
        return ENCODER.encodeToString(this.enclaveB64Value);
    }

    public byte[] raw() {
        return this.enclaveB64Value;
    }

    public RlpString asRlp() {
        return RlpString.create((byte[])this.raw());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Base64String that = (Base64String)o;
        return Arrays.equals(this.enclaveB64Value, that.enclaveB64Value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.enclaveB64Value);
    }

    private boolean isValid(String b64String) {
        return b64String.matches("(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)");
    }

    public static class Deserializer
    extends JsonDeserializer {
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Base64String.wrap(p.getText());
        }
    }

    public static class Serializer
    extends JsonSerializer {
        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

