/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.JsonRpc2_0Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.quorum.PrivacyFlag;
import org.web3j.quorum.Quorum;
import org.web3j.quorum.methods.request.PrivateRawTransaction;
import org.web3j.quorum.methods.request.PrivateTransaction;
import org.web3j.quorum.methods.response.ConsensusNoResponse;
import org.web3j.quorum.methods.response.ContractPrivacyMetadataInfo;
import org.web3j.quorum.methods.response.EthAddress;
import org.web3j.quorum.methods.response.EthGetQuorumTransactionReceipt;
import org.web3j.quorum.methods.response.PrivatePayload;
import org.web3j.quorum.methods.response.extension.ActiveExtensionList;
import org.web3j.quorum.methods.response.extension.ApproveExtensionInfo;
import org.web3j.quorum.methods.response.extension.CancelExtensionInfo;
import org.web3j.quorum.methods.response.extension.ExtendContractInfo;
import org.web3j.quorum.methods.response.extension.ExtensionApprovalUuid;
import org.web3j.quorum.methods.response.extension.ExtensionStatusInfo;
import org.web3j.quorum.methods.response.istanbul.IstanbulBlockSigners;
import org.web3j.quorum.methods.response.istanbul.IstanbulCandidates;
import org.web3j.quorum.methods.response.istanbul.IstanbulNodeAddress;
import org.web3j.quorum.methods.response.istanbul.IstanbulSnapshot;
import org.web3j.quorum.methods.response.istanbul.IstanbulValidators;
import org.web3j.quorum.methods.response.permissioning.ExecStatusInfo;
import org.web3j.quorum.methods.response.permissioning.OrgDetailsInfo;
import org.web3j.quorum.methods.response.permissioning.PermissionAccountList;
import org.web3j.quorum.methods.response.permissioning.PermissionNodeList;
import org.web3j.quorum.methods.response.permissioning.PermissionOrgList;
import org.web3j.quorum.methods.response.permissioning.PermissionRoleList;
import org.web3j.quorum.methods.response.raft.RaftCluster;
import org.web3j.quorum.methods.response.raft.RaftLeader;
import org.web3j.quorum.methods.response.raft.RaftPeerId;
import org.web3j.quorum.methods.response.raft.RaftPromote;
import org.web3j.quorum.methods.response.raft.RaftRole;

public class JsonRpc2_0Quorum
extends JsonRpc2_0Web3j
implements Quorum {
    public JsonRpc2_0Quorum(Web3jService web3jService) {
        super(web3jService);
    }

    public JsonRpc2_0Quorum(Web3jService web3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        super(web3jService, pollingInterval, scheduledExecutorService);
    }

    @Override
    public Request<?, EthSendTransaction> ethSendRawPrivateTransaction(String signedTransactionData, List<String> privateFor, PrivacyFlag privacyFlag, List<String> mandatoryFor) {
        PrivateRawTransaction transaction = new PrivateRawTransaction(privateFor, privacyFlag, mandatoryFor);
        return new Request("eth_sendRawPrivateTransaction", Arrays.asList(signedTransactionData, transaction), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethSendRawPrivateTransaction(String signedTransactionData, List<String> privateFor, PrivacyFlag privacyFlag) {
        PrivateRawTransaction transaction = new PrivateRawTransaction(privateFor, privacyFlag);
        return new Request("eth_sendRawPrivateTransaction", Arrays.asList(signedTransactionData, transaction), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethSendRawTransaction(String signedTransactionData) {
        return new Request("eth_sendRawTransaction", Collections.singletonList(signedTransactionData), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethSendTransaction(PrivateTransaction transaction) {
        return new Request("eth_sendTransaction", Collections.singletonList(transaction), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, PrivatePayload> quorumGetPrivatePayload(String hexDigest) {
        return new Request("eth_getQuorumPayload", Collections.singletonList(hexDigest), this.web3jService, PrivatePayload.class);
    }

    @Override
    public Request<?, ContractPrivacyMetadataInfo> quorumGetContractPrivacyMetadata(String hexDigest) {
        return new Request("eth_getContractPrivacyMetadata", Collections.singletonList(hexDigest), this.web3jService, ContractPrivacyMetadataInfo.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethSendTransactionAsync(PrivateTransaction transaction) {
        return new Request("eth_sendTransactionAsync", Collections.singletonList(transaction), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, EthGetQuorumTransactionReceipt> ethGetQuorumTransactionReceipt(String transactionHash) {
        return new Request("eth_getTransactionReceipt", Arrays.asList(transactionHash), this.web3jService, EthGetQuorumTransactionReceipt.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethDistributePrivateTransaction(String signedTransactionData, List<String> privateFor, PrivacyFlag privacyFlag, List<String> mandatoryFor) {
        PrivateRawTransaction transaction = new PrivateRawTransaction(privateFor, privacyFlag, mandatoryFor);
        return new Request("eth_distributePrivateTransaction", Arrays.asList(signedTransactionData, transaction), this.web3jService, EthSendTransaction.class);
    }

    @Override
    public Request<?, EthSendTransaction> ethDistributePrivateTransaction(String signedTransactionData, List<String> privateFor, PrivacyFlag privacyFlag) {
        return this.ethDistributePrivateTransaction(signedTransactionData, privateFor, privacyFlag, null);
    }

    @Override
    public Request<?, EthSendTransaction> ethDistributePrivateTransaction(String signedTransactionData, List<String> privateFor) {
        return this.ethDistributePrivateTransaction(signedTransactionData, privateFor, null, null);
    }

    @Override
    public Request<?, EthAddress> ethGetPrivacyPrecompileAddress() {
        return new Request("eth_getPrivacyPrecompileAddress", Arrays.asList(new Object[0]), this.web3jService, EthAddress.class);
    }

    @Override
    public Request<?, EthTransaction> ethGetPrivateTransactionByHash(String hexDigest) {
        return new Request("eth_getPrivateTransactionByHash", Collections.singletonList(hexDigest), this.web3jService, EthTransaction.class);
    }

    @Override
    public Request<?, EthGetTransactionReceipt> ethGetPrivateTransactionReceipt(String hexDigest) {
        return new Request("eth_getPrivateTransactionReceipt", Collections.singletonList(hexDigest), this.web3jService, EthGetTransactionReceipt.class);
    }

    @Override
    public Request<?, RaftLeader> raftGetLeader() {
        return new Request("raft_leader", Collections.emptyList(), this.web3jService, RaftLeader.class);
    }

    @Override
    public Request<?, RaftRole> raftGetRole() {
        return new Request("raft_role", Collections.emptyList(), this.web3jService, RaftRole.class);
    }

    @Override
    public Request<?, RaftPeerId> raftAddPeer(String enode) {
        return new Request("raft_addPeer", Collections.singletonList(enode), this.web3jService, RaftPeerId.class);
    }

    @Override
    public Request<?, ConsensusNoResponse> raftRemovePeer(int peerId) {
        return new Request("raft_removePeer", Collections.singletonList(peerId), this.web3jService, ConsensusNoResponse.class);
    }

    @Override
    public Request<?, RaftCluster> raftGetCluster() {
        return new Request("raft_cluster", Collections.emptyList(), this.web3jService, RaftCluster.class);
    }

    @Override
    public Request<?, RaftPeerId> raftAddLearner(String enode) {
        return new Request("raft_addLearner", Collections.singletonList(enode), this.web3jService, RaftPeerId.class);
    }

    @Override
    public Request<?, RaftPromote> raftPromoteToPeer(int raftId) {
        return new Request("raft_promoteToPeer", Collections.singletonList(raftId), this.web3jService, RaftPromote.class);
    }

    @Override
    public Request<?, IstanbulSnapshot> istanbulGetSnapshot(String blockNum) {
        return new Request("istanbul_getSnapshot", Collections.singletonList(blockNum), this.web3jService, IstanbulSnapshot.class);
    }

    @Override
    public Request<?, IstanbulSnapshot> istanbulGetSnapshotAtHash(String blockHash) {
        return new Request("istanbul_getSnapshotAtHash", Collections.singletonList(blockHash), this.web3jService, IstanbulSnapshot.class);
    }

    @Override
    public Request<?, IstanbulValidators> istanbulGetValidators(String blockNum) {
        return new Request("istanbul_getValidators", Collections.singletonList(blockNum), this.web3jService, IstanbulValidators.class);
    }

    @Override
    public Request<?, IstanbulValidators> istanbulGetValidatorsAtHash(String blockHash) {
        return new Request("istanbul_getValidatorsAtHash", Collections.singletonList(blockHash), this.web3jService, IstanbulValidators.class);
    }

    @Override
    public Request<?, ConsensusNoResponse> istanbulPropose(String address, boolean auth) {
        return new Request("istanbul_propose", Arrays.asList(address, auth), this.web3jService, ConsensusNoResponse.class);
    }

    @Override
    public Request<?, ConsensusNoResponse> istanbulDiscard(String address) {
        return new Request("istanbul_discard", Collections.singletonList(address), this.web3jService, ConsensusNoResponse.class);
    }

    @Override
    public Request<?, IstanbulCandidates> istanbulCandidates() {
        return new Request("istanbul_candidates", Collections.emptyList(), this.web3jService, IstanbulCandidates.class);
    }

    @Override
    public Request<?, IstanbulNodeAddress> istanbulNodeAddress() {
        return new Request("istanbul_nodeAddress", Collections.emptyList(), this.web3jService, IstanbulNodeAddress.class);
    }

    @Override
    public Request<?, IstanbulBlockSigners> istanbulGetSignersFromBlock(String blockNum) {
        return new Request("istanbul_getSignersFromBlock", Collections.singletonList(blockNum), this.web3jService, IstanbulBlockSigners.class);
    }

    @Override
    public Request<?, IstanbulBlockSigners> istanbulGetSignersFromBlockByHash(String blockHash) {
        return new Request("istanbul_getSignersFromBlockByHash", Collections.singletonList(blockHash), this.web3jService, IstanbulBlockSigners.class);
    }

    @Override
    public Request<?, PermissionOrgList> quorumPermissionGetOrgList() {
        return new Request("quorumPermission_orgList", Collections.emptyList(), this.web3jService, PermissionOrgList.class);
    }

    @Override
    public Request<?, PermissionNodeList> quorumPermissionGetNodeList() {
        return new Request("quorumPermission_nodeList", Collections.emptyList(), this.web3jService, PermissionNodeList.class);
    }

    @Override
    public Request<?, PermissionAccountList> quorumPermissionGetAccountList() {
        return new Request("quorumPermission_acctList", Collections.emptyList(), this.web3jService, PermissionAccountList.class);
    }

    @Override
    public Request<?, PermissionRoleList> quorumPermissionGetRoleList() {
        return new Request("quorumPermission_roleList", Collections.emptyList(), this.web3jService, PermissionRoleList.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionAddOrg(String orgId, String enodeId, String address, PrivateTransaction transaction) {
        return new Request("quorumPermission_addOrg", Arrays.asList(new Object[]{orgId, enodeId, address, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionApproveOrg(String orgId, String enodeId, String address, PrivateTransaction transaction) {
        return new Request("quorumPermission_approveOrg", Arrays.asList(new Object[]{orgId, enodeId, address, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionAddSubOrg(String pOrgId, String orgId, String enodeId, PrivateTransaction transaction) {
        return new Request("quorumPermission_addSubOrg", Arrays.asList(new Object[]{pOrgId, orgId, enodeId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionUpdateOrgStatus(String orgId, int action, PrivateTransaction transaction) {
        return new Request("quorumPermission_updateOrgStatus", Arrays.asList(new Object[]{orgId, action, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionApproveOrgStatus(String orgId, int action, PrivateTransaction transaction) {
        return new Request("quorumPermission_approveOrgStatus", Arrays.asList(new Object[]{orgId, action, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionAddNode(String orgId, String enodeId, PrivateTransaction transaction) {
        return new Request("quorumPermission_addNode", Arrays.asList(new Object[]{orgId, enodeId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionUpdateNodeStatus(String orgId, String enodeId, int action, PrivateTransaction transaction) {
        return new Request("quorumPermission_updateNodeStatus", Arrays.asList(new Object[]{orgId, enodeId, action, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionAssignAdminRole(String orgId, String address, String roleId, PrivateTransaction transaction) {
        return new Request("quorumPermission_assignAdminRole", Arrays.asList(new Object[]{orgId, address, roleId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionApproveAdminRole(String orgId, String address, PrivateTransaction transaction) {
        return new Request("quorumPermission_approveAdminRole", Arrays.asList(new Object[]{orgId, address, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionAddNewRole(String orgId, String roleId, int access, boolean isVoter, boolean isAdmin, PrivateTransaction transaction) {
        return new Request("quorumPermission_addNewRole", Arrays.asList(new Object[]{orgId, roleId, access, isVoter, isAdmin, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionRemoveRole(String orgId, String roleId, PrivateTransaction transaction) {
        return new Request("quorumPermission_removeRole", Arrays.asList(new Object[]{orgId, roleId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionAddAccountToOrg(String address, String orgId, String roleId, PrivateTransaction transaction) {
        return new Request("quorumPermission_addAccountToOrg", Arrays.asList(new Object[]{address, orgId, roleId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionChangeAccountRole(String address, String orgId, String roleId, PrivateTransaction transaction) {
        return new Request("quorumPermission_changeAccountRole", Arrays.asList(new Object[]{address, orgId, roleId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionUpdateAccountStatus(String orgId, String address, int status, PrivateTransaction transaction) {
        return new Request("quorumPermission_updateAccountStatus", Arrays.asList(new Object[]{orgId, address, status, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, OrgDetailsInfo> quorumPermissionGetOrgDetails(String orgId) {
        return new Request("quorumPermission_getOrgDetails", Collections.singletonList(orgId), this.web3jService, OrgDetailsInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionRecoverBlackListedNode(String orgId, String enodeId, PrivateTransaction transaction) {
        return new Request("quorumPermission_recoverBlackListedNode", Arrays.asList(new Object[]{orgId, enodeId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionApproveBlackListedNodeRecovery(String orgId, String enodeId, PrivateTransaction transaction) {
        return new Request("quorumPermission_approveBlackListedNodeRecovery", Arrays.asList(new Object[]{orgId, enodeId, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionRecoverBlackListedAccount(String orgId, String address, PrivateTransaction transaction) {
        return new Request("quorumPermission_recoverBlackListedAccount", Arrays.asList(new Object[]{orgId, address, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ExecStatusInfo> quorumPermissionApproveBlackListedAccountRecovery(String orgId, String address, PrivateTransaction transaction) {
        return new Request("quorumPermission_approveBlackListedAccountRecovery", Arrays.asList(new Object[]{orgId, address, transaction}), this.web3jService, ExecStatusInfo.class);
    }

    @Override
    public Request<?, ActiveExtensionList> quorumExtensionActiveExtensionContracts() {
        return new Request("quorumExtension_activeExtensionContracts", Collections.emptyList(), this.web3jService, ActiveExtensionList.class);
    }

    @Override
    public Request<?, ApproveExtensionInfo> quorumExtensionApproveExtension(String addressToVoteOn, boolean vote, PrivateTransaction transaction) {
        return new Request("quorumExtension_approveExtension", Arrays.asList(new Object[]{addressToVoteOn, vote, transaction}), this.web3jService, ApproveExtensionInfo.class);
    }

    @Override
    public Request<?, CancelExtensionInfo> quorumExtensionCancelExtension(String extensionContract, PrivateTransaction transaction) {
        return new Request("quorumExtension_cancelExtension", Arrays.asList(new Object[]{extensionContract, transaction}), this.web3jService, CancelExtensionInfo.class);
    }

    @Override
    public Request<?, ExtendContractInfo> quorumExtensionExtendContract(String toExtend, String newRecipientPtmPublicKey, String recipientAddress, PrivateTransaction transaction) {
        return new Request("quorumExtension_extendContract", Arrays.asList(new Object[]{toExtend, newRecipientPtmPublicKey, recipientAddress, transaction}), this.web3jService, ExtendContractInfo.class);
    }

    @Override
    public Request<?, ExtensionStatusInfo> quorumExtensionGetExtensionStatus(String managementContractAddress) {
        return new Request("quorumExtension_getExtensionStatus", Arrays.asList(managementContractAddress), this.web3jService, ExtensionStatusInfo.class);
    }

    @Override
    public Request<?, ExtensionApprovalUuid> quorumExtensionGenerateExtensionApprovalUuid(String addressToVoteOn, String externalSignerAddress, PrivateTransaction transaction) {
        return new Request("quorumExtension_generateExtensionApprovalUuid", Arrays.asList(new Object[]{addressToVoteOn, externalSignerAddress, transaction}), this.web3jService, ExtensionApprovalUuid.class);
    }
}

