/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.methods.request;

import java.math.BigInteger;
import java.util.List;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.quorum.PrivacyFlag;

public class PrivateTransaction
extends Transaction {
    private String privateFrom;
    private List<String> privateFor;
    private PrivacyFlag privacyFlag;
    private List<String> mandatoryFor;

    public PrivateTransaction(String from, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, String privateFrom, List<String> privateFor) {
        this(from, nonce, gasLimit, to, value, data, privateFrom, privateFor, null, null);
    }

    public PrivateTransaction(String from, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, String privateFrom, List<String> privateFor, PrivacyFlag privacyFlag) {
        this(from, nonce, gasLimit, to, value, data, privateFrom, privateFor, privacyFlag, null);
    }

    public PrivateTransaction(String from, BigInteger nonce, BigInteger gasLimit, String to, BigInteger value, String data, String privateFrom, List<String> privateFor, PrivacyFlag privacyFlag, List<String> mandatoryFor) {
        super(from, nonce, null, gasLimit, to, value, data);
        this.privateFrom = privateFrom;
        this.privateFor = privateFor;
        this.privacyFlag = privacyFlag;
        this.mandatoryFor = mandatoryFor;
    }

    public String getPrivateFrom() {
        return this.privateFrom;
    }

    public void setPrivateFrom(String privateFrom) {
        this.privateFrom = privateFrom;
    }

    public List<String> getPrivateFor() {
        return this.privateFor;
    }

    public void setPrivateFor(List<String> privateFor) {
        this.privateFor = privateFor;
    }

    public int getPrivacyFlag() {
        if (this.privacyFlag != null) {
            return this.privacyFlag.getValue();
        }
        return PrivacyFlag.STANDARD_PRIVATE.getValue();
    }

    public void setPrivacyFlag(PrivacyFlag privacyFlag) {
        this.privacyFlag = privacyFlag;
    }

    public List<String> getMandatoryFor() {
        return this.mandatoryFor;
    }

    public void setMandatoryFor(List<String> mandatoryFor) {
        this.mandatoryFor = mandatoryFor;
    }
}

