/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.tx;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.quorum.PrivacyFlag;
import org.web3j.quorum.Quorum;
import org.web3j.quorum.methods.request.PrivateTransaction;
import org.web3j.quorum.methods.response.QuorumTransactionReceipt;
import org.web3j.quorum.tx.response.QuorumPollingTransactionReceiptProcessor;
import org.web3j.tx.ContractErrorUtil;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.response.TransactionReceiptProcessor;

public class ClientTransactionManager
extends TransactionManager {
    static final int SLEEP_DURATION = 1000;
    static final int ATTEMPTS = 20;
    private final Quorum quorum;
    private final String fromAddress;
    private final String privateFrom;
    private List<String> privateFor;
    private PrivacyFlag privacyFlag;
    private List<String> mandatoryFor;

    public ClientTransactionManager(Quorum quorum, String fromAddress, String privateFrom, List<String> privateFor, PrivacyFlag privacyFlag, List<String> mandatoryFor, int attempts, int sleepDuration) {
        super((TransactionReceiptProcessor)new QuorumPollingTransactionReceiptProcessor(quorum, sleepDuration, attempts), fromAddress);
        this.quorum = quorum;
        this.fromAddress = fromAddress;
        this.privateFrom = privateFrom;
        this.privateFor = privateFor;
        this.privacyFlag = privacyFlag;
        this.mandatoryFor = mandatoryFor;
    }

    public ClientTransactionManager(Quorum quorum, String fromAddress, String privateFrom, List<String> privateFor, PrivacyFlag privacyFlag, int attempts, int sleepDuration) {
        this(quorum, fromAddress, privateFrom, privateFor, privacyFlag, null, attempts, sleepDuration);
    }

    public ClientTransactionManager(Quorum quorum, String fromAddress, String privateFrom, List<String> privateFor, PrivacyFlag privacyFlag) {
        this(quorum, fromAddress, privateFrom, privateFor, privacyFlag, null, 20, 1000);
    }

    public ClientTransactionManager(Quorum quorum, String fromAddress, String privateFrom, List<String> privateFor, PrivacyFlag privacyFlag, List<String> mandatoryFor) {
        this(quorum, fromAddress, privateFrom, privateFor, privacyFlag, mandatoryFor, 20, 1000);
    }

    public ClientTransactionManager(Quorum quorum, String fromAddress, String privateFrom, List<String> privateFor, int attempts, int sleepDuration) {
        this(quorum, fromAddress, privateFrom, privateFor, null, null, attempts, sleepDuration);
    }

    public ClientTransactionManager(Quorum quorum, String fromAddress, String privateFrom, List<String> privateFor) {
        this(quorum, fromAddress, privateFrom, privateFor, 20, 1000);
    }

    @Deprecated
    public ClientTransactionManager(Quorum quorum, String fromAddress, List<String> privateFor, int attempts, int sleepDuration) {
        this(quorum, fromAddress, null, privateFor, attempts, sleepDuration);
    }

    @Deprecated
    public ClientTransactionManager(Quorum quorum, String fromAddress, List<String> privateFor) {
        this(quorum, fromAddress, null, privateFor);
    }

    public String getPrivateFrom() {
        return this.privateFrom;
    }

    public List<String> getPrivateFor() {
        return this.privateFor;
    }

    public void setPrivateFor(List<String> privateFor) {
        this.privateFor = privateFor;
    }

    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value) throws IOException {
        PrivateTransaction transaction = new PrivateTransaction(this.fromAddress, null, gasLimit, to, value, data, this.privateFrom, this.privateFor, this.privacyFlag, this.mandatoryFor);
        return (EthSendTransaction)this.quorum.ethSendTransaction(transaction).send();
    }

    public EthSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        return this.sendTransaction(gasPrice, gasLimit, to, data, value);
    }

    public EthSendTransaction sendEIP1559Transaction(long chainId, BigInteger maxPriorityFeePerGas, BigInteger maxFeePerGas, BigInteger gasLimit, String to, String data, BigInteger value, boolean constructor) throws IOException {
        throw new UnsupportedOperationException("sendTransactionEIP1559 is not available");
    }

    public String sendCall(String to, String data, DefaultBlockParameter defaultBlockParameter) throws IOException {
        EthCall ethCall = (EthCall)this.quorum.ethCall(Transaction.createEthCallTransaction((String)this.getFromAddress(), (String)to, (String)data), defaultBlockParameter).send();
        ContractErrorUtil.assertCallNotReverted(ethCall);
        return ethCall.getValue();
    }

    public EthGetCode getCode(String contractAddress, DefaultBlockParameter defaultBlockParameter) throws IOException {
        return (EthGetCode)this.quorum.ethGetCode(contractAddress, defaultBlockParameter).send();
    }

    protected TransactionReceipt processResponse(EthSendTransaction transactionResponse) throws IOException, TransactionException {
        QuorumTransactionReceipt quorumTransactionReceipt;
        TransactionReceipt transactionReceipt = super.processResponse(transactionResponse);
        if (transactionReceipt instanceof QuorumTransactionReceipt && (quorumTransactionReceipt = (QuorumTransactionReceipt)transactionReceipt).isPrivacyMarkerTransaction()) {
            String transactionHash = transactionResponse.getTransactionHash();
            EthGetTransactionReceipt privateTransactionReceipt = (EthGetTransactionReceipt)this.quorum.ethGetPrivateTransactionReceipt(transactionHash).send();
            return (TransactionReceipt)privateTransactionReceipt.getTransactionReceipt().get();
        }
        return transactionReceipt;
    }
}

