/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.quorum.tx.response;

import java.io.IOException;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.quorum.Quorum;
import org.web3j.quorum.methods.response.EthGetQuorumTransactionReceipt;
import org.web3j.quorum.methods.response.QuorumTransactionReceipt;
import org.web3j.tx.response.PollingTransactionReceiptProcessor;

public class QuorumPollingTransactionReceiptProcessor
extends PollingTransactionReceiptProcessor {
    private final Quorum quorum;

    public QuorumPollingTransactionReceiptProcessor(Quorum quorum, long sleepDuration, int attempts) {
        super((Web3j)quorum, sleepDuration, attempts);
        this.quorum = quorum;
    }

    public TransactionReceipt waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        return this.getQuorumTransactionReceipt(transactionHash, this.sleepDuration, this.attempts);
    }

    private QuorumTransactionReceipt getQuorumTransactionReceipt(String transactionHash, long sleepDuration, int attempts) throws IOException, TransactionException {
        Optional<? extends QuorumTransactionReceipt> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts; ++i) {
            if (!receiptOptional.isPresent()) {
                try {
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw new TransactionException((Throwable)e);
                }
            } else {
                return receiptOptional.get();
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        throw new TransactionException("Transaction receipt was not generated after " + sleepDuration * (long)attempts / 1000L + " seconds for transaction: " + transactionHash, transactionHash);
    }

    Optional<? extends QuorumTransactionReceipt> sendTransactionReceiptRequest(String transactionHash) throws IOException, TransactionException {
        EthGetQuorumTransactionReceipt transactionReceipt = (EthGetQuorumTransactionReceipt)this.quorum.ethGetQuorumTransactionReceipt(transactionHash).send();
        if (transactionReceipt.hasError()) {
            throw new TransactionException("Error processing request: " + transactionReceipt.getError().getMessage());
        }
        return transactionReceipt.getTransactionReceipt();
    }
}

