/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.evm.ConsoleDebugTracer;
import org.web3j.evm.ExceptionalHaltException;
import org.web3j.evm.entity.ContractMapping;
import org.web3j.evm.entity.source.SourceFile;
import org.web3j.evm.entity.source.SourceLine;
import org.web3j.evm.entity.source.SourceMapElement;
import org.web3j.evm.utils.SourceMappingUtils;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 A2\u00020\u0001:\u0002ABB\u001d\b\u0017\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002J \u0010*\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0-H\u0002J\"\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0/2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020201H\u0004J\u001a\u00103\u001a\u00020\f2\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u00020\u0012H\u0002J\u0010\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020\fH\u0002J\u0010\u00109\u001a\u00020'2\u0006\u00108\u001a\u00020\fH\u0002J\u0010\u0010:\u001a\u00020'2\u0006\u00108\u001a\u00020\fH\u0002J\b\u0010;\u001a\u00020'H\u0002J\u001e\u0010<\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00180\u00112\u0006\u00104\u001a\u000205H\u0004J\u001a\u0010=\u001a\u00020'2\u0006\u00104\u001a\u0002052\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020'2\u0006\u00104\u001a\u000205H\u0016R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u000f\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u00130\u0010j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\f0\u001ej\b\u0012\u0004\u0012\u00020\f`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/web3j/evm/ConsoleDebugTracer;", "Lorg/hyperledger/besu/evm/tracing/OperationTracer;", "metaFile", "Ljava/io/File;", "stdin", "Ljava/io/InputStream;", "(Ljava/io/File;Ljava/io/InputStream;)V", "reader", "Ljava/io/BufferedReader;", "(Ljava/io/File;Ljava/io/BufferedReader;)V", "breakPoints", "", "", "", "", "byteCodeContractMapping", "Ljava/util/HashMap;", "Lkotlin/Pair;", "", "Lorg/web3j/evm/entity/ContractMapping;", "Lkotlin/collections/HashMap;", "commandOutputs", "", "lastSourceFile", "Lorg/web3j/evm/entity/source/SourceFile;", "lastSourceMapElement", "Lorg/web3j/evm/entity/source/SourceMapElement;", "getMetaFile", "()Ljava/io/File;", "operations", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "output", "runTillEnd", "showOpcodes", "showStack", "skipOperations", "Ljava/util/concurrent/atomic/AtomicInteger;", "addHelp", "", "command", "desc", "isBreakPointActive", "filePath", "activeLines", "", "mergeSourceContent", "", "sourceContent", "Ljava/util/SortedMap;", "Lorg/web3j/evm/entity/source/SourceLine;", "nextOption", "messageFrame", "Lorg/hyperledger/besu/evm/frame/MessageFrame;", "rerender", "parseBreakPointOption", "input", "parseHideOption", "parseShowOption", "showHelp", "sourceAtMessageFrame", "tracePostExecution", "result", "Lorg/hyperledger/besu/evm/operation/Operation$OperationResult;", "tracePreExecution", "Companion", "TERMINAL", "web3j-evm"})
@SourceDebugExtension(value={"SMAP\nConsoleDebugTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleDebugTracer.kt\norg/web3j/evm/ConsoleDebugTracer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,455:1\n1549#2:456\n1620#2,3:457\n766#2:460\n857#2,2:461\n1360#2:463\n1446#2,5:464\n1747#2,3:469\n1045#2:472\n2624#2,3:473\n766#2:476\n857#2,2:477\n1045#2:479\n766#2:487\n857#2,2:488\n1549#2:490\n1620#2,3:491\n748#2,10:494\n748#2,10:504\n1855#2,2:514\n766#2:516\n857#2,2:517\n1549#2:519\n1620#2,3:520\n1747#2,3:523\n1855#2,2:526\n1747#2,3:528\n372#3,7:480\n*S KotlinDebug\n*F\n+ 1 ConsoleDebugTracer.kt\norg/web3j/evm/ConsoleDebugTracer\n*L\n89#1:456\n89#1:457,3\n104#1:460\n104#1:461,2\n105#1:463\n105#1:464,5\n110#1:469,3\n119#1:472\n123#1:473,3\n126#1:476\n126#1:477,2\n126#1:479\n282#1:487\n282#1:488,2\n282#1:490\n282#1:491,3\n305#1:494,10\n307#1:504,10\n310#1:514,2\n320#1:516\n320#1:517,2\n321#1:519\n321#1:520,3\n331#1:523,3\n370#1:526,2\n386#1:528,3\n137#1:480,7\n*E\n"})
public class ConsoleDebugTracer
implements OperationTracer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File metaFile;
    @NotNull
    private final BufferedReader reader;
    @NotNull
    private final ArrayList<String> operations;
    @NotNull
    private final AtomicInteger skipOperations;
    @NotNull
    private final Map<String, Set<Integer>> breakPoints;
    @NotNull
    private final List<String> commandOutputs;
    @NotNull
    private final HashMap<Pair<String, Boolean>, ContractMapping> byteCodeContractMapping;
    private String output;
    private boolean runTillEnd;
    private boolean showOpcodes;
    private boolean showStack;
    @NotNull
    private SourceFile lastSourceFile;
    @Nullable
    private SourceMapElement lastSourceMapElement;
    private static final int MAX_STACK_ITEM_LENGTH = 64;
    private static final int OP_CODES_WIDTH = 30;
    private static final int FULL_WIDTH = 107;
    @NotNull
    private static final String NUMBER_FORMAT = "0x%08x";
    @NotNull
    private static final String STACK_HEADER = TERMINAL.ANSI_GREEN + "-- Stack ";

    public ConsoleDebugTracer(@Nullable File metaFile, @NotNull BufferedReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.metaFile = metaFile;
        this.reader = reader;
        this.operations = new ArrayList();
        this.skipOperations = new AtomicInteger();
        this.breakPoints = new LinkedHashMap();
        this.commandOutputs = new ArrayList();
        this.byteCodeContractMapping = new HashMap();
        this.showOpcodes = true;
        this.showStack = true;
        this.lastSourceFile = new SourceFile(null, null, 3, null);
    }

    @Nullable
    protected final File getMetaFile() {
        return this.metaFile;
    }

    @JvmOverloads
    public ConsoleDebugTracer(@Nullable File metaFile, @NotNull InputStream stdin) {
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        this(metaFile, new BufferedReader(new InputStreamReader(stdin)));
    }

    public /* synthetic */ ConsoleDebugTracer(File file, InputStream inputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = new File("build/resources/main/solidity");
        }
        if ((n & 2) != 0) {
            InputStream inputStream2 = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"in");
            inputStream = inputStream2;
        }
        this(file, inputStream);
    }

    @NotNull
    protected final Pair<SourceMapElement, SourceFile> sourceAtMessageFrame(@NotNull MessageFrame messageFrame) {
        Intrinsics.checkNotNullParameter((Object)messageFrame, (String)"messageFrame");
        Function2 sourceFileBodyTransform2 = sourceAtMessageFrame.sourceFileBodyTransform.1.INSTANCE;
        return SourceMappingUtils.INSTANCE.sourceAtMessageFrame(messageFrame, this.metaFile, this.lastSourceFile, this.byteCodeContractMapping, (Function2<? super Integer, ? super String, Pair<Integer, String>>)sourceFileBodyTransform2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<String> mergeSourceContent(@NotNull SortedMap<Integer, SourceLine> sourceContent) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sourceContent, (String)"sourceContent");
        Set<Map.Entry<Integer, SourceLine>> set = sourceContent.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            if (((Number)k).intValue() > 0) {
                String lineNumberSpacing;
                String lineNumber;
                String string = "%" + String.valueOf(sourceContent.lastKey()).length() + "s";
                Object object2 = new Object[]{String.valueOf(it.getKey())};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(object2, ((Object[])object2).length)), (String)"format(...)");
                object2 = "%-4s";
                Object[] objectArray = new Object[]{lineNumber};
                Intrinsics.checkNotNullExpressionValue((Object)String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                object = lineNumberSpacing + " " + ((SourceLine)it.getValue()).getLine();
            } else {
                object = ((SourceLine)it.getValue()).getLine();
            }
            collection.add(object);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isBreakPointActive(String filePath, Set<Integer> activeLines) {
        boolean bl;
        block7: {
            Collection destination$iv$iv;
            if (filePath != null) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Map.Entry it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = this.breakPoints.entrySet();
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)filePath, (String)((String)it.getKey()), (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$filterTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (Map.Entry)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = (Set)it.getValue();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
            } else {
                return false;
            }
            List relevantBreakPoints = (List)destination$iv$iv;
            Iterable $this$any$iv = activeLines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl4 = false;
                    if (!relevantBreakPoints.contains(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseBreakPointOption(String input) {
        Regex regex = new Regex(" +");
        CharSequence charSequence = input;
        int n = 0;
        List inputParts = regex.split(charSequence, n);
        if (inputParts.size() < 2) {
            return;
        }
        String string = ((String)inputParts.get(1)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        charSequence = string;
        if (Intrinsics.areEqual((Object)charSequence, (Object)"clear")) {
            $this$sortedBy$iv = this.breakPoints.entrySet();
            $i$f$sortedBy = false;
            this.commandOutputs.add(TERMINAL.ANSI_CYAN + "Cleared " + this.breakPoints.size() + " breakpoints: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            }), null, null, null, (int)0, null, (Function1)parseBreakPointOption.2.INSTANCE, (int)31, null) + TERMINAL.ANSI_RESET);
            this.breakPoints.clear();
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"list")) {
            boolean bl;
            Iterable $this$none$iv;
            block17: {
                $this$none$iv = this.breakPoints.values();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Set it = (Set)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = !((Collection)it).isEmpty();
                        if (!bl3) continue;
                        bl = false;
                        break block17;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.commandOutputs.add(TERMINAL.ANSI_CYAN + "No active breakpoints" + TERMINAL.ANSI_RESET);
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$none$iv = this.breakPoints.entrySet();
                TERMINAL tERMINAL = TERMINAL.ANSI_CYAN;
                List<String> list = this.commandOutputs;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl4 = false;
                    boolean bl5 = !((Collection)it.getValue()).isEmpty();
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                $this$filter$iv = list2;
                $i$f$sortedBy = false;
                list.add(tERMINAL + "Active breakpoints: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                }), null, null, null, (int)0, null, (Function1)parseBreakPointOption.6.INSTANCE, (int)31, null) + TERMINAL.ANSI_RESET);
            }
        } else {
            if (inputParts.size() != 3) {
                return;
            }
            String file = (String)inputParts.get(1);
            int line = Integer.parseInt((String)inputParts.get(2));
            Set<Integer> set = this.breakPoints.get(file);
            boolean bl = set != null ? set.contains(line) : false;
            if (bl) {
                Set<Integer> set2 = this.breakPoints.get(file);
                if (set2 != null) {
                    set2.remove(line);
                }
                this.commandOutputs.add(TERMINAL.ANSI_CYAN + "Removed breakpoint on " + file + ":" + line + TERMINAL.ANSI_RESET);
            } else {
                Set set3;
                Map<String, Set<Integer>> $this$getOrPut$iv = this.breakPoints;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(file);
                if (value$iv == null) {
                    boolean bl6 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(file, answer$iv);
                    set3 = answer$iv;
                } else {
                    set3 = value$iv;
                }
                set3.add(line);
                this.commandOutputs.add(TERMINAL.ANSI_CYAN + "Added breakpoint on " + file + ":" + line + TERMINAL.ANSI_RESET);
            }
        }
    }

    private final void parseShowOption(String input) {
        Regex regex = new Regex(" +");
        CharSequence charSequence = input;
        int n = 0;
        List inputParts = regex.split(charSequence, n);
        if (inputParts.size() < 2) {
            return;
        }
        String string = ((String)inputParts.get(1)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        charSequence = string;
        if (Intrinsics.areEqual((Object)charSequence, (Object)"opcodes")) {
            this.showOpcodes = true;
            this.commandOutputs.add(TERMINAL.ANSI_CYAN + "Showing opcodes" + TERMINAL.ANSI_RESET);
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"stack")) {
            this.showStack = true;
            this.commandOutputs.add(TERMINAL.ANSI_CYAN + "Showing stack" + TERMINAL.ANSI_RESET);
        }
    }

    private final void parseHideOption(String input) {
        Regex regex = new Regex(" +");
        CharSequence charSequence = input;
        int n = 0;
        List inputParts = regex.split(charSequence, n);
        if (inputParts.size() < 2) {
            return;
        }
        String string = ((String)inputParts.get(1)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        charSequence = string;
        if (Intrinsics.areEqual((Object)charSequence, (Object)"opcodes")) {
            this.showOpcodes = false;
            this.commandOutputs.add(TERMINAL.ANSI_CYAN + "Hiding opcodes" + TERMINAL.ANSI_RESET);
        } else if (Intrinsics.areEqual((Object)charSequence, (Object)"stack")) {
            this.showStack = false;
            this.commandOutputs.add(TERMINAL.ANSI_CYAN + "Hiding stack" + TERMINAL.ANSI_RESET);
        }
    }

    private final void addHelp(String command, String desc) {
        this.commandOutputs.add(command + StringsKt.repeat((CharSequence)" ", (int)(40 - ConsoleDebugTracer.Companion.cleanString(command).length())) + desc);
    }

    private final void showHelp() {
        this.addHelp(TERMINAL.ANSI_YELLOW + "[enter]" + TERMINAL.ANSI_RESET, "Continue running until next code section");
        this.addHelp(TERMINAL.ANSI_YELLOW + "[number]" + TERMINAL.ANSI_RESET, "Step forward X number of opcodes");
        this.addHelp(TERMINAL.ANSI_YELLOW + "next" + TERMINAL.ANSI_RESET, "Run until the next breakpoint");
        this.addHelp(TERMINAL.ANSI_YELLOW + "end" + TERMINAL.ANSI_RESET, "Run until the end of current transaction");
        this.addHelp(TERMINAL.ANSI_RED + "abort" + TERMINAL.ANSI_RESET, "Terminate the function call");
        this.commandOutputs.add("");
        this.addHelp(TERMINAL.ANSI_YELLOW + "show|hide opcodes" + TERMINAL.ANSI_RESET, "Show or hide opcodes");
        this.addHelp(TERMINAL.ANSI_YELLOW + "show|hide stack" + TERMINAL.ANSI_RESET, "Show or hide the stack");
        this.commandOutputs.add("");
        this.addHelp(TERMINAL.ANSI_YELLOW + "break [file name] [line number]" + TERMINAL.ANSI_RESET, "Add or remove a breakpoint");
        this.addHelp(TERMINAL.ANSI_YELLOW + "break list" + TERMINAL.ANSI_RESET, "Show all breakpoint");
        this.addHelp(TERMINAL.ANSI_YELLOW + "break clear" + TERMINAL.ANSI_RESET, "Remove all breakpoint");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String nextOption(MessageFrame messageFrame, boolean rerender) throws ExceptionalHaltException {
        boolean bl;
        block57: {
            Iterator iterator;
            Object element$iv;
            block58: {
                Object object;
                String opCount;
                boolean pauseOnNext;
                SourceMapElement sourceMapElement;
                StringBuilder sb;
                block62: {
                    boolean bl2;
                    block56: {
                        Iterator iterator22;
                        block61: {
                            block59: {
                                Iterable $this$any$iv;
                                block60: {
                                    void $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    Map.Entry it;
                                    void $this$filterTo$iv$iv;
                                    Iterable $this$filter$iv;
                                    Object element$iv22;
                                    Object it2;
                                    int i;
                                    Object[] objectArray;
                                    ArrayList<CallSite> stackOutput = new ArrayList<CallSite>();
                                    int n = messageFrame.stackSize();
                                    for (int i2 = 0; i2 < n; ++i2) {
                                        objectArray = "0x%08x";
                                        Object[] objectArray2 = new Object[]{i2};
                                        String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                                        stackOutput.add((CallSite)((Object)(string + " " + Numeric.toHexStringWithPrefixZeroPadded((BigInteger)messageFrame.getStackItem(i2).toUnsignedBigInteger(), (int)64))));
                                    }
                                    sb = new StringBuilder();
                                    if (!((Collection)this.operations).isEmpty()) {
                                        sb.append((Object)TERMINAL.CLEAR);
                                    }
                                    if (!rerender) {
                                        String string = NUMBER_FORMAT;
                                        objectArray = new Object[]{messageFrame.getPC()};
                                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                                        this.operations.add(string2 + " " + messageFrame.getCurrentOperation().getName());
                                    }
                                    int n2 = this.operations.size();
                                    for (i = 0; i < n2; ++i) {
                                        boolean haveActiveStackOutput;
                                        boolean haveActiveLastOpLine;
                                        boolean bl3 = haveActiveLastOpLine = i + 1 == this.operations.size();
                                        boolean bl4 = i + 2 == this.operations.size() && !((Collection)stackOutput).isEmpty() ? true : (haveActiveStackOutput = false);
                                        if (this.showOpcodes && i > 0) {
                                            sb.append('\n');
                                        } else if (this.showStack && haveActiveLastOpLine) {
                                            sb.append('\n');
                                        }
                                        String operation = (String)(haveActiveLastOpLine ? TERMINAL.ANSI_GREEN + "> " : "  ") + this.operations.get(i) + TERMINAL.ANSI_RESET;
                                        if (this.showOpcodes) {
                                            sb.append(operation);
                                        } else if (this.showStack && (i + 1 == this.operations.size() || i + 2 == this.operations.size())) {
                                            sb.append(StringsKt.repeat((CharSequence)" ", (int)ConsoleDebugTracer.Companion.cleanString(operation).length()));
                                        }
                                        if (haveActiveStackOutput && this.showStack) {
                                            sb.append(StringsKt.repeat((CharSequence)" ", (int)(CollectionsKt.count((Iterable)((Iterable)new IntRange(ConsoleDebugTracer.Companion.cleanString(operation).length(), 30))) - 1)));
                                            sb.append(STACK_HEADER);
                                            sb.append(StringsKt.repeat((CharSequence)"-", (int)Math.max(0, 77 - ConsoleDebugTracer.Companion.cleanString(ConsoleDebugTracer.STACK_HEADER).length())));
                                            sb.append((Object)TERMINAL.ANSI_RESET);
                                        }
                                        if (i + 1 != this.operations.size() || !this.showStack) continue;
                                        sb.append(StringsKt.repeat((CharSequence)" ", (int)(CollectionsKt.count((Iterable)((Iterable)new IntRange(ConsoleDebugTracer.Companion.cleanString(operation).length(), 30))) - 1)));
                                    }
                                    if (this.showStack) {
                                        if (stackOutput.isEmpty()) {
                                            sb.append('\n');
                                        }
                                        n2 = stackOutput.size();
                                        for (i = 0; i < n2; ++i) {
                                            if (i > 0) {
                                                sb.append(StringsKt.repeat((CharSequence)" ", (int)30));
                                            }
                                            sb.append((String)stackOutput.get(i));
                                            sb.append('\n');
                                        }
                                    } else if (this.showOpcodes) {
                                        sb.append('\n');
                                    }
                                    Pair<SourceMapElement, SourceFile> pair = this.sourceAtMessageFrame(messageFrame);
                                    sourceMapElement = (SourceMapElement)pair.component1();
                                    SourceFile sourceFile = (SourceFile)pair.component2();
                                    String filePath = sourceFile.component1();
                                    SortedMap<Integer, SourceLine> sourceSection = sourceFile.component2();
                                    if (this.metaFile != null && this.metaFile.exists()) {
                                        void $this$forEach$iv;
                                        Iterable $this$dropWhile$iv;
                                        Object subText;
                                        if (sourceMapElement != null) {
                                            subText = new StringBuilder();
                                            StringBuilder $this$nextOption_u24lambda_u2411 = subText;
                                            boolean bl5 = false;
                                            $this$nextOption_u24lambda_u2411.append("- ");
                                            $this$nextOption_u24lambda_u2411.append(sourceMapElement.getSourceFileByteOffset());
                                            $this$nextOption_u24lambda_u2411.append(":");
                                            $this$nextOption_u24lambda_u2411.append(sourceMapElement.getLengthOfSourceRange());
                                            $this$nextOption_u24lambda_u2411.append(":");
                                            $this$nextOption_u24lambda_u2411.append(sourceMapElement.getSourceIndex());
                                            $this$nextOption_u24lambda_u2411.append(":");
                                            $this$nextOption_u24lambda_u2411.append(sourceMapElement.getJumpType());
                                            $this$nextOption_u24lambda_u2411.append(" ");
                                            if (filePath == null) {
                                                $this$nextOption_u24lambda_u2411.append("Unknown source file");
                                            } else {
                                                void $this$mapTo$iv$iv2;
                                                Map.Entry it3;
                                                Iterable $this$filterTo$iv$iv2;
                                                Set<Map.Entry<Integer, SourceLine>> set = sourceSection.entrySet();
                                                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                                                Iterable $this$filter$iv2 = set;
                                                boolean $i$f$filter = false;
                                                Iterable iterable = $this$filter$iv2;
                                                Collection destination$iv$iv = new ArrayList();
                                                boolean $i$f$filterTo = false;
                                                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                                                    it3 = (Map.Entry)element$iv$iv;
                                                    boolean bl6 = false;
                                                    if (!((SourceLine)it3.getValue()).getSelected()) continue;
                                                    destination$iv$iv.add(element$iv$iv);
                                                }
                                                Iterable $this$map$iv2 = (List)destination$iv$iv;
                                                boolean $i$f$map = false;
                                                $this$filterTo$iv$iv2 = $this$map$iv2;
                                                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                                boolean $i$f$mapTo = false;
                                                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                                    it3 = (Map.Entry)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    boolean bl7 = false;
                                                    collection.add((Integer)it3.getKey());
                                                }
                                                Integer n3 = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
                                                int firstSelectedLine = n3 != null ? n3 : 0;
                                                SourceLine sourceLine = (SourceLine)sourceSection.get(firstSelectedLine);
                                                int firstSelectedOffset = sourceLine != null ? sourceLine.getOffset() : 0;
                                                $this$nextOption_u24lambda_u2411.append(filePath);
                                                $this$nextOption_u24lambda_u2411.append(": (");
                                                $this$nextOption_u24lambda_u2411.append(firstSelectedLine);
                                                $this$nextOption_u24lambda_u2411.append(", ");
                                                $this$nextOption_u24lambda_u2411.append(firstSelectedOffset);
                                                $this$nextOption_u24lambda_u2411.append(")");
                                            }
                                            $this$nextOption_u24lambda_u2411.append(" ");
                                            sb.append((CharSequence)subText);
                                            int count = 107 > ((StringBuilder)subText).length() ? 107 - ((StringBuilder)subText).length() : 0;
                                            sb.append(StringsKt.repeat((CharSequence)"-", (int)count));
                                        } else {
                                            sb.append(StringsKt.repeat((CharSequence)"-", (int)107));
                                        }
                                        sb.append('\n');
                                        subText = this.mergeSourceContent(sourceSection);
                                        boolean $i$f$dropWhile = false;
                                        boolean yielding$iv = false;
                                        ArrayList list$iv = new ArrayList();
                                        for (Object item$iv : $this$dropWhile$iv) {
                                            if (yielding$iv) {
                                                list$iv.add(item$iv);
                                                continue;
                                            }
                                            it2 = (String)item$iv;
                                            boolean bl8 = false;
                                            if (StringsKt.isBlank((CharSequence)((CharSequence)it2))) continue;
                                            list$iv.add(item$iv);
                                            yielding$iv = true;
                                        }
                                        $this$dropWhile$iv = CollectionsKt.reversed((Iterable)list$iv);
                                        $i$f$dropWhile = false;
                                        yielding$iv = false;
                                        list$iv = new ArrayList();
                                        for (Object item$iv : $this$dropWhile$iv) {
                                            if (yielding$iv) {
                                                list$iv.add(item$iv);
                                                continue;
                                            }
                                            it2 = (String)item$iv;
                                            boolean bl9 = false;
                                            if (StringsKt.isBlank((CharSequence)((CharSequence)it2))) continue;
                                            list$iv.add(item$iv);
                                            yielding$iv = true;
                                        }
                                        $this$dropWhile$iv = CollectionsKt.take((Iterable)CollectionsKt.reversed((Iterable)list$iv), (int)10);
                                        boolean $i$f$forEach = false;
                                        for (Object element$iv22 : $this$forEach$iv) {
                                            String it4 = (String)element$iv22;
                                            boolean bl10 = false;
                                            sb.append(it4);
                                            sb.append('\n');
                                        }
                                        sb.append((Object)TERMINAL.ANSI_RESET);
                                    }
                                    Set<Map.Entry<Integer, SourceLine>> set = sourceSection.entrySet();
                                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                                    Iterable $i$f$forEach = set;
                                    boolean $i$f$filter = false;
                                    element$iv22 = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList();
                                    boolean $i$f$filterTo = false;
                                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (Map.Entry)element$iv$iv;
                                        boolean bl11 = false;
                                        if (!((SourceLine)it.getValue()).getSelected()) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    boolean $i$f$map = false;
                                    $this$filterTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                        it = (Map.Entry)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        boolean iterator22 = false;
                                        collection.add((Integer)it.getKey());
                                    }
                                    Set activeLines = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                                    boolean haveCommandOutput = !((Collection)this.commandOutputs).isEmpty();
                                    boolean haveActiveBreakPoint = this.isBreakPointActive(filePath, activeLines);
                                    pauseOnNext = this.skipOperations.decrementAndGet() <= 0 || haveCommandOutput || haveActiveBreakPoint;
                                    it2 = NUMBER_FORMAT;
                                    Object[] item$iv$iv = new Object[]{this.operations.size()};
                                    String string = String.format((String)it2, Arrays.copyOf(item$iv$iv, item$iv$iv.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                                    opCount = "- " + string + " ";
                                    if (!pauseOnNext || this.runTillEnd) break block59;
                                    $this$any$iv = this.breakPoints.values();
                                    boolean $i$f$any = false;
                                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block60;
                                    bl2 = false;
                                    break block56;
                                }
                                iterator22 = $this$any$iv.iterator();
                                break block61;
                            }
                            object = "";
                            break block62;
                        }
                        while (iterator22.hasNext()) {
                            element$iv = iterator22.next();
                            Set it = (Set)element$iv;
                            boolean bl12 = false;
                            boolean bl13 = !((Collection)it).isEmpty();
                            if (!bl13) continue;
                            bl2 = true;
                            break block56;
                        }
                        bl2 = false;
                    }
                    String nextSection = bl2 ? TERMINAL.ANSI_YELLOW + "next" + TERMINAL.ANSI_RESET + " = run till next, " : TERMINAL.ANSI_YELLOW + "end" + TERMINAL.ANSI_RESET + " = run till end, ";
                    object = "--> " + TERMINAL.ANSI_YELLOW + "[enter]" + TERMINAL.ANSI_RESET + " = next section, " + nextSection + TERMINAL.ANSI_RED + "abort" + TERMINAL.ANSI_RESET + " = terminate, " + TERMINAL.ANSI_YELLOW + "help" + TERMINAL.ANSI_RESET + " = options ";
                }
                String options = object;
                sb.append(opCount);
                sb.append(options);
                sb.append(StringsKt.repeat((CharSequence)"-", (int)Math.max(0, 107 - opCount.length() - ConsoleDebugTracer.Companion.cleanString(options).length())));
                sb.append('\n');
                if (this.runTillEnd) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return string;
                }
                if (!pauseOnNext) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return string;
                }
                if (this.lastSourceMapElement != null && sourceMapElement != null) {
                    SourceMapElement sourceMapElement2 = this.lastSourceMapElement;
                    Intrinsics.checkNotNull((Object)sourceMapElement2);
                    if (sourceMapElement2.getSourceFileByteOffset() == sourceMapElement.getSourceFileByteOffset()) {
                        SourceMapElement sourceMapElement3 = this.lastSourceMapElement;
                        Intrinsics.checkNotNull((Object)sourceMapElement3);
                        if (sourceMapElement3.getLengthOfSourceRange() == sourceMapElement.getLengthOfSourceRange()) {
                            SourceMapElement sourceMapElement4 = this.lastSourceMapElement;
                            Intrinsics.checkNotNull((Object)sourceMapElement4);
                            if (sourceMapElement4.getSourceIndex() == sourceMapElement.getSourceIndex()) {
                                String string = sb.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                                return string;
                            }
                        }
                    }
                }
                if (this.lastSourceMapElement != null && sourceMapElement != null && sourceMapElement.getSourceIndex() < 0) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return string;
                }
                try {
                    System.out.print((Object)sb.toString());
                    if (!((Collection)this.commandOutputs).isEmpty()) {
                        Iterable $this$forEach$iv = this.commandOutputs;
                        boolean $i$f$forEach = false;
                        Iterator $i$f$any = $this$forEach$iv.iterator();
                        while ($i$f$any.hasNext()) {
                            Object element$iv3;
                            Object p0 = element$iv3 = $i$f$any.next();
                            boolean bl14 = false;
                            System.out.println(p0);
                        }
                        this.commandOutputs.clear();
                    }
                    System.out.print((Object)": ");
                    String input = this.reader.readLine();
                    if (input == null) {
                        this.skipOperations.set(Integer.MAX_VALUE);
                        this.breakPoints.clear();
                        return "";
                    }
                    String string = ((Object)StringsKt.trim((CharSequence)input)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)string, (Object)"abort")) {
                        ExceptionalHaltReason exceptionalHaltReason = ExceptionalHaltReason.NONE;
                        Intrinsics.checkNotNullExpressionValue((Object)exceptionalHaltReason, (String)"NONE");
                        throw new ExceptionalHaltException(exceptionalHaltReason);
                    }
                    String string3 = ((Object)StringsKt.trim((CharSequence)input)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)string3, (Object)"next")) {
                        Iterable $this$any$iv = this.breakPoints.values();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                            break block57;
                        }
                        iterator = $this$any$iv.iterator();
                        break block58;
                    }
                    String string4 = ((Object)StringsKt.trim((CharSequence)input)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)string4, (Object)"end")) {
                        this.runTillEnd = true;
                        return "";
                    }
                    String string5 = ((Object)StringsKt.trim((CharSequence)input)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    if (StringsKt.startsWith$default((String)string5, (String)"break", (boolean)false, (int)2, null)) {
                        this.parseBreakPointOption(input);
                        return this.nextOption(messageFrame, true);
                    }
                    String string6 = ((Object)StringsKt.trim((CharSequence)input)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                    if (StringsKt.startsWith$default((String)string6, (String)"show", (boolean)false, (int)2, null)) {
                        this.parseShowOption(input);
                        return this.nextOption(messageFrame, true);
                    }
                    String string7 = ((Object)StringsKt.trim((CharSequence)input)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                    if (StringsKt.startsWith$default((String)string7, (String)"hide", (boolean)false, (int)2, null)) {
                        this.parseHideOption(input);
                        return this.nextOption(messageFrame, true);
                    }
                    String string8 = ((Object)StringsKt.trim((CharSequence)input)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)string8, (Object)"help")) {
                        this.showHelp();
                        return this.nextOption(messageFrame, true);
                    }
                    if (!StringsKt.isBlank((CharSequence)input)) {
                        int x = Integer.parseInt(input);
                        this.skipOperations.set(Math.max(x, 1));
                        this.lastSourceMapElement = null;
                        return "";
                    }
                    this.lastSourceMapElement = sourceMapElement;
                    return "";
                }
                catch (NumberFormatException ex) {
                    return this.nextOption(messageFrame, true);
                }
                catch (IOException ex) {
                    ExceptionalHaltReason exceptionalHaltReason = ExceptionalHaltReason.NONE;
                    Intrinsics.checkNotNullExpressionValue((Object)exceptionalHaltReason, (String)"NONE");
                    throw new ExceptionalHaltException(exceptionalHaltReason);
                }
            }
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                Set it = (Set)element$iv;
                boolean bl15 = false;
                boolean bl16 = !((Collection)it).isEmpty();
                if (!bl16) continue;
                bl = true;
                break block57;
            }
            bl = false;
        }
        if (bl) {
            this.skipOperations.set(Integer.MAX_VALUE);
            return "";
        }
        this.commandOutputs.add(TERMINAL.ANSI_CYAN + "No breakpoints found" + TERMINAL.ANSI_RESET);
        return this.nextOption(messageFrame, true);
    }

    static /* synthetic */ String nextOption$default(ConsoleDebugTracer consoleDebugTracer, MessageFrame messageFrame, boolean bl, int n, Object object) throws ExceptionalHaltException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextOption");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return consoleDebugTracer.nextOption(messageFrame, bl);
    }

    public void tracePostExecution(@NotNull MessageFrame messageFrame, @Nullable Operation.OperationResult result2) {
        Intrinsics.checkNotNullParameter((Object)messageFrame, (String)"messageFrame");
        if (messageFrame.getState() != MessageFrame.State.CODE_EXECUTING) {
            this.skipOperations.set(0);
            this.operations.clear();
            this.runTillEnd = false;
            String string = this.output;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                string = null;
            }
            System.out.println((Object)string);
        }
    }

    public void tracePreExecution(@NotNull MessageFrame messageFrame) {
        Intrinsics.checkNotNullParameter((Object)messageFrame, (String)"messageFrame");
        this.output = ConsoleDebugTracer.nextOption$default(this, messageFrame, false, 2, null);
    }

    @JvmOverloads
    public ConsoleDebugTracer(@Nullable File metaFile) {
        this(metaFile, null, 2, null);
    }

    @JvmOverloads
    public ConsoleDebugTracer() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/web3j/evm/ConsoleDebugTracer$Companion;", "", "()V", "FULL_WIDTH", "", "MAX_STACK_ITEM_LENGTH", "NUMBER_FORMAT", "", "OP_CODES_WIDTH", "STACK_HEADER", "cleanString", "input", "web3j-evm"})
    @SourceDebugExtension(value={"SMAP\nConsoleDebugTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleDebugTracer.kt\norg/web3j/evm/ConsoleDebugTracer$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,455:1\n12720#2,3:456\n*S KotlinDebug\n*F\n+ 1 ConsoleDebugTracer.kt\norg/web3j/evm/ConsoleDebugTracer$Companion\n*L\n438#1:456,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String cleanString(String input) {
            TERMINAL[] $this$fold$iv = TERMINAL.values();
            boolean $i$f$fold = false;
            String accumulator$iv = input;
            int n = $this$fold$iv.length;
            for (int i = 0; i < n; ++i) {
                void t;
                TERMINAL element$iv;
                TERMINAL tERMINAL = element$iv = $this$fold$iv[i];
                String output = accumulator$iv;
                boolean bl = false;
                accumulator$iv = StringsKt.replace$default((String)output, (String)t.toString(), (String)"", (boolean)false, (int)4, null);
            }
            return accumulator$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/web3j/evm/ConsoleDebugTracer$TERMINAL;", "", "escapeSequence", "", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "ANSI_RESET", "ANSI_BLACK", "ANSI_RED", "ANSI_GREEN", "ANSI_YELLOW", "ANSI_BLUE", "ANSI_PURPLE", "ANSI_CYAN", "ANSI_WHITE", "CLEAR", "web3j-evm"})
    private static final class TERMINAL
    extends Enum<TERMINAL> {
        @NotNull
        private final String escapeSequence;
        public static final /* enum */ TERMINAL ANSI_RESET = new TERMINAL("\u001b[0m");
        public static final /* enum */ TERMINAL ANSI_BLACK = new TERMINAL("\u001b[30m");
        public static final /* enum */ TERMINAL ANSI_RED = new TERMINAL("\u001b[31m");
        public static final /* enum */ TERMINAL ANSI_GREEN = new TERMINAL("\u001b[32m");
        public static final /* enum */ TERMINAL ANSI_YELLOW = new TERMINAL("\u001b[33m");
        public static final /* enum */ TERMINAL ANSI_BLUE = new TERMINAL("\u001b[34m");
        public static final /* enum */ TERMINAL ANSI_PURPLE = new TERMINAL("\u001b[35m");
        public static final /* enum */ TERMINAL ANSI_CYAN = new TERMINAL("\u001b[36m");
        public static final /* enum */ TERMINAL ANSI_WHITE = new TERMINAL("\u001b[37m");
        public static final /* enum */ TERMINAL CLEAR = new TERMINAL("\u001b[H\u001b[2J");
        private static final /* synthetic */ TERMINAL[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TERMINAL(String escapeSequence) {
            this.escapeSequence = escapeSequence;
        }

        @NotNull
        public String toString() {
            return this.escapeSequence;
        }

        public static TERMINAL[] values() {
            return (TERMINAL[])$VALUES.clone();
        }

        public static TERMINAL valueOf(String value) {
            return Enum.valueOf(TERMINAL.class, value);
        }

        @NotNull
        public static EnumEntries<TERMINAL> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tERMINALArray = new TERMINAL[]{TERMINAL.ANSI_RESET, TERMINAL.ANSI_BLACK, TERMINAL.ANSI_RED, TERMINAL.ANSI_GREEN, TERMINAL.ANSI_YELLOW, TERMINAL.ANSI_BLUE, TERMINAL.ANSI_PURPLE, TERMINAL.ANSI_CYAN, TERMINAL.ANSI_WHITE, TERMINAL.CLEAR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

