/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import com.google.common.io.Resources;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.cli.config.EthNetworkConfig;
import org.hyperledger.besu.cli.config.NetworkName;
import org.hyperledger.besu.config.GenesisConfigFile;
import org.hyperledger.besu.config.GenesisConfigOptions;
import org.hyperledger.besu.crypto.KeyPair;
import org.hyperledger.besu.datatypes.AccessListEntry;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.parameters.BlockParameter;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.parameters.WithdrawalParameter;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.BlockResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionCompleteResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionHashResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptLogResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptRootResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionReceiptStatusResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionResult;
import org.hyperledger.besu.ethereum.api.query.BlockchainQueries;
import org.hyperledger.besu.ethereum.api.query.TransactionReceiptWithMetadata;
import org.hyperledger.besu.ethereum.core.PrivacyParameters;
import org.hyperledger.besu.ethereum.core.Transaction;
import org.hyperledger.besu.ethereum.core.Withdrawal;
import org.hyperledger.besu.ethereum.mainnet.MainnetProtocolSchedule;
import org.hyperledger.besu.ethereum.mainnet.ProtocolSchedule;
import org.hyperledger.besu.ethereum.mainnet.TransactionReceiptType;
import org.hyperledger.besu.ethereum.rlp.RLP;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.transaction.TransactionSimulatorResult;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.datatypes.Address;
import org.web3j.evm.Configuration;
import org.web3j.evm.EmbeddedEthereum;
import org.web3j.evm.EmbeddedEthereumKt;
import org.web3j.evm.InMemoryBesuChain;
import org.web3j.evm.utils.TestAccountsConstants;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.AccessListObject;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 >2\u00020\u0001:\u0001>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u001c\u001a\u00020\fJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fJ\u000e\u0010$\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020%J\u000e\u0010&\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020'J\u0016\u0010(\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\"J\u0010\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\fJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fJ\u000e\u00106\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\f\u0010<\u001a\u00020=*\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/web3j/evm/EmbeddedEthereum;", "", "configuration", "Lorg/web3j/evm/Configuration;", "operationTracer", "Lorg/hyperledger/besu/evm/tracing/OperationTracer;", "(Lorg/web3j/evm/Configuration;Lorg/hyperledger/besu/evm/tracing/OperationTracer;)V", "blockchainQueries", "Lorg/hyperledger/besu/ethereum/api/query/BlockchainQueries;", "chain", "Lorg/web3j/evm/InMemoryBesuChain;", "estimateGas", "", "web3jTransaction", "Lorg/web3j/protocol/core/methods/request/Transaction;", "ethBlockByBlockResult", "Lorg/web3j/protocol/core/methods/response/EthBlock$Block;", "blockResult", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/BlockResult;", "fullTransactionObjects", "", "ethBlockByHash", "hash", "ethBlockByNumber", "blockNumber", "ethBlockFullTransactionObject", "", "Lorg/web3j/protocol/core/methods/response/EthBlock$TransactionObject;", "ethBlockNumber", "ethBlockTransactionHash", "Lorg/web3j/protocol/core/methods/response/EthBlock$TransactionHash;", "ethCall", "ethGetBalance", "w3jAddress", "Lorg/web3j/abi/datatypes/Address;", "defaultBlockParameter", "ethGetBlockTransactionCountByHash", "Lorg/hyperledger/besu/datatypes/Hash;", "ethGetBlockTransactionCountByNumber", "", "ethGetCode", "getResult", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/TransactionReceiptResult;", "receipt", "Lorg/hyperledger/besu/ethereum/api/query/TransactionReceiptWithMetadata;", "getTransactionCount", "Ljava/math/BigInteger;", "getTransactionReceipt", "Lorg/web3j/protocol/core/methods/response/TransactionReceipt;", "transactionHashParam", "mapTransactionReceiptLog", "Lorg/web3j/protocol/core/methods/response/Log;", "result", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/TransactionReceiptLogResult;", "processTransaction", "signedTransactionData", "toWithdrawal", "Lorg/web3j/protocol/core/methods/response/EthBlock$Withdrawal;", "withdrawalParameter", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/parameters/WithdrawalParameter;", "toSignedBesuTx", "Lorg/hyperledger/besu/ethereum/core/Transaction;", "Companion", "web3j-evm"})
@SourceDebugExtension(value={"SMAP\nEmbeddedEthereum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedEthereum.kt\norg/web3j/evm/EmbeddedEthereum\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,426:1\n1549#2:427\n1620#2,3:428\n1549#2:431\n1620#2,2:432\n1549#2:434\n1620#2,3:435\n1622#2:438\n1549#2:439\n1620#2,3:440\n1549#2:443\n1620#2,3:444\n*S KotlinDebug\n*F\n+ 1 EmbeddedEthereum.kt\norg/web3j/evm/EmbeddedEthereum\n*L\n168#1:427\n168#1:428,3\n271#1:431\n271#1:432,2\n296#1:434\n296#1:435,3\n271#1:438\n307#1:439\n307#1:440,3\n347#1:443\n347#1:444,3\n*E\n"})
public final class EmbeddedEthereum {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final InMemoryBesuChain chain;
    @NotNull
    private final BlockchainQueries blockchainQueries;
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedEthereum.class);

    public EmbeddedEthereum(@NotNull Configuration configuration, @NotNull OperationTracer operationTracer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)operationTracer, (String)"operationTracer");
        this.configuration = configuration;
        this.chain = new InMemoryBesuChain(this.configuration, operationTracer, null, null, 12, null);
        this.blockchainQueries = this.chain.getBlockchainQueries();
    }

    @NotNull
    public final String processTransaction(@NotNull Transaction web3jTransaction) {
        Intrinsics.checkNotNullParameter((Object)web3jTransaction, (String)"web3jTransaction");
        org.hyperledger.besu.ethereum.core.Transaction transaction = this.toSignedBesuTx(web3jTransaction);
        this.chain.processTransaction(transaction);
        String string = transaction.getHash().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    @NotNull
    public final String processTransaction(@NotNull String signedTransactionData) {
        Intrinsics.checkNotNullParameter((Object)signedTransactionData, (String)"signedTransactionData");
        org.hyperledger.besu.ethereum.core.Transaction transaction = org.hyperledger.besu.ethereum.core.Transaction.readFrom((RLPInput)RLP.input((Bytes)Bytes.fromHexString((CharSequence)signedTransactionData)));
        Intrinsics.checkNotNull((Object)transaction);
        this.chain.processTransaction(transaction);
        String string = transaction.getHash().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    private final org.hyperledger.besu.ethereum.core.Transaction toSignedBesuTx(Transaction $this$toSignedBesuTx) {
        String string;
        String string2;
        String string3;
        String string4;
        long l;
        BigInteger chainId;
        Transaction $this$toSignedBesuTx_u24lambda_u240 = $this$toSignedBesuTx;
        boolean bl = false;
        String string5 = $this$toSignedBesuTx_u24lambda_u240.getChainId();
        BigInteger bigInteger = chainId = string5 != null ? new BigInteger(string5) : this.chain.getChainId();
        if ($this$toSignedBesuTx_u24lambda_u240.getNonce() == null) {
            l = this.getTransactionCount(new Address($this$toSignedBesuTx_u24lambda_u240.getFrom())).longValue();
        } else {
            String string6 = $this$toSignedBesuTx_u24lambda_u240.getNonce();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getNonce(...)");
            l = EmbeddedEthereum.Companion.hexToULong(string6);
        }
        long nonce = l;
        String string7 = string4 = $this$toSignedBesuTx_u24lambda_u240.getFrom();
        if (string7 == null) {
            string3 = "0x0";
        } else {
            Intrinsics.checkNotNull((Object)string7);
            string3 = string4;
        }
        String string8 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        String from = string8;
        Transaction.Builder builder = org.hyperledger.besu.ethereum.core.Transaction.builder().gasLimit(EmbeddedEthereum.Companion.transactionGasLimitOrDefault($this$toSignedBesuTx_u24lambda_u240));
        String string9 = $this$toSignedBesuTx_u24lambda_u240.getGasPrice();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getGasPrice(...)");
        Transaction.Builder builder2 = builder.gasPrice(Wei.of((long)EmbeddedEthereum.Companion.hexToULong(string9))).nonce(nonce).sender(org.hyperledger.besu.datatypes.Address.fromHexString((String)from)).to(org.hyperledger.besu.datatypes.Address.fromHexString((String)$this$toSignedBesuTx_u24lambda_u240.getTo())).payload(Bytes.fromHexString((CharSequence)$this$toSignedBesuTx_u24lambda_u240.getData()));
        String string10 = string2 = $this$toSignedBesuTx_u24lambda_u240.getValue();
        if (string10 == null) {
            string = "0x0";
        } else {
            Intrinsics.checkNotNull((Object)string10);
            string = string2;
        }
        Transaction.Builder builder3 = builder2.value(Wei.of((UInt256)UInt256.fromHexString((String)string))).chainId(chainId).guessType();
        KeyPair keyPair = TestAccountsConstants.INSTANCE.getTEST_ACCOUNTS().get(from);
        if (keyPair == null) {
            keyPair = (KeyPair)CollectionsKt.first((Iterable)TestAccountsConstants.INSTANCE.getTEST_ACCOUNTS().values());
        }
        string4 = builder3.signAndBuild(keyPair);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"signAndBuild(...)");
        return string4;
    }

    @NotNull
    public final BigInteger getTransactionCount(@NotNull Address w3jAddress) {
        Intrinsics.checkNotNullParameter((Object)w3jAddress, (String)"w3jAddress");
        long count = this.blockchainQueries.getTransactionCount(EmbeddedEthereumKt.access$asBesu(w3jAddress));
        BigInteger bigInteger = BigInteger.valueOf(count);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TransactionReceipt getTransactionReceipt(@NotNull String transactionHashParam) {
        void $this$mapTo$iv$iv;
        GenesisConfigFile genesisConfigFile;
        Intrinsics.checkNotNullParameter((Object)transactionHashParam, (String)"transactionHashParam");
        Hash hash = Hash.fromHexStringLenient((String)transactionHashParam);
        if (this.configuration.getGenesisFileUrl() == null) {
            EthNetworkConfig networkConfig = EthNetworkConfig.getNetworkConfig((NetworkName)NetworkName.DEV);
            genesisConfigFile = GenesisConfigFile.fromConfig((String)networkConfig.getGenesisConfig());
        } else {
            genesisConfigFile = GenesisConfigFile.fromConfig((String)Resources.toString((URL)this.configuration.getGenesisFileUrl(), (Charset)StandardCharsets.UTF_8));
        }
        GenesisConfigFile genesisConfig = genesisConfigFile;
        GenesisConfigOptions configOptions = genesisConfig.getConfigOptions(InMemoryBesuChain.Companion.getDEFAULT_GENESIS_OVERRIDES$web3j_evm());
        ProtocolSchedule protocolSchedule = MainnetProtocolSchedule.fromConfig((GenesisConfigOptions)configOptions, (PrivacyParameters)PrivacyParameters.DEFAULT, (boolean)true, (EvmConfiguration)EvmConfiguration.DEFAULT);
        TransactionReceiptResult transactionReceiptResult = this.blockchainQueries.transactionReceiptByTransactionHash(hash, protocolSchedule).map(arg_0 -> EmbeddedEthereum.getTransactionReceipt$lambda$1((Function1)new Function1<TransactionReceiptWithMetadata, TransactionReceiptResult>(this){
            final /* synthetic */ EmbeddedEthereum this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final TransactionReceiptResult invoke(TransactionReceiptWithMetadata receipt) {
                Intrinsics.checkNotNull((Object)receipt);
                return EmbeddedEthereum.access$getResult(this.this$0, receipt);
            }
        }, arg_0)).orElse(null);
        if (transactionReceiptResult == null) {
            return null;
        }
        TransactionReceiptResult result2 = transactionReceiptResult;
        String blockHash = result2.getBlockHash();
        String blockNumber = result2.getBlockNumber();
        String contractAddress = result2.getContractAddress();
        String cumulativeGasUsed = result2.getCumulativeGasUsed();
        String from = result2.getFrom();
        String gasUsed = result2.getGasUsed();
        String effectiveGasPrice = result2.getEffectiveGasPrice();
        List list = result2.getLogs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLogs(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TransactionReceiptLogResult transactionReceiptLogResult = (TransactionReceiptLogResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.mapTransactionReceiptLog((TransactionReceiptLogResult)p0));
        }
        List logs = (List)destination$iv$iv;
        String logsBloom = result2.getLogsBloom();
        String to = result2.getTo();
        String transactionHash = result2.getTransactionHash();
        String transactionIndex = result2.getTransactionIndex();
        String root = result2 instanceof TransactionReceiptRootResult ? ((TransactionReceiptRootResult)result2).getRoot() : null;
        String status = result2 instanceof TransactionReceiptStatusResult ? ((TransactionReceiptStatusResult)result2).getStatus() : null;
        return new TransactionReceipt(transactionHash, transactionIndex, blockHash, blockNumber, cumulativeGasUsed, gasUsed, contractAddress, root, status, from, to, logs, logsBloom, "", "", effectiveGasPrice);
    }

    private final Log mapTransactionReceiptLog(TransactionReceiptLogResult result2) {
        boolean removed = result2.isRemoved();
        String logIndex = result2.getLogIndex();
        String transactionIndex = result2.getTransactionIndex();
        String transactionHash = result2.getTransactionHash();
        String blockHash = result2.getBlockHash();
        String blockNumber = result2.getBlockNumber();
        String address = result2.getAddress();
        String data = result2.getData();
        String type = null;
        List topics = result2.getTopics();
        return new Log(removed, logIndex, transactionIndex, transactionHash, blockHash, blockNumber, address, data, type, topics);
    }

    private final TransactionReceiptResult getResult(TransactionReceiptWithMetadata receipt) {
        return receipt.getReceipt().getTransactionReceiptType() == TransactionReceiptType.ROOT ? (TransactionReceiptResult)new TransactionReceiptRootResult(receipt) : (TransactionReceiptResult)new TransactionReceiptStatusResult(receipt);
    }

    @NotNull
    public final String ethCall(@NotNull Transaction web3jTransaction) {
        Intrinsics.checkNotNullParameter((Object)web3jTransaction, (String)"web3jTransaction");
        Optional<TransactionSimulatorResult> result2 = this.chain.call(EmbeddedEthereumKt.access$asCallParameter(web3jTransaction));
        String string = result2.get().getResult().getOutput().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    @NotNull
    public final String estimateGas(@NotNull Transaction web3jTransaction) {
        Intrinsics.checkNotNullParameter((Object)web3jTransaction, (String)"web3jTransaction");
        Optional<TransactionSimulatorResult> result2 = this.chain.call(EmbeddedEthereumKt.access$asCallParameter(web3jTransaction));
        return EmbeddedEthereum.Companion.longToHex(result2.get().getResult().getEstimateGasUsedByTransaction());
    }

    @NotNull
    public final String ethBlockNumber() {
        return EmbeddedEthereum.Companion.longToHex(this.blockchainQueries.headBlockNumber());
    }

    @Nullable
    public final String ethGetBalance(@NotNull Address w3jAddress, @NotNull String defaultBlockParameter) {
        Intrinsics.checkNotNullParameter((Object)w3jAddress, (String)"w3jAddress");
        Intrinsics.checkNotNullParameter((Object)defaultBlockParameter, (String)"defaultBlockParameter");
        return this.blockchainQueries.accountBalance(org.hyperledger.besu.datatypes.Address.fromHexString((String)w3jAddress.getValue()), this.blockchainQueries.headBlockNumber()).map(arg_0 -> EmbeddedEthereum.ethGetBalance$lambda$2(ethGetBalance.1.INSTANCE, arg_0)).orElse(null);
    }

    @Nullable
    public final EthBlock.Block ethBlockByHash(@NotNull String hash, boolean fullTransactionObjects) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Hash hash2 = Hash.fromHexString((String)hash);
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"fromHexString(...)");
        Optional<BlockResult> maybeBlockResult = this.chain.ethBlockByHash(hash2, fullTransactionObjects);
        return maybeBlockResult.map(arg_0 -> EmbeddedEthereum.ethBlockByHash$lambda$3((Function1)new Function1<BlockResult, EthBlock.Block>(this, fullTransactionObjects){
            final /* synthetic */ EmbeddedEthereum this$0;
            final /* synthetic */ boolean $fullTransactionObjects;
            {
                this.this$0 = $receiver;
                this.$fullTransactionObjects = $fullTransactionObjects;
                super(1);
            }

            @Nullable
            public final EthBlock.Block invoke(BlockResult br) {
                Intrinsics.checkNotNull((Object)br);
                return EmbeddedEthereum.access$ethBlockByBlockResult(this.this$0, br, this.$fullTransactionObjects);
            }
        }, arg_0)).orElse(null);
    }

    @Nullable
    public final EthBlock.Block ethBlockByNumber(@NotNull String blockNumber, boolean fullTransactionObjects) {
        Intrinsics.checkNotNullParameter((Object)blockNumber, (String)"blockNumber");
        Optional<BlockResult> maybeBlockResult = this.chain.ethBlockByNumber(EmbeddedEthereum.Companion.hexToULong(blockNumber), fullTransactionObjects);
        return maybeBlockResult.map(arg_0 -> EmbeddedEthereum.ethBlockByNumber$lambda$4((Function1)new Function1<BlockResult, EthBlock.Block>(this, fullTransactionObjects){
            final /* synthetic */ EmbeddedEthereum this$0;
            final /* synthetic */ boolean $fullTransactionObjects;
            {
                this.this$0 = $receiver;
                this.$fullTransactionObjects = $fullTransactionObjects;
                super(1);
            }

            @Nullable
            public final EthBlock.Block invoke(BlockResult br) {
                Intrinsics.checkNotNull((Object)br);
                return EmbeddedEthereum.access$ethBlockByBlockResult(this.this$0, br, this.$fullTransactionObjects);
            }
        }, arg_0)).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EthBlock.TransactionObject> ethBlockFullTransactionObject(BlockResult blockResult) {
        void $this$mapTo$iv$iv;
        List list = blockResult.getTransactions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTransactions(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<AccessListObject> collection;
            List list2;
            void it;
            TransactionResult transactionResult = (TransactionResult)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionCompleteResult");
            TransactionCompleteResult tcr = (TransactionCompleteResult)it;
            String string = tcr.getHash();
            String string2 = tcr.getNonce();
            String string3 = tcr.getBlockHash();
            String string4 = tcr.getBlockNumber();
            String string5 = tcr.getChainId();
            String string6 = tcr.getTransactionIndex();
            String string7 = tcr.getFrom();
            String string8 = tcr.getTo();
            String string9 = tcr.getValue();
            String string10 = tcr.getGasPrice();
            String string11 = tcr.getGas();
            String string12 = tcr.getInput();
            String string13 = null;
            String string14 = null;
            String string15 = null;
            String string16 = tcr.getR();
            String string17 = tcr.getS();
            String string18 = tcr.getV();
            Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"getV(...)");
            long l = EmbeddedEthereum.Companion.hexToULong(string18);
            String string19 = tcr.getYParity();
            String string20 = tcr.getType();
            String string21 = tcr.getMaxFeePerGas();
            String string22 = tcr.getMaxPriorityFeePerGas();
            List list3 = list2 = tcr.getAccessList();
            if (list3 != null) {
                Collection<AccessListObject> collection3;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Intrinsics.checkNotNull((Object)list3);
                Iterable iterable2 = list2;
                String string23 = string22;
                String string24 = string21;
                String string25 = string20;
                String string26 = string19;
                long l2 = l;
                String string27 = string17;
                String string28 = string16;
                String string29 = string15;
                String string30 = string14;
                String string31 = string13;
                String string32 = string12;
                String string33 = string11;
                String string34 = string10;
                String string35 = string9;
                String string36 = string8;
                String string37 = string7;
                String string38 = string6;
                String string39 = string5;
                String string40 = string4;
                String string41 = string3;
                String string42 = string2;
                String string43 = string;
                boolean $i$f$map2 = false;
                void var38_37 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it2;
                    AccessListEntry accessListEntry = (AccessListEntry)item$iv$iv2;
                    collection3 = destination$iv$iv2;
                    boolean bl2 = false;
                    Object[] objectArray = new String[]{it2.storageKeys().toString()};
                    collection3.add(new AccessListObject(it2.address().toString(), CollectionsKt.mutableListOf((Object[])objectArray)));
                }
                collection3 = (List)destination$iv$iv2;
                string = string43;
                string2 = string42;
                string3 = string41;
                string4 = string40;
                string5 = string39;
                string6 = string38;
                string7 = string37;
                string8 = string36;
                string9 = string35;
                string10 = string34;
                string11 = string33;
                string12 = string32;
                string13 = string31;
                string14 = string30;
                string15 = string29;
                string16 = string28;
                string17 = string27;
                l = l2;
                string19 = string26;
                string20 = string25;
                string21 = string24;
                string22 = string23;
                collection = collection3;
            } else {
                collection = null;
            }
            Collection<AccessListObject> collection4 = collection;
            String string44 = string22;
            String string45 = string21;
            String string46 = string20;
            String string47 = string19;
            long l3 = l;
            String string48 = string17;
            String string49 = string16;
            String string50 = string15;
            String string51 = string14;
            String string52 = string13;
            String string53 = string12;
            String string54 = string11;
            String string55 = string10;
            String string56 = string9;
            String string57 = string8;
            String string58 = string7;
            String string59 = string6;
            String string60 = string5;
            String string61 = string4;
            String string62 = string3;
            String string63 = string2;
            String string64 = string;
            collection2.add(new EthBlock.TransactionObject(string64, string63, string62, string61, string60, string59, string58, string57, string56, string55, string54, string53, string52, string51, string50, string49, string48, l3, string47, string46, string45, string44, collection4));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EthBlock.TransactionHash> ethBlockTransactionHash(BlockResult blockResult) {
        void $this$mapTo$iv$iv;
        List list = blockResult.getTransactions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTransactions(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TransactionResult transactionResult = (TransactionResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.TransactionHashResult");
            TransactionHashResult thr = (TransactionHashResult)it;
            collection.add(new EthBlock.TransactionHash(thr.getHash()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final EthBlock.Block ethBlockByBlockResult(BlockResult blockResult, boolean fullTransactionObjects) {
        List list;
        List<EthBlock.TransactionObject> transactionResults = fullTransactionObjects ? this.ethBlockFullTransactionObject(blockResult) : this.ethBlockTransactionHash(blockResult);
        String string = blockResult.getNumber();
        String string2 = blockResult.getHash();
        String string3 = blockResult.getParentHash();
        String string4 = blockResult.getNonce();
        String string5 = blockResult.getSha3Uncles();
        String string6 = blockResult.getLogsBloom();
        String string7 = blockResult.getTransactionsRoot();
        String string8 = blockResult.getStateRoot();
        String string9 = blockResult.getReceiptsRoot();
        String string10 = null;
        String string11 = blockResult.getMiner();
        String string12 = null;
        String string13 = blockResult.getDifficulty();
        String string14 = blockResult.getTotalDifficulty();
        String string15 = blockResult.getExtraData();
        String string16 = blockResult.getSize();
        String string17 = blockResult.getGasLimit();
        String string18 = blockResult.getGasUsed();
        String string19 = blockResult.getTimestamp();
        List<EthBlock.TransactionObject> list2 = transactionResults;
        List list3 = null;
        List list4 = null;
        String string20 = blockResult.getBaseFeePerGas();
        String string21 = blockResult.getWithdrawalsRoot();
        List list5 = blockResult.getWithdrawals();
        if (list5 != null) {
            Collection<EthBlock.Withdrawal> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list5;
            String string22 = string21;
            String string23 = string20;
            List list6 = list4;
            List list7 = list3;
            List<EthBlock.TransactionObject> list8 = list2;
            String string24 = string19;
            String string25 = string18;
            String string26 = string17;
            String string27 = string16;
            String string28 = string15;
            String string29 = string14;
            String string30 = string13;
            String string31 = string12;
            String string32 = string11;
            String string33 = string10;
            String string34 = string9;
            String string35 = string8;
            String string36 = string7;
            String string37 = string6;
            String string38 = string5;
            String string39 = string4;
            String string40 = string3;
            String string41 = string2;
            String string42 = string;
            boolean $i$f$map = false;
            void var6_30 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void withdrawalParameter;
                WithdrawalParameter withdrawalParameter2 = (WithdrawalParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)withdrawalParameter);
                collection.add(this.toWithdrawal((WithdrawalParameter)withdrawalParameter));
            }
            collection = (List)destination$iv$iv;
            string = string42;
            string2 = string41;
            string3 = string40;
            string4 = string39;
            string5 = string38;
            string6 = string37;
            string7 = string36;
            string8 = string35;
            string9 = string34;
            string10 = string33;
            string11 = string32;
            string12 = string31;
            string13 = string30;
            string14 = string29;
            string15 = string28;
            string16 = string27;
            string17 = string26;
            string18 = string25;
            string19 = string24;
            list2 = list8;
            list3 = list7;
            list4 = list6;
            string20 = string23;
            string21 = string22;
            list = CollectionsKt.toList((Iterable)collection);
        } else {
            list = null;
        }
        List list9 = list;
        String string43 = string21;
        String string44 = string20;
        List list10 = list4;
        List list11 = list3;
        List<EthBlock.TransactionObject> list12 = list2;
        String string45 = string19;
        String string46 = string18;
        String string47 = string17;
        String string48 = string16;
        String string49 = string15;
        String string50 = string14;
        String string51 = string13;
        String string52 = string12;
        String string53 = string11;
        String string54 = string10;
        String string55 = string9;
        String string56 = string8;
        String string57 = string7;
        String string58 = string6;
        String string59 = string5;
        String string60 = string4;
        String string61 = string3;
        String string62 = string2;
        String string63 = string;
        return new EthBlock.Block(string63, string62, string61, string60, string59, string58, string57, string56, string55, string54, string53, string52, string51, string50, string49, string48, string47, string46, string45, list12, list11, list10, string44, string43, list9);
    }

    private final EthBlock.Withdrawal toWithdrawal(WithdrawalParameter withdrawalParameter) {
        Withdrawal withdrawal = withdrawalParameter.toWithdrawal();
        return new EthBlock.Withdrawal(withdrawal.getIndex().toString(), withdrawal.getValidatorIndex().toString(), withdrawal.getAddress().toHexString(), withdrawal.getAmount().toHexString());
    }

    @NotNull
    public final String ethGetCode(@NotNull Address w3jAddress, @NotNull String defaultBlockParameter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)w3jAddress, (String)"w3jAddress");
        Intrinsics.checkNotNullParameter((Object)defaultBlockParameter, (String)"defaultBlockParameter");
        BlockParameter blockParameter = new BlockParameter(defaultBlockParameter);
        Optional optional = blockParameter.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getNumber(...)");
        Optional blockNumber = optional;
        org.hyperledger.besu.datatypes.Address address = EmbeddedEthereumKt.access$asBesu(w3jAddress);
        if (blockNumber.isPresent()) {
            Object t = blockNumber.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            object = this.blockchainQueries.getCode(address, ((Number)t).longValue());
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        } else if (blockParameter.isLatest()) {
            object = this.blockchainQueries.getCode(address, this.blockchainQueries.headBlockNumber());
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        } else if (blockParameter.isEarliest()) {
            object = this.blockchainQueries.getCode(address, 0L);
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        } else {
            object = this.blockchainQueries.getCode(address, this.blockchainQueries.headBlockNumber());
            if (object == null || (object = (Bytes)((Optional)object).get()) == null || (object = object.toString()) == null) {
                object = "0x";
            }
        }
        return object;
    }

    @NotNull
    public final String ethGetBlockTransactionCountByHash(@NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        String string = Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(this.blockchainQueries.getTransactionCount(hash).intValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeQuantity(...)");
        return string;
    }

    @NotNull
    public final String ethGetBlockTransactionCountByNumber(long blockNumber) {
        String string = Numeric.encodeQuantity((BigInteger)BigInteger.valueOf(((Number)this.blockchainQueries.getTransactionCount(blockNumber).get()).intValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeQuantity(...)");
        return string;
    }

    private static final TransactionReceiptResult getTransactionReceipt$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TransactionReceiptResult)$tmp0.invoke(p0);
    }

    private static final String ethGetBalance$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final EthBlock.Block ethBlockByHash$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EthBlock.Block)$tmp0.invoke(p0);
    }

    private static final EthBlock.Block ethBlockByNumber$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (EthBlock.Block)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ TransactionReceiptResult access$getResult(EmbeddedEthereum $this, TransactionReceiptWithMetadata receipt) {
        return $this.getResult(receipt);
    }

    public static final /* synthetic */ EthBlock.Block access$ethBlockByBlockResult(EmbeddedEthereum $this, BlockResult blockResult, boolean fullTransactionObjects) {
        return $this.ethBlockByBlockResult(blockResult, fullTransactionObjects);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/web3j/evm/EmbeddedEthereum$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "hexToULong", "", "hex", "", "longToHex", "value", "transactionGasLimitOrDefault", "web3jTransaction", "Lorg/web3j/protocol/core/methods/request/Transaction;", "web3j-evm"})
    public static final class Companion {
        private Companion() {
        }

        private final long hexToULong(String hex) {
            return UInt256.fromHexString((String)hex).toLong();
        }

        private final String longToHex(long value) {
            String string = UInt256.valueOf((long)value).toShortHexString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortHexString(...)");
            return string;
        }

        private final long transactionGasLimitOrDefault(Transaction web3jTransaction) {
            long l;
            if (web3jTransaction.getGas() == null) {
                l = 10000000L;
            } else {
                String string = web3jTransaction.getGas();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGas(...)");
                l = this.hexToULong(string);
            }
            return l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

