/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import io.reactivex.Flowable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.datatypes.Address;
import org.web3j.evm.Configuration;
import org.web3j.evm.EmbeddedEthereum;
import org.web3j.evm.PassthroughTracer;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.BatchRequest;
import org.web3j.protocol.core.BatchResponse;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByHash;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByNumber;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthSyncing;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.websocket.events.Notification;
import org.web3j.utils.Async;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 72\u00020\u0001:\u00017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\rH\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001c\u0010$\u001a\u0006\u0012\u0002\b\u00030\r2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&H\u0002J9\u0010$\u001a\u0002H'\"\f\b\u0000\u0010'*\u0006\u0012\u0002\b\u00030\r2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016\u00a2\u0006\u0002\u0010*J:\u0010+\u001a\b\u0012\u0004\u0012\u0002H'0,\"\f\b\u0000\u0010'*\u0006\u0012\u0002\b\u00030\r2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020.0,2\b\u0010/\u001a\u0004\u0018\u000100H\u0016JB\u00102\u001a\b\u0012\u0004\u0012\u0002H'03\"\f\b\u0000\u0010'*\u0006\u0012\u0002\b\u0003042\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\u0006\u00105\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/web3j/evm/EmbeddedWeb3jService;", "Lorg/web3j/protocol/Web3jService;", "configuration", "Lorg/web3j/evm/Configuration;", "(Lorg/web3j/evm/Configuration;)V", "operationTracer", "Lorg/hyperledger/besu/evm/tracing/OperationTracer;", "(Lorg/web3j/evm/Configuration;Lorg/hyperledger/besu/evm/tracing/OperationTracer;)V", "embeddedEthereum", "Lorg/web3j/evm/EmbeddedEthereum;", "close", "", "estimateGas", "Lorg/web3j/protocol/core/Response;", "", "params", "", "ethBlockByHash", "Lorg/web3j/protocol/core/methods/response/EthBlock$Block;", "ethBlockByNumber", "ethBlockNumber", "ethCall", "ethGasPrice", "ethGetBalance", "ethGetBlockTransactionCountByHash", "ethGetBlockTransactionCountByNumber", "ethGetCode", "ethGetTransactionCount", "", "ethGetTransactionReceipt", "Lorg/web3j/protocol/core/methods/response/TransactionReceipt;", "ethSendRawTransaction", "ethSendTransaction", "ethSyncing", "Lorg/web3j/protocol/core/methods/response/EthSyncing$Result;", "netVersion", "send", "request", "Lorg/web3j/protocol/core/Request;", "T", "responseType", "Ljava/lang/Class;", "(Lorg/web3j/protocol/core/Request;Ljava/lang/Class;)Lorg/web3j/protocol/core/Response;", "sendAsync", "Ljava/util/concurrent/CompletableFuture;", "sendBatch", "Lorg/web3j/protocol/core/BatchResponse;", "p0", "Lorg/web3j/protocol/core/BatchRequest;", "sendBatchAsync", "subscribe", "Lio/reactivex/Flowable;", "Lorg/web3j/protocol/websocket/events/Notification;", "unsubscribeMethod", "web3ClientVersion", "Companion", "web3j-evm"})
public final class EmbeddedWeb3jService
implements Web3jService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmbeddedEthereum embeddedEthereum;
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedWeb3jService.class);

    public EmbeddedWeb3jService(@NotNull Configuration configuration, @NotNull OperationTracer operationTracer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)operationTracer, (String)"operationTracer");
        this.embeddedEthereum = new EmbeddedEthereum(configuration, operationTracer);
    }

    public EmbeddedWeb3jService(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this(configuration, new PassthroughTracer(null, 1, null));
    }

    @NotNull
    public <T extends Response<?>> T send(@NotNull Request<?, ?> request, @NotNull Class<T> responseType) throws IOException {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        T t = responseType.cast(this.send(request));
        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
        return (T)((Response)t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Response<?> send(Request<?, ?> request) {
        LOG.trace("About to execute: " + request.getMethod() + " with params " + request.getParams());
        String string = request.getMethod();
        if (string == null) throw new UnsupportedOperationException(request.getMethod());
        int n = -1;
        switch (string.hashCode()) {
            case -858441004: {
                if (string.equals("eth_hashrate")) {
                    n = 1;
                }
                break;
            }
            case -1335525529: {
                if (string.equals("eth_getUncleByBlockNumberAndIndex")) {
                    n = 2;
                }
                break;
            }
            case 749740211: {
                if (string.equals("eth_getTransactionByHash")) {
                    n = 3;
                }
                break;
            }
            case 862303969: {
                if (string.equals("eth_getWork")) {
                    n = 4;
                }
                break;
            }
            case 65817323: {
                if (string.equals("eth_estimateGas")) {
                    n = 5;
                }
                break;
            }
            case 418420858: {
                if (string.equals("eth_protocolVersion")) {
                    n = 6;
                }
                break;
            }
            case -1723635512: {
                if (string.equals("eth_coinbase")) {
                    n = 7;
                }
                break;
            }
            case 1188910800: {
                if (string.equals("eth_compileSolidity")) {
                    n = 8;
                }
                break;
            }
            case 354464175: {
                if (string.equals("eth_submitWork")) {
                    n = 9;
                }
                break;
            }
            case -669088634: {
                if (string.equals("db_getString")) {
                    n = 10;
                }
                break;
            }
            case -2146713070: {
                if (string.equals("eth_newFilter")) {
                    n = 11;
                }
                break;
            }
            case 1924240813: {
                if (string.equals("web3_clientVersion")) {
                    n = 12;
                }
                break;
            }
            case 861975935: {
                if (string.equals("eth_getLogs")) {
                    n = 13;
                }
                break;
            }
            case 99011270: {
                if (string.equals("db_getHex")) {
                    n = 14;
                }
                break;
            }
            case -2076133913: {
                if (string.equals("web3_sha3")) {
                    n = 15;
                }
                break;
            }
            case 1377974283: {
                if (string.equals("eth_newBlockFilter")) {
                    n = 16;
                }
                break;
            }
            case -315007721: {
                if (string.equals("eth_getFilterLogs")) {
                    n = 17;
                }
                break;
            }
            case -1424874333: {
                if (string.equals("eth_sign")) {
                    n = 18;
                }
                break;
            }
            case 1537270937: {
                if (string.equals("net_listening")) {
                    n = 19;
                }
                break;
            }
            case -1504110108: {
                if (string.equals("eth_getCompilers")) {
                    n = 20;
                }
                break;
            }
            case -40035235: {
                if (string.equals("eth_getBlockByNumber")) {
                    n = 21;
                }
                break;
            }
            case 504935003: {
                if (string.equals("eth_getFilterChanges")) {
                    n = 22;
                }
                break;
            }
            case -805160255: {
                if (string.equals("eth_syncing")) {
                    n = 23;
                }
                break;
            }
            case -657830770: {
                if (string.equals("eth_compileSerpent")) {
                    n = 24;
                }
                break;
            }
            case 529424456: {
                if (string.equals("eth_getUncleCountByBlockHash")) {
                    n = 25;
                }
                break;
            }
            case 1485319360: {
                if (string.equals("admin_nodeInfo")) {
                    n = 26;
                }
                break;
            }
            case -2134141949: {
                if (string.equals("eth_getUncleCountByBlockNumber")) {
                    n = 27;
                }
                break;
            }
            case 1419557972: {
                if (string.equals("eth_uninstallFilter")) {
                    n = 28;
                }
                break;
            }
            case 371449965: {
                if (string.equals("db_putHex")) {
                    n = 29;
                }
                break;
            }
            case -1425358524: {
                if (string.equals("eth_call")) {
                    n = 30;
                }
                break;
            }
            case -1656609263: {
                if (string.equals("eth_getTransactionByBlockHashAndIndex")) {
                    n = 31;
                }
                break;
            }
            case -1958497392: {
                if (string.equals("eth_sendTransaction")) {
                    n = 32;
                }
                break;
            }
            case 618765750: {
                if (string.equals("eth_mining")) {
                    n = 33;
                }
                break;
            }
            case 133838626: {
                if (string.equals("eth_getBlockByHash")) {
                    n = 34;
                }
                break;
            }
            case -1584133300: {
                if (string.equals("eth_getTransactionByBlockNumberAndIndex")) {
                    n = 35;
                }
                break;
            }
            case 1150296012: {
                if (string.equals("eth_accounts")) {
                    n = 36;
                }
                break;
            }
            case 301949089: {
                if (string.equals("eth_getTransactionCount")) {
                    n = 37;
                }
                break;
            }
            case -1760238262: {
                if (string.equals("eth_getTransactionReceipt")) {
                    n = 38;
                }
                break;
            }
            case 861707709: {
                if (string.equals("eth_getCode")) {
                    n = 39;
                }
                break;
            }
            case 592347307: {
                if (string.equals("net_peerCount")) {
                    n = 40;
                }
                break;
            }
            case -1936115329: {
                if (string.equals("db_putString")) {
                    n = 41;
                }
                break;
            }
            case -1200064368: {
                if (string.equals("eth_blockNumber")) {
                    n = 42;
                }
                break;
            }
            case -427301652: {
                if (string.equals("eth_getUncleByBlockHashAndIndex")) {
                    n = 43;
                }
                break;
            }
            case -1974885468: {
                if (string.equals("eth_sendRawTransaction")) {
                    n = 44;
                }
                break;
            }
            case -1166103284: {
                if (string.equals("eth_getBalance")) {
                    n = 45;
                }
                break;
            }
            case 734363702: {
                if (string.equals("net_version")) {
                    n = 46;
                }
                break;
            }
            case 1408844428: {
                if (string.equals("eth_submitHashrate")) {
                    n = 47;
                }
                break;
            }
            case 1671558614: {
                if (string.equals("eth_gasPrice")) {
                    n = 48;
                }
                break;
            }
            case 1590233662: {
                if (string.equals("eth_getStorageAt")) {
                    n = 49;
                }
                break;
            }
            case 616818489: {
                if (string.equals("eth_newPendingTransactionFilter")) {
                    n = 50;
                }
                break;
            }
            case 1810087455: {
                if (string.equals("eth_compileLLL")) {
                    n = 51;
                }
                break;
            }
            case 195973459: {
                if (string.equals("eth_getBlockTransactionCountByHash")) {
                    n = 52;
                }
                break;
            }
            case -458002866: {
                if (string.equals("eth_getBlockTransactionCountByNumber")) {
                    n = 53;
                }
                break;
            }
        }
        switch (n) {
            case 26: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 14: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 10: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 29: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 41: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 36: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 42: {
                Response<String> response = this.ethBlockNumber();
                return response;
            }
            case 30: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethCall(list);
                return response;
            }
            case 7: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 51: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 24: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 8: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 5: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.estimateGas(list);
                return response;
            }
            case 48: {
                Response<String> response = this.ethGasPrice();
                return response;
            }
            case 45: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethGetBalance(list);
                return response;
            }
            case 34: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethBlockByHash(list);
                return response;
            }
            case 21: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethBlockByNumber(list);
                return response;
            }
            case 52: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethGetBlockTransactionCountByHash(list);
                return response;
            }
            case 53: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethGetBlockTransactionCountByNumber(list);
                return response;
            }
            case 39: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethGetCode(list);
                return response;
            }
            case 20: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 22: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 17: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 13: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 49: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 31: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 35: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 3: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 37: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethGetTransactionCount(list);
                return response;
            }
            case 38: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethGetTransactionReceipt(list);
                return response;
            }
            case 43: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 2: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 25: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 27: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 4: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 1: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 33: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 16: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 11: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 50: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 6: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 44: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethSendRawTransaction(list);
                return response;
            }
            case 32: {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParams(...)");
                Response<String> response = this.ethSendTransaction(list);
                return response;
            }
            case 18: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 47: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 9: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 23: {
                Response<String> response = this.ethSyncing();
                return response;
            }
            case 28: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 19: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 40: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            case 46: {
                Response<String> response = this.netVersion();
                return response;
            }
            case 12: {
                Response<String> response = this.web3ClientVersion();
                return response;
            }
            case 15: {
                throw new UnsupportedOperationException(request.getMethod());
            }
            default: {
                throw new UnsupportedOperationException(request.getMethod());
            }
        }
    }

    private final Response<String> web3ClientVersion() {
        return (Response)new Web3ClientVersion(){

            @NotNull
            public String getResult() {
                String string = Numeric.encodeQuantity((BigInteger)BigInteger.ONE);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeQuantity(...)");
                return string;
            }
        };
    }

    private final Response<String> netVersion() {
        return (Response)new NetVersion(){

            @NotNull
            public String getResult() {
                String string = Numeric.encodeQuantity((BigInteger)BigInteger.ONE);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeQuantity(...)");
                return string;
            }
        };
    }

    private final Response<String> ethGasPrice() {
        return (Response)new EthGasPrice(){

            @NotNull
            public String getResult() {
                String string = Numeric.encodeQuantity((BigInteger)BigInteger.ONE);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeQuantity(...)");
                return string;
            }
        };
    }

    private final Response<String> ethGetTransactionCount(List<? extends Object> params) {
        Address address = new Address(params.get(0).toString());
        String result2 = Numeric.encodeQuantity((BigInteger)this.embeddedEthereum.getTransactionCount(address));
        return (Response)new EthGetTransactionCount(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                String string = this.$result;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$result");
                return string;
            }
        };
    }

    private final Response<String> ethSendTransaction(List<? extends Object> params) {
        Object object = params.get(0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.web3j.protocol.core.methods.request.Transaction");
        Transaction transaction = (Transaction)object;
        String result2 = this.embeddedEthereum.processTransaction(transaction);
        return (Response)new EthSendTransaction(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> ethSendRawTransaction(List<? extends Object> params) {
        Object object = params.get(0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String signedTransactionData = (String)object;
        String result2 = this.embeddedEthereum.processTransaction(signedTransactionData);
        return (Response)new EthSendTransaction(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<TransactionReceipt> ethGetTransactionReceipt(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        String transactionHash = (String)obj;
        TransactionReceipt result2 = this.embeddedEthereum.getTransactionReceipt(transactionHash);
        return (Response)new EthGetTransactionReceipt(result2){
            final /* synthetic */ TransactionReceipt $result;
            {
                this.$result = $result;
            }

            @Nullable
            public TransactionReceipt getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> ethCall(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.web3j.protocol.core.methods.request.Transaction");
        Transaction transaction = (Transaction)obj;
        String result2 = this.embeddedEthereum.ethCall(transaction);
        return (Response)new EthCall(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> estimateGas(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.web3j.protocol.core.methods.request.Transaction");
        Transaction transaction = (Transaction)obj;
        String result2 = this.embeddedEthereum.estimateGas(transaction);
        return (Response)new EthEstimateGas(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> ethBlockNumber() {
        String result2 = this.embeddedEthereum.ethBlockNumber();
        return (Response)new EthBlockNumber(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> ethGetBalance(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        String address = (String)obj;
        Object obj2 = params.get(1);
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.String");
        String defaultBlockParameter = (String)obj2;
        String result2 = this.embeddedEthereum.ethGetBalance(new Address(address), defaultBlockParameter);
        return (Response)new EthGetBalance(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @Nullable
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<EthBlock.Block> ethBlockByHash(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        String hash = (String)obj;
        Object obj2 = params.get(1);
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean fullTransactionObjects = (Boolean)obj2;
        EthBlock.Block result2 = this.embeddedEthereum.ethBlockByHash(hash, fullTransactionObjects);
        return (Response)new EthBlock(result2){
            final /* synthetic */ EthBlock.Block $result;
            {
                this.$result = $result;
            }

            @Nullable
            public EthBlock.Block getResult() {
                return this.$result;
            }
        };
    }

    private final Response<EthBlock.Block> ethBlockByNumber(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        String blockNumber = (String)obj;
        Object obj2 = params.get(1);
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean fullTransactionObjects = (Boolean)obj2;
        EthBlock.Block result2 = this.embeddedEthereum.ethBlockByNumber(blockNumber, fullTransactionObjects);
        return (Response)new EthBlock(result2){
            final /* synthetic */ EthBlock.Block $result;
            {
                this.$result = $result;
            }

            @Nullable
            public EthBlock.Block getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> ethGetBlockTransactionCountByHash(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        String blockHash = (String)obj;
        Hash hash = Hash.fromHexString((String)blockHash);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"fromHexString(...)");
        String result2 = this.embeddedEthereum.ethGetBlockTransactionCountByHash(hash);
        return (Response)new EthGetBlockTransactionCountByHash(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> ethGetCode(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        String address = (String)obj;
        Object obj2 = params.get(1);
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.String");
        String defaultBlockParameter = (String)obj2;
        String result2 = this.embeddedEthereum.ethGetCode(new Address(address), defaultBlockParameter);
        return (Response)new EthGetCode(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<String> ethGetBlockTransactionCountByNumber(List<?> params) {
        Object obj = params.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
        BigInteger blockNumber = Numeric.decodeQuantity((String)((String)obj));
        String result2 = this.embeddedEthereum.ethGetBlockTransactionCountByNumber(blockNumber.longValue());
        return (Response)new EthGetBlockTransactionCountByNumber(result2){
            final /* synthetic */ String $result;
            {
                this.$result = $result;
            }

            @NotNull
            public String getResult() {
                return this.$result;
            }
        };
    }

    private final Response<EthSyncing.Result> ethSyncing() {
        return (Response)new EthSyncing(){

            @NotNull
            public EthSyncing.Result getResult() {
                EthSyncing.Result result2;
                EthSyncing.Result $this$getResult_u24lambda_u240 = result2 = new EthSyncing.Result();
                boolean bl = false;
                $this$getResult_u24lambda_u240.setSyncing(true);
                return result2;
            }
        };
    }

    @NotNull
    public BatchResponse sendBatch(@Nullable BatchRequest p0) {
        throw new UnsupportedOperationException("Batch send is not supported");
    }

    @NotNull
    public CompletableFuture<BatchResponse> sendBatchAsync(@Nullable BatchRequest p0) {
        throw new UnsupportedOperationException("Batch send is not supported");
    }

    @NotNull
    public <T extends Response<?>> CompletableFuture<T> sendAsync(@NotNull Request<?, ?> request, @NotNull Class<T> responseType) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        CompletableFuture completableFuture = Async.run(() -> EmbeddedWeb3jService.sendAsync$lambda$0(this, request, responseType));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"run(...)");
        return completableFuture;
    }

    @NotNull
    public <T extends Notification<?>> Flowable<T> subscribe(@NotNull Request<?, ?> request, @NotNull String unsubscribeMethod, @NotNull Class<T> responseType) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)unsubscribeMethod, (String)"unsubscribeMethod");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        String string = "Service %s does not support subscriptions";
        Object[] objectArray = new Object[]{this.getClass().getSimpleName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        throw new UnsupportedOperationException(string2);
    }

    public void close() throws IOException {
    }

    private static final Response sendAsync$lambda$0(EmbeddedWeb3jService this$0, Request $request, Class $responseType) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$responseType, (String)"$responseType");
        return this$0.send($request, $responseType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/web3j/evm/EmbeddedWeb3jService$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "web3j-evm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

