/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import com.google.common.io.Resources;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.cli.config.EthNetworkConfig;
import org.hyperledger.besu.cli.config.NetworkName;
import org.hyperledger.besu.config.GenesisConfigFile;
import org.hyperledger.besu.config.GenesisConfigOptions;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.BlockResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.BlockResultFactory;
import org.hyperledger.besu.ethereum.api.query.BlockWithMetadata;
import org.hyperledger.besu.ethereum.api.query.BlockchainQueries;
import org.hyperledger.besu.ethereum.api.query.TransactionWithMetadata;
import org.hyperledger.besu.ethereum.chain.Blockchain;
import org.hyperledger.besu.ethereum.chain.BlockchainStorage;
import org.hyperledger.besu.ethereum.chain.DefaultBlockchain;
import org.hyperledger.besu.ethereum.chain.GenesisState;
import org.hyperledger.besu.ethereum.chain.MutableBlockchain;
import org.hyperledger.besu.ethereum.chain.VariablesStorage;
import org.hyperledger.besu.ethereum.core.Block;
import org.hyperledger.besu.ethereum.core.BlockBody;
import org.hyperledger.besu.ethereum.core.BlockHeader;
import org.hyperledger.besu.ethereum.core.BlockHeaderBuilder;
import org.hyperledger.besu.ethereum.core.BlockHeaderFunctions;
import org.hyperledger.besu.ethereum.core.Difficulty;
import org.hyperledger.besu.ethereum.core.MutableWorldState;
import org.hyperledger.besu.ethereum.core.PrivacyParameters;
import org.hyperledger.besu.ethereum.core.ProcessableBlockHeader;
import org.hyperledger.besu.ethereum.core.SealableBlockHeader;
import org.hyperledger.besu.ethereum.core.Transaction;
import org.hyperledger.besu.ethereum.core.TransactionReceipt;
import org.hyperledger.besu.ethereum.mainnet.AbstractBlockProcessor;
import org.hyperledger.besu.ethereum.mainnet.BodyValidation;
import org.hyperledger.besu.ethereum.mainnet.MainnetBlockHeaderFunctions;
import org.hyperledger.besu.ethereum.mainnet.MainnetProtocolSchedule;
import org.hyperledger.besu.ethereum.mainnet.MainnetTransactionProcessor;
import org.hyperledger.besu.ethereum.mainnet.ProtocolSchedule;
import org.hyperledger.besu.ethereum.mainnet.ProtocolSpec;
import org.hyperledger.besu.ethereum.mainnet.ScheduleBasedBlockHeaderFunctions;
import org.hyperledger.besu.ethereum.processing.TransactionProcessingResult;
import org.hyperledger.besu.ethereum.storage.keyvalue.KeyValueStoragePrefixedKeyBlockchainStorage;
import org.hyperledger.besu.ethereum.storage.keyvalue.VariablesKeyValueStorage;
import org.hyperledger.besu.ethereum.storage.keyvalue.WorldStatePreimageKeyValueStorage;
import org.hyperledger.besu.ethereum.transaction.CallParameter;
import org.hyperledger.besu.ethereum.transaction.TransactionSimulator;
import org.hyperledger.besu.ethereum.transaction.TransactionSimulatorResult;
import org.hyperledger.besu.ethereum.trie.forest.ForestWorldStateArchive;
import org.hyperledger.besu.ethereum.trie.forest.storage.ForestWorldStateKeyValueStorage;
import org.hyperledger.besu.ethereum.vm.BlockHashLookup;
import org.hyperledger.besu.ethereum.vm.CachingBlockHashLookup;
import org.hyperledger.besu.ethereum.worldstate.WorldStateArchive;
import org.hyperledger.besu.ethereum.worldstate.WorldStatePreimageStorage;
import org.hyperledger.besu.ethereum.worldstate.WorldStateStorage;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.hyperledger.besu.evm.worldstate.WorldState;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;
import org.hyperledger.besu.metrics.noop.NoOpMetricsSystem;
import org.hyperledger.besu.plugin.services.MetricsSystem;
import org.hyperledger.besu.plugin.services.storage.KeyValueStorage;
import org.hyperledger.besu.services.kvstore.InMemoryKeyValueStorage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.evm.Configuration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 >2\u00020\u0001:\u0001>B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+J\n\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020/0(2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020/0(2\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0018\u0010;\u001a\u00020<2\u0006\u0010!\u001a\u00020\"2\u0006\u0010=\u001a\u00020\u001bH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/web3j/evm/InMemoryBesuChain;", "", "configuration", "Lorg/web3j/evm/Configuration;", "operationTracer", "Lorg/hyperledger/besu/evm/tracing/OperationTracer;", "networkName", "Lorg/hyperledger/besu/cli/config/NetworkName;", "genesisConfigOverrides", "", "", "(Lorg/web3j/evm/Configuration;Lorg/hyperledger/besu/evm/tracing/OperationTracer;Lorg/hyperledger/besu/cli/config/NetworkName;Ljava/util/Map;)V", "blockChain", "Lorg/hyperledger/besu/ethereum/chain/MutableBlockchain;", "blockResultFactory", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/BlockResultFactory;", "blockchainQueries", "Lorg/hyperledger/besu/ethereum/api/query/BlockchainQueries;", "getBlockchainQueries", "()Lorg/hyperledger/besu/ethereum/api/query/BlockchainQueries;", "chainId", "Ljava/math/BigInteger;", "getChainId", "()Ljava/math/BigInteger;", "genesisState", "Lorg/hyperledger/besu/ethereum/chain/GenesisState;", "miningBeneficiary", "Lorg/hyperledger/besu/datatypes/Address;", "kotlin.jvm.PlatformType", "protocolSchedule", "Lorg/hyperledger/besu/ethereum/mainnet/ProtocolSchedule;", "simulator", "Lorg/hyperledger/besu/ethereum/transaction/TransactionSimulator;", "worldState", "Lorg/hyperledger/besu/ethereum/core/MutableWorldState;", "worldStateArchive", "Lorg/hyperledger/besu/ethereum/worldstate/WorldStateArchive;", "worldStateUpdater", "Lorg/hyperledger/besu/evm/worldstate/WorldUpdater;", "call", "Ljava/util/Optional;", "Lorg/hyperledger/besu/ethereum/transaction/TransactionSimulatorResult;", "callParameter", "Lorg/hyperledger/besu/ethereum/transaction/CallParameter;", "createPendingBlockHeader", "Lorg/hyperledger/besu/ethereum/core/ProcessableBlockHeader;", "ethBlockByHash", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/BlockResult;", "hash", "Lorg/hyperledger/besu/datatypes/Hash;", "completeTransaction", "", "ethBlockByNumber", "number", "", "processTransaction", "Lorg/hyperledger/besu/ethereum/core/TransactionReceipt;", "transaction", "Lorg/hyperledger/besu/ethereum/core/Transaction;", "rewardMiner", "", "coinbaseAddress", "Companion", "web3j-evm"})
public final class InMemoryBesuChain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OperationTracer operationTracer;
    @NotNull
    private final BigInteger chainId;
    @NotNull
    private final BlockchainQueries blockchainQueries;
    @NotNull
    private final GenesisState genesisState;
    private final Address miningBeneficiary;
    @NotNull
    private final BlockResultFactory blockResultFactory;
    @NotNull
    private final MutableWorldState worldState;
    @NotNull
    private final WorldStateArchive worldStateArchive;
    @NotNull
    private final WorldUpdater worldStateUpdater;
    @NotNull
    private final ProtocolSchedule protocolSchedule;
    @NotNull
    private final MutableBlockchain blockChain;
    @NotNull
    private final TransactionSimulator simulator;
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryBesuChain.class);
    @NotNull
    private static final Map<String, String> DEFAULT_GENESIS_OVERRIDES;

    public InMemoryBesuChain(@NotNull Configuration configuration, @NotNull OperationTracer operationTracer, @NotNull NetworkName networkName, @NotNull Map<String, String> genesisConfigOverrides) {
        GenesisConfigFile genesisConfigFile;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)operationTracer, (String)"operationTracer");
        Intrinsics.checkNotNullParameter((Object)networkName, (String)"networkName");
        Intrinsics.checkNotNullParameter(genesisConfigOverrides, (String)"genesisConfigOverrides");
        this.operationTracer = operationTracer;
        this.miningBeneficiary = Address.ZERO;
        this.blockResultFactory = new BlockResultFactory();
        if (configuration.getGenesisFileUrl() == null) {
            EthNetworkConfig networkConfig = EthNetworkConfig.getNetworkConfig((NetworkName)networkName);
            genesisConfigFile = GenesisConfigFile.fromConfig((String)networkConfig.getGenesisConfig());
        } else {
            genesisConfigFile = GenesisConfigFile.fromConfig((String)Resources.toString((URL)configuration.getGenesisFileUrl(), (Charset)StandardCharsets.UTF_8));
        }
        GenesisConfigFile genesisConfig = genesisConfigFile;
        GenesisConfigOptions configOptions = genesisConfig.getConfigOptions(genesisConfigOverrides);
        ProtocolSchedule protocolSchedule = MainnetProtocolSchedule.fromConfig((GenesisConfigOptions)configOptions, (PrivacyParameters)PrivacyParameters.DEFAULT, (boolean)true, (EvmConfiguration)EvmConfiguration.DEFAULT);
        Intrinsics.checkNotNullExpressionValue((Object)protocolSchedule, (String)"fromConfig(...)");
        this.protocolSchedule = protocolSchedule;
        InMemoryKeyValueStorage keyValueStorage = new InMemoryKeyValueStorage();
        VariablesKeyValueStorage variablesStorage = new VariablesKeyValueStorage((KeyValueStorage)keyValueStorage);
        KeyValueStoragePrefixedKeyBlockchainStorage blockchainStorage = new KeyValueStoragePrefixedKeyBlockchainStorage((KeyValueStorage)keyValueStorage, (VariablesStorage)variablesStorage, (BlockHeaderFunctions)new MainnetBlockHeaderFunctions());
        ForestWorldStateKeyValueStorage worldStateStorage = new ForestWorldStateKeyValueStorage((KeyValueStorage)new InMemoryKeyValueStorage());
        WorldStatePreimageKeyValueStorage worldStatePreimageStorage = new WorldStatePreimageKeyValueStorage((KeyValueStorage)new InMemoryKeyValueStorage());
        this.worldStateArchive = (WorldStateArchive)new ForestWorldStateArchive((WorldStateStorage)worldStateStorage, (WorldStatePreimageStorage)worldStatePreimageStorage, EvmConfiguration.DEFAULT);
        MutableWorldState mutableWorldState = ((ForestWorldStateArchive)this.worldStateArchive).getMutable();
        Intrinsics.checkNotNullExpressionValue((Object)mutableWorldState, (String)"getMutable(...)");
        this.worldState = mutableWorldState;
        WorldUpdater worldUpdater = this.worldState.updater();
        Intrinsics.checkNotNullExpressionValue((Object)worldUpdater, (String)"updater(...)");
        this.worldStateUpdater = worldUpdater;
        GenesisState genesisState = GenesisState.fromConfig((GenesisConfigFile)genesisConfig, (ProtocolSchedule)this.protocolSchedule);
        Intrinsics.checkNotNullExpressionValue((Object)genesisState, (String)"fromConfig(...)");
        this.genesisState = genesisState;
        this.genesisState.writeStateTo(this.worldState);
        LOG.debug("Genesis Block Hash: " + this.genesisState.getBlock().getHash());
        MutableBlockchain mutableBlockchain = DefaultBlockchain.createMutable((Block)this.genesisState.getBlock(), (BlockchainStorage)((BlockchainStorage)blockchainStorage), (MetricsSystem)((MetricsSystem)new NoOpMetricsSystem()), (long)0L);
        Intrinsics.checkNotNullExpressionValue((Object)mutableBlockchain, (String)"createMutable(...)");
        this.blockChain = mutableBlockchain;
        LOG.debug("Allocating test account " + configuration.getTestAddress());
        this.worldStateUpdater.createAccount(Address.fromHexString((String)configuration.getTestAddress()), 0L, Wei.fromEth((long)configuration.getEthFund()));
        this.worldStateUpdater.commit();
        this.blockchainQueries = new BlockchainQueries((Blockchain)this.blockChain, this.worldStateArchive);
        BigInteger bigInteger = this.protocolSchedule.getChainId().orElse(BigInteger.ONE);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"orElse(...)");
        this.chainId = bigInteger;
        this.simulator = new TransactionSimulator((Blockchain)this.blockChain, this.worldStateArchive, this.protocolSchedule, 0L);
    }

    public /* synthetic */ InMemoryBesuChain(Configuration configuration, OperationTracer operationTracer, NetworkName networkName, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            networkName = NetworkName.DEV;
        }
        if ((n & 8) != 0) {
            map = DEFAULT_GENESIS_OVERRIDES;
        }
        this(configuration, operationTracer, networkName, map);
    }

    @NotNull
    public final BigInteger getChainId() {
        return this.chainId;
    }

    @NotNull
    public final BlockchainQueries getBlockchainQueries() {
        return this.blockchainQueries;
    }

    @NotNull
    public final TransactionReceipt processTransaction(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BlockHeader headHeader = this.blockChain.getChainHeadHeader();
        ProtocolSpec spec = this.protocolSchedule.getForNextBlockHeader(headHeader, headHeader.getTimestamp());
        MainnetTransactionProcessor transactionProcessor = spec.getTransactionProcessor();
        AbstractBlockProcessor.TransactionReceiptFactory transactionReceiptFactory = spec.getTransactionReceiptFactory();
        List transactions = CollectionsKt.listOf((Object)transaction);
        ProcessableBlockHeader processableBlockHeader = this.createPendingBlockHeader();
        CachingBlockHashLookup blockHashLookup = new CachingBlockHashLookup(processableBlockHeader, (Blockchain)this.blockChain);
        TransactionProcessingResult result2 = transactionProcessor.processTransaction((Blockchain)this.blockChain, this.worldStateUpdater, processableBlockHeader, transaction, this.miningBeneficiary, this.operationTracer, (BlockHashLookup)blockHashLookup, Boolean.valueOf(true), Wei.MAX_WEI);
        if (result2.isInvalid()) {
            throw new Exception(result2.getValidationResult().getErrorMessage());
        }
        this.worldStateUpdater.commit();
        Address address = this.miningBeneficiary;
        Intrinsics.checkNotNullExpressionValue((Object)address, (String)"miningBeneficiary");
        this.rewardMiner(this.worldState, address);
        long gasUsed = result2.getEstimateGasUsedByTransaction();
        TransactionReceipt transactionReceipt = transactionReceiptFactory.create(transaction.getType(), result2, (WorldState)this.worldState, gasUsed);
        List receipts = CollectionsKt.listOf((Object)transactionReceipt);
        SealableBlockHeader sealableBlockHeader = BlockHeaderBuilder.create().populateFrom(processableBlockHeader).ommersHash(Hash.EMPTY_LIST_HASH).stateRoot(this.worldState.rootHash()).transactionsRoot(BodyValidation.transactionsRoot((List)transactions)).receiptsRoot(BodyValidation.receiptsRoot((List)receipts)).logsBloom(BodyValidation.logsBloom((List)receipts)).gasUsed(gasUsed).extraData(Bytes.EMPTY).buildSealableBlockHeader();
        BlockHeaderFunctions blockHeaderFunctions = ScheduleBasedBlockHeaderFunctions.create((ProtocolSchedule)this.protocolSchedule);
        BlockHeader blockHeader = BlockHeaderBuilder.create().populateFrom(sealableBlockHeader).nonce(this.blockChain.getChainHeadHeader().getNonce() + 1L).mixHash(Hash.ZERO).blockHeaderFunctions(blockHeaderFunctions).buildBlockHeader();
        Block block = new Block(blockHeader, new BlockBody(transactions, CollectionsKt.emptyList()));
        this.worldState.persist(blockHeader);
        this.blockChain.appendBlock(block, receipts);
        Intrinsics.checkNotNull((Object)transactionReceipt);
        return transactionReceipt;
    }

    private final ProcessableBlockHeader createPendingBlockHeader() {
        BlockHeader parentHeader = this.blockChain.getChainHeadHeader();
        long newBlockNumber = parentHeader.getNumber() + 1L;
        return BlockHeaderBuilder.create().parentHash(parentHeader.getHash()).coinbase(this.miningBeneficiary).difficulty((Difficulty)parentHeader.getDifficulty().plus(100000L)).number(newBlockNumber).gasLimit(parentHeader.getGasLimit()).timestamp(System.currentTimeMillis()).baseFee(parentHeader.getBaseFee().orElse(Wei.ZERO)).buildProcessableBlockHeader();
    }

    @NotNull
    public final Optional<TransactionSimulatorResult> call(@NotNull CallParameter callParameter) {
        Intrinsics.checkNotNullParameter((Object)callParameter, (String)"callParameter");
        Optional optional = this.simulator.processAtHead(callParameter);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"processAtHead(...)");
        return optional;
    }

    @NotNull
    public final Optional<BlockResult> ethBlockByHash(@NotNull Hash hash, boolean completeTransaction) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        if (completeTransaction) {
            Optional<BlockResult> optional = this.blockchainQueries.blockByHash(hash).map(arg_0 -> InMemoryBesuChain.ethBlockByHash$lambda$0((Function1)new Function1<BlockWithMetadata<TransactionWithMetadata, Hash>, BlockResult>(this){
                final /* synthetic */ InMemoryBesuChain this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final BlockResult invoke(BlockWithMetadata<TransactionWithMetadata, Hash> tx) {
                    return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionComplete(tx);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
            return optional;
        }
        Optional<BlockResult> optional = this.blockchainQueries.blockByHashWithTxHashes(hash).map(arg_0 -> InMemoryBesuChain.ethBlockByHash$lambda$1((Function1)new Function1<BlockWithMetadata<Hash, Hash>, BlockResult>(this){
            final /* synthetic */ InMemoryBesuChain this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final BlockResult invoke(BlockWithMetadata<Hash, Hash> tx) {
                return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionHash(tx);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @NotNull
    public final Optional<BlockResult> ethBlockByNumber(long number, boolean completeTransaction) {
        if (completeTransaction) {
            Optional<BlockResult> optional = this.blockchainQueries.blockByNumber(number).map(arg_0 -> InMemoryBesuChain.ethBlockByNumber$lambda$2((Function1)new Function1<BlockWithMetadata<TransactionWithMetadata, Hash>, BlockResult>(this){
                final /* synthetic */ InMemoryBesuChain this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final BlockResult invoke(BlockWithMetadata<TransactionWithMetadata, Hash> tx) {
                    return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionComplete(tx);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
            return optional;
        }
        Optional<BlockResult> optional = this.blockchainQueries.blockByNumberWithTxHashes(number).map(arg_0 -> InMemoryBesuChain.ethBlockByNumber$lambda$3((Function1)new Function1<BlockWithMetadata<Hash, Hash>, BlockResult>(this){
            final /* synthetic */ InMemoryBesuChain this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final BlockResult invoke(BlockWithMetadata<Hash, Hash> tx) {
                return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionHash(tx);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    private final void rewardMiner(MutableWorldState worldState, Address coinbaseAddress) {
        ProtocolSpec spec = this.protocolSchedule.getByBlockHeader((ProcessableBlockHeader)this.blockChain.getChainHeadHeader());
        Wei wei = spec.getBlockReward();
        Intrinsics.checkNotNullExpressionValue((Object)wei, (String)"getBlockReward(...)");
        Wei coinbaseReward = wei;
        WorldUpdater updater = worldState.updater();
        MutableAccount coinbase = updater.getOrCreate(coinbaseAddress);
        coinbase.incrementBalance(coinbaseReward);
        updater.commit();
    }

    private static final BlockResult ethBlockByHash$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BlockResult)$tmp0.invoke(p0);
    }

    private static final BlockResult ethBlockByHash$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BlockResult)$tmp0.invoke(p0);
    }

    private static final BlockResult ethBlockByNumber$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BlockResult)$tmp0.invoke(p0);
    }

    private static final BlockResult ethBlockByNumber$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BlockResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BlockResultFactory access$getBlockResultFactory$p(InMemoryBesuChain $this) {
        return $this.blockResultFactory;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"londonblock", (Object)"1"), TuplesKt.to((Object)"petersburgblock", (Object)"0")};
        DEFAULT_GENESIS_OVERRIDES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/web3j/evm/InMemoryBesuChain$Companion;", "", "()V", "DEFAULT_GENESIS_OVERRIDES", "", "", "getDEFAULT_GENESIS_OVERRIDES$web3j_evm", "()Ljava/util/Map;", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "web3j-evm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getDEFAULT_GENESIS_OVERRIDES$web3j_evm() {
            return DEFAULT_GENESIS_OVERRIDES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

