/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.evm.ConsoleDebugTracer;
import org.web3j.evm.ExceptionalHaltException;
import org.web3j.evm.PassthroughTracerContext;
import org.web3j.evm.entity.source.SourceFile;
import org.web3j.evm.entity.source.SourceLine;
import org.web3j.evm.entity.source.SourceMapElement;
import org.web3j.evm.utils.NullReader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/web3j/evm/PassthroughTracer;", "Lorg/web3j/evm/ConsoleDebugTracer;", "metaFile", "Ljava/io/File;", "(Ljava/io/File;)V", "passthroughTracerContext", "Lorg/web3j/evm/PassthroughTracerContext;", "lastContext", "resetContext", "", "traceExecution", "messageFrame", "Lorg/hyperledger/besu/evm/frame/MessageFrame;", "evm", "Lorg/hyperledger/besu/evm/EVM;", "executeOperation", "Lorg/hyperledger/besu/evm/operation/Operation;", "web3j-evm"})
@SourceDebugExtension(value={"SMAP\nPassthroughTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PassthroughTracer.kt\norg/web3j/evm/PassthroughTracer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n748#2,10:79\n748#2,10:89\n766#2:99\n857#2,2:100\n1549#2:102\n1620#2,3:103\n*S KotlinDebug\n*F\n+ 1 PassthroughTracer.kt\norg/web3j/evm/PassthroughTracer\n*L\n59#1:79,10\n61#1:89,10\n68#1:99\n68#1:100,2\n68#1:102\n68#1:103,3\n*E\n"})
public final class PassthroughTracer
extends ConsoleDebugTracer {
    @NotNull
    private PassthroughTracerContext passthroughTracerContext;

    public PassthroughTracer(@Nullable File metaFile) {
        super(metaFile, new BufferedReader(new NullReader()));
        this.passthroughTracerContext = new PassthroughTracerContext(null, null, null, null, 15, null);
    }

    public /* synthetic */ PassthroughTracer(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = new File("build/resources/main/solidity");
        }
        this(file);
    }

    @NotNull
    public final PassthroughTracerContext lastContext() {
        return this.passthroughTracerContext;
    }

    public final void resetContext() {
        this.passthroughTracerContext = new PassthroughTracerContext(null, null, null, null, 15, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void traceExecution(@NotNull MessageFrame messageFrame, @NotNull EVM evm, @NotNull Operation executeOperation) throws ExceptionalHaltException {
        Intrinsics.checkNotNullParameter((Object)messageFrame, (String)"messageFrame");
        Intrinsics.checkNotNullParameter((Object)evm, (String)"evm");
        Intrinsics.checkNotNullParameter((Object)executeOperation, (String)"executeOperation");
        if (this.getMetaFile() != null && this.getMetaFile().exists()) {
            PassthroughTracerContext passthroughTracerContext;
            String it;
            Iterable $this$dropWhile$iv;
            Pair<SourceMapElement, SourceFile> pair = this.sourceAtMessageFrame(messageFrame);
            SourceMapElement sourceMapElement = (SourceMapElement)pair.component1();
            SourceFile sourceFile = (SourceFile)pair.component2();
            String filePath = sourceFile.component1();
            SortedMap<Integer, SourceLine> sourceSection = sourceFile.component2();
            StringBuilder sb = new StringBuilder();
            if (sourceMapElement != null) {
                sb.append("At solidity source location " + sourceMapElement.getSourceFileByteOffset() + ":" + sourceMapElement.getLengthOfSourceRange() + ":" + sourceMapElement.getSourceIndex() + ":");
            } else {
                sb.append("At unknown solidity source location:");
            }
            sb.append('\n');
            sb.append('\n');
            Iterable iterable = this.mergeSourceContent(sourceSection);
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            $this$dropWhile$iv = CollectionsKt.reversed((Iterable)list$iv);
            $i$f$dropWhile = false;
            yielding$iv = false;
            list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List trimmedSourceSection = CollectionsKt.reversed((Iterable)list$iv);
            PassthroughTracer passthroughTracer = this;
            if (trimmedSourceSection.isEmpty()) {
                passthroughTracerContext = new PassthroughTracerContext(null, null, null, null, 15, null);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map.Entry it2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                String string = sb.append(CollectionsKt.joinToString$default((Iterable)trimmedSourceSection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String source = string;
                Set<Map.Entry<Integer, SourceLine>> set = sourceSection.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                Iterable yielding$iv2 = set;
                PassthroughTracer passthroughTracer2 = passthroughTracer;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!((SourceLine)it2.getValue()).getSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Integer)it2.getKey());
                }
                passthroughTracer = passthroughTracer2;
                Integer firstSelectedLine = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
                SourceLine sourceLine = (SourceLine)sourceSection.get(firstSelectedLine);
                Integer firstSelectedOffset = sourceLine != null ? Integer.valueOf(sourceLine.getOffset()) : null;
                passthroughTracerContext = new PassthroughTracerContext(source, filePath, firstSelectedLine, firstSelectedOffset);
            }
            passthroughTracer.passthroughTracerContext = passthroughTracerContext;
        }
        executeOperation.execute(messageFrame, evm);
    }

    public PassthroughTracer() {
        this(null, 1, null);
    }
}

