/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.sokt;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.web3j.sokt.SolcArguments;
import org.web3j.sokt.SolcInstance;
import org.web3j.sokt.SolcOutput;
import org.web3j.sokt.SolcRelease;
import org.web3j.sokt.SolidityFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\t\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0007J\f\u0010\u001b\u001a\u00020\u0014*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/web3j/sokt/SolcInstance;", "", "solcRelease", "Lorg/web3j/sokt/SolcRelease;", "directoryPath", "", "redirectOutput", "", "sourceFiles", "", "Lorg/web3j/sokt/SolidityFile;", "(Lorg/web3j/sokt/SolcRelease;Ljava/lang/String;Z[Lorg/web3j/sokt/SolidityFile;)V", "solcFile", "Ljava/io/File;", "getSolcFile", "()Ljava/io/File;", "getSolcRelease", "()Lorg/web3j/sokt/SolcRelease;", "[Lorg/web3j/sokt/SolidityFile;", "execute", "Lorg/web3j/sokt/SolcOutput;", "args", "Lorg/web3j/sokt/SolcArguments;", "([Lorg/web3j/sokt/SolcArguments;)Lorg/web3j/sokt/SolcOutput;", "install", "installed", "uninstall", "runCommand", "web3j-sokt"})
public final class SolcInstance {
    @NotNull
    private final File solcFile;
    @NotNull
    private final SolcRelease solcRelease;
    private final String directoryPath;
    private final boolean redirectOutput;
    private final SolidityFile[] sourceFiles;

    @NotNull
    public final File getSolcFile() {
        return this.solcFile;
    }

    public final boolean installed() {
        return this.solcFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean install() {
        String string = "Solidity version " + this.solcRelease.getVersion() + " is not installed. Downloading and installing it to ~/" + this.directoryPath + "/solc/" + this.solcRelease.getVersion();
        boolean bl = false;
        System.out.println((Object)string);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.solcFile.getParentFile().mkdirs();
            if (this.solcRelease.getVersion().compareTo("0.7.1") > 0) {
                FilesKt.writeBytes((File)this.solcFile, (byte[])TextStreamsKt.readBytes((URL)new URL(this.solcRelease.getWindowsUrl())));
                if (this.installed()) {
                    this.solcFile.setExecutable(true);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.solcFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"solcFile.absolutePath");
                File winDownloadFile = new File(stringBuilder.append(StringsKt.dropLast((String)string2, (int)4)).append(".zip").toString());
                FilesKt.writeBytes((File)winDownloadFile, (byte[])TextStreamsKt.readBytes((URL)new URL(this.solcRelease.getWindowsUrl())));
                Closeable closeable = new ZipFile(winDownloadFile);
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ZipFile zip = (ZipFile)closeable;
                    boolean bl3 = false;
                    Enumeration<? extends ZipEntry> enumeration = zip.entries();
                    Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zip.entries()");
                    Enumeration<? extends ZipEntry> enumeration2 = enumeration;
                    boolean bl4 = false;
                    Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ZipEntry entry = (ZipEntry)element$iv;
                        boolean bl5 = false;
                        Closeable closeable2 = zip.getInputStream(entry);
                        boolean bl6 = false;
                        Throwable throwable2 = null;
                        try {
                            long l;
                            InputStream input = (InputStream)closeable2;
                            boolean bl7 = false;
                            File file = this.solcFile.getParentFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"solcFile.parentFile");
                            String string3 = file.getAbsolutePath();
                            String[] stringArray = new String[1];
                            ZipEntry zipEntry = entry;
                            Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                            stringArray[0] = zipEntry.getName();
                            File file2 = Paths.get(string3, stringArray).toFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"Paths.get(solcFile.paren\u2026ath, entry.name).toFile()");
                            Object object = file2;
                            boolean bl8 = false;
                            object = new FileOutputStream((File)object);
                            bl8 = false;
                            Throwable throwable3 = null;
                            try {
                                FileOutputStream output = (FileOutputStream)object;
                                boolean bl9 = false;
                                InputStream inputStream = input;
                                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"input");
                                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
                            }
                            long l2 = l;
                        }
                        catch (Throwable throwable5) {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                winDownloadFile.delete();
            }
            return true;
        }
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            this.solcFile.getParentFile().mkdirs();
            String downloadUrl = SystemUtils.IS_OS_MAC ? this.solcRelease.getMacUrl() : this.solcRelease.getLinuxUrl();
            FilesKt.writeBytes((File)this.solcFile, (byte[])TextStreamsKt.readBytes((URL)new URL(downloadUrl)));
            if (this.installed()) {
                this.solcFile.setExecutable(true);
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean uninstall() {
        if (!this.solcFile.getParentFile().exists()) return false;
        File file = this.solcFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"solcFile.parentFile");
        if (!FilesKt.deleteRecursively((File)file)) return false;
        return true;
    }

    @NotNull
    public final SolcOutput execute(SolcArguments ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        if (!this.installed() && !this.install()) {
            String string = "Failed to install solc version";
            boolean bl = false;
            System.out.println((Object)string);
        }
        return this.runCommand(this.solcFile.getAbsolutePath() + ' ' + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, (Function1)execute.1.INSTANCE, (int)30, null) + ' ' + ArraysKt.joinToString$default((Object[])this.sourceFiles, (CharSequence)" ", null, null, (int)0, null, (Function1)execute.2.INSTANCE, (int)30, null));
    }

    private final SolcOutput runCommand(@NotNull String $this$runCommand) {
        Object object = $this$runCommand;
        String string = "\\s";
        int n = 0;
        Object object2 = new Regex(string);
        string = object2;
        n = 0;
        boolean bl = false;
        Object object3 = object2 = string.split((CharSequence)object, n);
        object = new ProcessBuilder((List<String>)object3).start();
        boolean bl2 = false;
        n = 0;
        Object $this$apply = object;
        boolean bl3 = false;
        ((Process)$this$apply).waitFor(30L, TimeUnit.SECONDS);
        Object process = object;
        int n2 = ((Process)process).exitValue();
        Object object4 = process;
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"process");
        InputStream inputStream = ((Process)object4).getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
        object = inputStream;
        int n3 = n2;
        Charset charset = Charsets.UTF_8;
        n = 0;
        Object object5 = object;
        int n4 = 0;
        object5 = new InputStreamReader((InputStream)object5, charset);
        n4 = 8192;
        boolean bl4 = false;
        Object object6 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n4);
        String string2 = TextStreamsKt.readText((Reader)((Reader)object6));
        InputStream inputStream2 = ((Process)process).getErrorStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"process.errorStream");
        object = inputStream2;
        object6 = string2;
        charset = Charsets.UTF_8;
        n = 0;
        object5 = object;
        n4 = 0;
        object5 = new InputStreamReader((InputStream)object5, charset);
        n4 = 8192;
        bl4 = false;
        BufferedReader bufferedReader = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n4);
        String string3 = TextStreamsKt.readText((Reader)bufferedReader);
        Object object7 = object6;
        int n5 = n3;
        return new SolcOutput(n5, (String)object7, string3);
    }

    @NotNull
    public final SolcRelease getSolcRelease() {
        return this.solcRelease;
    }

    public SolcInstance(@NotNull SolcRelease solcRelease, @NotNull String directoryPath, boolean redirectOutput, SolidityFile ... sourceFiles) {
        Intrinsics.checkParameterIsNotNull((Object)solcRelease, (String)"solcRelease");
        Intrinsics.checkParameterIsNotNull((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkParameterIsNotNull((Object)sourceFiles, (String)"sourceFiles");
        this.solcRelease = solcRelease;
        this.directoryPath = directoryPath;
        this.redirectOutput = redirectOutput;
        this.sourceFiles = sourceFiles;
        File file = Paths.get(System.getProperty("user.home"), this.directoryPath, "solc", this.solcRelease.getVersion(), SystemUtils.IS_OS_WINDOWS ? "solc.exe" : "solc").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Paths.get(\n            S\u2026\"solc\"\n        ).toFile()");
        this.solcFile = file;
    }

    public /* synthetic */ SolcInstance(SolcRelease solcRelease, String string, boolean bl, SolidityFile[] solidityFileArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = ".web3j";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(solcRelease, string, bl, solidityFileArray);
    }
}

