/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.sokt;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.web3j.sokt.SolcArguments;
import org.web3j.sokt.SolcInstance;
import org.web3j.sokt.SolcOutput;
import org.web3j.sokt.SolcRelease;
import org.web3j.sokt.SolidityFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\t\"\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0007J\f\u0010\u001b\u001a\u00020\u0014*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/web3j/sokt/SolcInstance;", "", "solcRelease", "Lorg/web3j/sokt/SolcRelease;", "directoryPath", "", "redirectOutput", "", "sourceFiles", "", "Lorg/web3j/sokt/SolidityFile;", "(Lorg/web3j/sokt/SolcRelease;Ljava/lang/String;Z[Lorg/web3j/sokt/SolidityFile;)V", "solcFile", "Ljava/io/File;", "getSolcFile", "()Ljava/io/File;", "getSolcRelease", "()Lorg/web3j/sokt/SolcRelease;", "[Lorg/web3j/sokt/SolidityFile;", "execute", "Lorg/web3j/sokt/SolcOutput;", "args", "Lorg/web3j/sokt/SolcArguments;", "([Lorg/web3j/sokt/SolcArguments;)Lorg/web3j/sokt/SolcOutput;", "install", "installed", "uninstall", "runCommand", "web3j-sokt"})
@SourceDebugExtension(value={"SMAP\nSolcInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolcInstance.kt\norg/web3j/sokt/SolcInstance\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1313#2,2:103\n1#3:105\n*S KotlinDebug\n*F\n+ 1 SolcInstance.kt\norg/web3j/sokt/SolcInstance\n*L\n56#1:103,2\n*E\n"})
public final class SolcInstance {
    @NotNull
    private final SolcRelease solcRelease;
    @NotNull
    private final String directoryPath;
    private final boolean redirectOutput;
    @NotNull
    private final SolidityFile[] sourceFiles;
    @NotNull
    private final File solcFile;

    public SolcInstance(@NotNull SolcRelease solcRelease, @NotNull String directoryPath, boolean redirectOutput, SolidityFile ... sourceFiles) {
        Intrinsics.checkNotNullParameter((Object)solcRelease, (String)"solcRelease");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)sourceFiles, (String)"sourceFiles");
        this.solcRelease = solcRelease;
        this.directoryPath = directoryPath;
        this.redirectOutput = redirectOutput;
        this.sourceFiles = sourceFiles;
        String[] stringArray = new String[]{this.directoryPath, "solc", this.solcRelease.getVersion(), SystemUtils.IS_OS_WINDOWS ? "solc.exe" : "solc"};
        File file = Paths.get(System.getProperty("user.home"), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.solcFile = file;
    }

    public /* synthetic */ SolcInstance(SolcRelease solcRelease, String string, boolean bl, SolidityFile[] solidityFileArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = ".web3j";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(solcRelease, string, bl, solidityFileArray);
    }

    @NotNull
    public final SolcRelease getSolcRelease() {
        return this.solcRelease;
    }

    @NotNull
    public final File getSolcFile() {
        return this.solcFile;
    }

    public final boolean installed() {
        return this.solcFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean install() {
        System.out.println((Object)("Solidity version " + this.solcRelease.getVersion() + " is not installed. Downloading and installing it to ~/" + this.directoryPath + "/solc/" + this.solcRelease.getVersion()));
        if (SystemUtils.IS_OS_WINDOWS) {
            this.solcFile.getParentFile().mkdirs();
            if (this.solcRelease.getVersion().compareTo("0.7.1") > 0) {
                FilesKt.writeBytes((File)this.solcFile, (byte[])TextStreamsKt.readBytes((URL)new URL(this.solcRelease.getWindowsUrl())));
                if (this.installed()) {
                    this.solcFile.setExecutable(true);
                }
            } else {
                String string = this.solcFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                File winDownloadFile = new File(StringsKt.dropLast((String)string, (int)4) + ".zip");
                FilesKt.writeBytes((File)winDownloadFile, (byte[])TextStreamsKt.readBytes((URL)new URL(this.solcRelease.getWindowsUrl())));
                Closeable closeable = new ZipFile(winDownloadFile);
                Throwable throwable = null;
                try {
                    void $this$forEach$iv;
                    ZipFile zip = (ZipFile)closeable;
                    boolean bl = false;
                    Enumeration<? extends ZipEntry> enumeration = zip.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                    Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ZipEntry entry = (ZipEntry)element$iv;
                        boolean bl2 = false;
                        Closeable closeable2 = zip.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            InputStream input = (InputStream)closeable2;
                            boolean bl3 = false;
                            Object object = new String[]{entry.getName()};
                            File file = Paths.get(this.solcFile.getParentFile().getAbsolutePath(), object).toFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                            Object object2 = file;
                            object2 = new FileOutputStream((File)object2);
                            object = null;
                            try {
                                FileOutputStream output = (FileOutputStream)object2;
                                boolean bl4 = false;
                                Intrinsics.checkNotNull((Object)input);
                                ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable3) {
                                object = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                winDownloadFile.delete();
            }
            return true;
        }
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            this.solcFile.getParentFile().mkdirs();
            String downloadUrl = SystemUtils.IS_OS_MAC ? this.solcRelease.getMacUrl() : this.solcRelease.getLinuxUrl();
            FilesKt.writeBytes((File)this.solcFile, (byte[])TextStreamsKt.readBytes((URL)new URL(downloadUrl)));
            if (this.installed()) {
                this.solcFile.setExecutable(true);
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean uninstall() {
        if (!this.solcFile.getParentFile().exists()) return false;
        File file = this.solcFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        if (!FilesKt.deleteRecursively((File)file)) return false;
        return true;
    }

    @NotNull
    public final SolcOutput execute(SolcArguments ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!this.installed() && !this.install()) {
            System.out.println((Object)"Failed to install solc version");
        }
        return this.runCommand(this.solcFile.getAbsolutePath() + " " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, (Function1)execute.1.INSTANCE, (int)30, null) + " " + ArraysKt.joinToString$default((Object[])this.sourceFiles, (CharSequence)" ", null, null, (int)0, null, (Function1)execute.2.INSTANCE, (int)30, null));
    }

    private final SolcOutput runCommand(String $this$runCommand) {
        Object object = $this$runCommand;
        Object object2 = new Regex("\\s");
        int n = 0;
        Object $this$runCommand_u24lambda_u244 = object = new ProcessBuilder(object2.split((CharSequence)object, n)).start();
        boolean bl = false;
        ((Process)$this$runCommand_u24lambda_u244).waitFor(30L, TimeUnit.SECONDS);
        Object process = object;
        int n2 = ((Process)process).exitValue();
        InputStream inputStream = ((Process)process).getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        object = inputStream;
        object2 = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)object, (Charset)object2);
        int n3 = 8192;
        String string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n3)));
        InputStream inputStream2 = ((Process)process).getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        object = inputStream2;
        object2 = Charsets.UTF_8;
        reader = new InputStreamReader((InputStream)object, (Charset)object2);
        n3 = 8192;
        return new SolcOutput(n2, string, TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n3))));
    }
}

