/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.sokt;

import com.github.zafarkhaja.semver.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.sokt.SolcRelease;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0086\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\f\u001a\u00020\u0003J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/web3j/sokt/VersionResolver;", "", "directoryPath", "", "<init>", "(Ljava/lang/String;)V", "get", "uri", "getSolcReleases", "", "Lorg/web3j/sokt/SolcRelease;", "versionsFromString", "input", "getCompatibleVersions", "pragmaRequirement", "releases", "getLatestCompatibleVersion", "web3j-sokt"})
@SourceDebugExtension(value={"SMAP\nVersionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionResolver.kt\norg/web3j/sokt/VersionResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1#2:89\n96#3:90\n96#3:91\n96#3:92\n774#4:93\n865#4:94\n1734#4,3:95\n866#4:98\n*S KotlinDebug\n*F\n+ 1 VersionResolver.kt\norg/web3j/sokt/VersionResolver\n*L\n53#1:90\n56#1:91\n59#1:92\n72#1:93\n72#1:94\n73#1:95,3\n72#1:98\n*E\n"})
public final class VersionResolver {
    @NotNull
    private final String directoryPath;

    public VersionResolver(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        this.directoryPath = directoryPath;
    }

    public /* synthetic */ VersionResolver(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".web3j";
        }
        this(string);
    }

    @NotNull
    public final String get(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        URLConnection uRLConnection = new URL(uri).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection con = (HttpsURLConnection)uRLConnection;
        con.setConnectTimeout((int)TimeUnit.MILLISECONDS.toMillis(200L));
        con.setReadTimeout((int)TimeUnit.SECONDS.toMillis(1L));
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        String inputLine = null;
        StringBuffer response = new StringBuffer();
        while (true) {
            String string;
            String it = string = reader.readLine();
            boolean bl = false;
            inputLine = it;
            if (string == null) break;
            response.append(inputLine);
        }
        reader.close();
        String string = response.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SolcRelease> getSolcReleases() {
        String[] stringArray = new String[]{this.directoryPath, "solc", "releases.json"};
        File versionsFile = Paths.get(System.getProperty("user.home"), stringArray).toFile();
        try {
            String result = this.get("https://raw.githubusercontent.com/LFDT-web3j/web3j-sokt/main/src/main/resources/releases.json");
            versionsFile.getParentFile().mkdirs();
            Intrinsics.checkNotNull((Object)versionsFile);
            FilesKt.writeText$default((File)versionsFile, (String)result, null, (int)2, null);
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            return (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SolcRelease.Companion.serializer()), result);
        }
        catch (Exception e) {
            List list;
            if (versionsFile.exists()) {
                void this_$iv;
                Json $i$f$decodeFromString = (Json)Json.Default;
                Intrinsics.checkNotNull((Object)versionsFile);
                String string$iv = FilesKt.readText$default((File)versionsFile, null, (int)1, null);
                boolean $i$f$decodeFromString2 = false;
                this_$iv.getSerializersModule();
                list = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SolcRelease.Companion.serializer()), string$iv);
            } else {
                URL uRL = ClassLoader.getSystemResource("releases.json");
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getSystemResource(...)");
                URL string$iv = uRL;
                Charset $i$f$decodeFromString2 = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)string$iv);
                String defaultReleases = new String(byArray, $i$f$decodeFromString2);
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString22 = false;
                this_$iv.getSerializersModule();
                list = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(SolcRelease.Companion.serializer()), defaultReleases);
            }
            return list;
        }
    }

    @NotNull
    public final List<String> versionsFromString(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)Regex.findAll$default((Regex)new Regex("\\s*[\\^<>=~!]{0,3}\\s*(\\d*(\\.?)\\s*){1,3}"), (CharSequence)input, (int)0, (int)2, null), VersionResolver::versionsFromString$lambda$1), VersionResolver::versionsFromString$lambda$2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SolcRelease> getCompatibleVersions(@NotNull String pragmaRequirement, @NotNull List<SolcRelease> releases) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pragmaRequirement, (String)"pragmaRequirement");
        Intrinsics.checkNotNullParameter(releases, (String)"releases");
        List<String> requiredVersions = this.versionsFromString(pragmaRequirement);
        Iterable $this$filter$iv = releases;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                SolcRelease it = (SolcRelease)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = requiredVersions;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String nr = (String)element$iv;
                        boolean bl3 = false;
                        if (Version.valueOf((String)it.getVersion()).satisfies(nr) && it.isCompatibleWithOs()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final SolcRelease getLatestCompatibleVersion(@Nullable String pragmaRequirement) {
        List<SolcRelease> solcReleases = this.getSolcReleases();
        return pragmaRequirement != null ? (SolcRelease)CollectionsKt.lastOrNull(this.getCompatibleVersions(pragmaRequirement, solcReleases)) : (SolcRelease)CollectionsKt.last(solcReleases);
    }

    private static final boolean versionsFromString$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)((CharSequence)it.getGroupValues().get(0)));
    }

    private static final String versionsFromString$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)((String)it.getGroupValues().get(0)))).toString();
        Regex regex = new Regex("\\s");
        String string = "";
        return regex.replace(charSequence, string);
    }

    public VersionResolver() {
        this(null, 1, null);
    }
}

