/**!
 * FileAPI a set of tools for working with files
 *
 * @author  RubaXa  <trash@rubaxa.org>
 * @build	lib/canvas-to-blob lib/FileAPI.core lib/FileAPI.Image lib/FileAPI.Form lib/FileAPI.XHR lib/FileAPI.Flash lib/load-image-ios
 */
(function(a){var q=a.HTMLCanvasElement&&a.HTMLCanvasElement.prototype,g;if(g=a.Blob)try{g=Boolean(new Blob)}catch(l){g=!1}var m=g;if(g=m)if(g=a.Uint8Array)try{g=100===(new Blob([new Uint8Array(100)])).size}catch(f){g=!1}var c=g,e=a.BlobBuilder||a.WebKitBlobBuilder||a.MozBlobBuilder||a.MSBlobBuilder,n=(m||e)&&a.atob&&a.ArrayBuffer&&a.Uint8Array&&function(a){var s,f,g,n;s=0<=a.split(",")[0].indexOf("base64")?atob(a.split(",")[1]):decodeURIComponent(a.split(",")[1]);f=new ArrayBuffer(s.length);g=new Uint8Array(f);
for(n=0;n<s.length;n+=1)g[n]=s.charCodeAt(n);a=a.split(",")[0].split(":")[1].split(";")[0];if(m)return new Blob([c?g:f],{type:a});g=new e;g.append(f);return g.getBlob(a)};a.HTMLCanvasElement&&!q.toBlob&&(q.mozGetAsFile?q.toBlob=function(a,c){a(this.mozGetAsFile("blob",c))}:q.toDataURL&&n&&(q.toBlob=function(a,c){a(n(this.toDataURL(c)))}));a.dataURLtoBlob=n})(this);
(function(a,q){function g(b,d,a){if(b)if(u(b))for(var c=0,h=b.length;c<h;c++)c in b&&d.call(a,b[c],c,b);else for(c in b)b.hasOwnProperty(c)&&d.call(a,b[c],c,b)}function l(b,d,a){if(b){var c=k.uid(b);D[c]||(D[c]={});g(d.split(/\s+/),function(d){w?w.event.add(b,d,a):(D[c][d]||(D[c][d]=[]),D[c][d].push(a),b.addEventListener?b.addEventListener(d,a,!1):b.attachEvent?b.attachEvent("on"+d,a):b["on"+d]=a)})}}function m(b,d,a){if(b){var c=k.uid(b),h=D[c]||{};g(d.split(/\s+/),function(d){if(w)w.event.remove(b,
d,a);else{for(var K=h[d]||[],c=K.length;c--;)if(K[c]===a){K.splice(c,1);break}b.addEventListener?b.removeEventListener(d,a,!1):b.detachEvent?b.detachEvent("on"+d,a):b["on"+d]=null}})}}function f(b,d,a){l(b,d,function R(c){m(b,d,R);a(c)})}function c(b,d,a,c,h){b={type:a.type||a,target:b,result:c};k.extend(b,h);d(b)}function e(b,d,a,h){if(k.isFile(b)&&v&&v.prototype["readAs"+a]){var e=new v;l(e,L,function S(a){var h=a.type;"progress"==h?c(b,d,a,a.target.result,{loaded:a.loaded,total:a.total}):"loadend"==
h?(m(e,L,S),e=null):c(b,d,a,a.target.result)});try{if(h)e["readAs"+a](h,b);else e["readAs"+a](b)}catch(f){c(b,d,"error",q,{error:f.toString()})}}else c(b,d,"error",q,{error:"filreader_not_support_"+a})}function n(b,d){if(!b.type&&0==b.size%4096&&102400>=b.size)if(v)try{var a=new v;f(a,L,function(b){b="error"!=b.type;d(b);b&&a.abort()});a.readAsDataURL(b)}catch(c){d(!1)}else d(null);else d(!0)}function r(b){var d;b.getAsEntry?d=b.getAsEntry():b.webkitGetAsEntry&&(d=b.webkitGetAsEntry());return d}function s(b,
d){if(b)if(b.isFile)b.file(function(a){a.fullPath=b.fullPath;d(!1,[a])},function(){d("entry_file")});else if(b.isDirectory){var a=[];b.createReader().readEntries(function(b){k.afor(b,function(b,c){s(c,function(c,h){c||(a=a.concat(h));b?b():d(!1,a)})})},function(){d("directory_reader")})}else s(r(b),d);else d("empty_entry")}function u(b){return b&&"length"in b}function x(b){var d={};g(b,function(b,a){b&&"object"===typeof b&&(b=k.extend({},b));d[a]=b});return d}function y(b){b.target||(b.target=a.event&&
a.event.srcElement||C);3===b.target.nodeType&&(b.target=event.target.parentNode);return b}var p=1,d=function(){},h=navigator.userAgent,t=a.createObjectURL&&a||a.URL&&URL.revokeObjectURL&&URL||a.webkitURL&&webkitURL,E=a.Blob,F=a.File,v=a.FileReader,z=a.FormData,I=a.XMLHttpRequest,w=a.jQuery,A=!!(F&&v&&(a.Uint8Array||z||I.prototype.sendAsBinary))&&!(/safari\//i.test(h)&&!/chrome\//i.test(h)&&/windows/i.test(h)),h=A&&"withCredentials"in new I,E=A&&!!E&&!!(E.prototype.webkitSlice||E.prototype.mozSlice||
E.prototype.slice),C=a.document,N=a.dataURLtoBlob,V=/img/i,W=/canvas/i,X=/img|canvas/,M=/input/i,Y=/^data:[^,]+,/,G=Math.pow,Z=Math.round,J=Number,z=function(b){return Z(b*this)},H=new J(1024),O=new J(G(H,2)),P=new J(G(H,3)),G=new J(G(H,4)),D={},Q=[],L="abort progress error load loadend",$="status statusText readyState response responseXML responseText responseBody".split(" "),k={version:"1.2.7",cors:!1,html5:!0,debug:!1,pingUrl:!1,flashAbortTimeout:0,withCredentials:!0,staticPath:"./",flashUrl:0,
flashImageUrl:0,postNameConcat:function(b,d){return b+(null!=d?"["+d+"]":"")},ext2mime:{jpg:"image/jpeg",tif:"image/tiff"},accept:{"image/*":"art bm bmp dwg dxf cbr cbz fif fpx gif ico iefs jfif jpe jpeg jpg jps jut mcf nap nif pbm pcx pgm pict pm png pnm qif qtif ras rast rf rp svf tga tif tiff xbm xbm xpm xwd","audio/*":"m4a flac aac rm mpa wav wma ogg mp3 mp2 m3u mod amf dmf dsm far gdm imf it m15 med okt s3m stm sfx ult uni xm sid ac3 dts cue aif aiff wpl ape mac mpc mpp shn wv nsf spc gym adplug adx dsp adp ymf ast afc hps xs",
"video/*":"m4v 3gp nsv ts ty strm rm rmvb m3u ifo mov qt divx xvid bivx vob nrg img iso pva wmv asf asx ogm m2v avi bin dat dvr-ms mpg mpeg mp4 mkv avc vp3 svq3 nuv viv dv fli flv wpl"},chunkSize:0,chunkUploadRetry:0,chunkNetworkDownRetryTimeout:2E3,KB:(H.from=z,H),MB:(O.from=z,O),GB:(P.from=z,P),TB:(G.from=z,G),expando:"fileapi"+(new Date).getTime(),uid:function(b){return b?b[k.expando]=b[k.expando]||k.uid():(++p,k.expando+p)},log:function(){k.debug&&a.console&&console.log&&(console.log.apply?console.log.apply(console,
arguments):console.log([].join.call(arguments," ")))},newImage:function(b,d){var a=C.createElement("img");if(d)k.event.one(a,"error load",function(b){d("error"==b.type,a);a=null});a.src=b;return a},getXHR:function(){var b;if(I)b=new I;else if(a.ActiveXObject)try{b=new ActiveXObject("MSXML2.XMLHttp.3.0")}catch(d){b=new ActiveXObject("Microsoft.XMLHTTP")}return b},isArray:u,support:{dnd:h&&"ondrop"in C.createElement("div"),cors:h,html5:A,chunked:E,dataURI:!0},event:{on:l,off:m,one:f,fix:y},throttle:function(b,
d){var c,h;return function(){h=arguments;c||(b.apply(a,h),c=setTimeout(function(){c=0;b.apply(a,h)},d))}},F:function(){},parseJSON:function(b){return a.JSON&&JSON.parse?JSON.parse(b):(new Function("return ("+b.replace(/([\r\n])/g,"\\$1")+");"))()},trim:function(b){b=String(b);return b.trim?b.trim():b.replace(/^\s+|\s+$/g,"")},defer:function(){var b=[],a,c,h={resolve:function(e,f){h.resolve=d;c=e||!1;for(a=f;f=b.shift();)f(c,a)},then:function(d){c!==q?d(c,a):b.push(d)}};return h},queue:function(b){var d=
0,a=0,c=!1,h=!1,e={inc:function(){a++},next:function(){d++;setTimeout(e.check,0)},check:function(){d>=a&&!c&&e.end()},isFail:function(){return c},fail:function(){!c&&b(c=!0)},end:function(){h||(h=!0,b())}};return e},each:g,afor:function(b,d){var a=0,c=b.length;u(b)&&c--?function B(){d(c!=a&&B,b[a],a++)}():d(!1)},extend:function(b){g(arguments,function(d){g(d,function(d,a){b[a]=d})});return b},isFile:function(b){return A&&b&&b instanceof F},isCanvas:function(b){return b&&W.test(b.nodeName)},getFilesFilter:function(b){return(b=
"string"==typeof b?b:b.getAttribute&&b.getAttribute("accept")||"")?RegExp("("+b.replace(/\./g,"\\.").replace(/,/g,"|")+")$","i"):/./},readAsDataURL:function(b,d){k.isCanvas(b)?c(b,d,"load",k.toDataURL(b)):e(b,d,"DataURL")},readAsBinaryString:function(b,d){v&&v.prototype.readAsBinaryString?e(b,d,"BinaryString"):e(b,function(b){if("load"==b.type)try{b.result=k.toBinaryString(b.result)}catch(a){b.type="error",b.message=a.toString()}d(b)},"DataURL")},readAsArrayBuffer:function(b,d){e(b,d,"ArrayBuffer")},
readAsText:function(b,d,a){a||(a=d,d="utf-8");e(b,a,"Text",d)},toDataURL:function(b){if("string"==typeof b)return b;if(b.toDataURL)return b.toDataURL("image/png")},toBinaryString:function(b){return a.atob(k.toDataURL(b).replace(Y,""))},readAsImage:function(b,d,a){if(k.isFile(b))if(t){var h=t.createObjectURL(b);h===q?c(b,d,"error"):k.readAsImage(h,d,a)}else k.readAsDataURL(b,function(h){"load"==h.type?k.readAsImage(h.result,d,a):(a||"error"==h.type)&&c(b,d,h,null,{loaded:h.loaded,total:h.total})});
else k.isCanvas(b)?c(b,d,"load",b):V.test(b.nodeName)?b.complete?c(b,d,"load",b):f(b,"error abort load",function B(a){"load"==a.type&&t&&t.revokeObjectURL(b.src);m(b,"error abort load",B);c(b,d,a,b)}):b.iframe?c(b,d,{type:"error"}):(h=k.newImage(b.dataURL||b),k.readAsImage(h,d,a))},checkFileObj:function(b){var d={},a=k.accept;"object"==typeof b?d=b:d.name=(b+"").split(/\\|\//g).pop();null==d.type&&(d.type=d.name.split(".").pop());g(a,function(b,a){b=RegExp(b.replace(/\s/g,"|"),"i");b.test(d.type)&&
(d.type=k.ext2mime[d.type]||a.split("/")[0]+"/"+d.type)});return d},getDropFiles:function(b,d){var a=[],c=(b.originalEvent||b||"").dataTransfer||{},h=u(c.items)&&c.items[0]&&r(c.items[0]),e=k.queue(function(){d(a)});g((h?c.items:c.files)||[],function(b){e.inc();try{h?s(b,function(b,d){!b&&a.push.apply(a,d);e.next()}):n(b,function(d){d&&a.push(b);e.next()})}catch(d){e.next(),k.log("getDropFiles.error:",d.toString())}});e.check()},getFiles:function(b,d,a){var c=[];if(a)return k.filterFiles(k.getFiles(b),
d,a),null;b.jquery&&(b.each(function(){c=c.concat(k.getFiles(this))}),b=c,c=[]);"string"==typeof d&&(d=k.getFilesFilter(d));b.originalEvent?b=y(b.originalEvent):b.srcElement&&(b=y(b));b.dataTransfer?b=b.dataTransfer:b.target&&(b=b.target);b.files?(c=b.files,A||(c[0].blob=b,c[0].iframe=!0)):!A&&M.test(b&&b.tagName)?k.trim(b.value)&&(c=[k.checkFileObj(b.value)],c[0].blob=b,c[0].iframe=!0):u(b)&&(c=b);return k.filter(c,function(b){return!d||d.test(b.name)})},getInfo:function(b,d){var a={},c=Q.concat();
k.isFile(b)?function B(){var h=c.shift();h?h.test(b.type)?h(b,function(b,c){b?d(b):(k.extend(a,c),B())}):B():d(!1,a)}():d("not_support",a)},addInfoReader:function(b,d){d.test=function(d){return b.test(d)};Q.push(d)},filter:function(b,d){for(var a=[],c=0,h=b.length,e;c<h;c++)c in b&&(e=b[c],d.call(e,e,c,b)&&a.push(e));return a},filterFiles:function(b,d,a){if(b.length){var c=b.concat(),h,e=[],f=[];(function T(){c.length?(h=c.shift(),k.getInfo(h,function(b,a){(d(h,b?!1:a)?e:f).push(h);T()})):a(e,f)})()}else a([],
b)},upload:function(b){b=k.extend({prepare:k.F,beforeupload:k.F,upload:k.F,fileupload:k.F,fileprogress:k.F,filecomplete:k.F,progress:k.F,complete:k.F,pause:k.F,chunkSize:k.chunkSize,chunkUploadRetry:k.chunkUploadRetry},b);b.imageAutoOrientation&&!b.imageTransform&&(b.imageTransform={rotate:"auto"});var a=new k.XHR(b),c=this._getFilesDataArray(b.files),h=0,e=0,f=this,r,s=!1;g(c,function(b){h+=b.size});a.files=[];g(c,function(b){a.files.push(b.file)});a.total=h;a.loaded=0;a.filesLeft=c.length;b.beforeupload(a,
b);(r=function U(){var r=c.shift(),t=r&&r.file,p=!1,u=x(b);a.filesLeft=c.length;t&&t.name===k.expando&&(t=null,k.log("[warn] FileAPI.upload() \u2014 called without files"));("abort"!=a.statusText||a.current)&&r?(s=!1,(a.currentFile=t)&&b.prepare(t,u),this._getFormData(u,r,function(s){e||b.upload(a,b);var m=new k.XHR(k.extend({},u,{upload:t?function(){b.fileupload(t,m,u)}:d,progress:t?function(d){p||(b.fileprogress({type:"progress",total:r.total=d.total,loaded:r.loaded=d.loaded},t,m,u),b.progress({type:"progress",
total:h,loaded:a.loaded=e+d.loaded/d.total*r.size|0},t,m,u))}:d,complete:function(d){p=!0;g($,function(b){a[b]=m[b]});t&&(r.loaded=r.total,this.progress(r),e+=r.size,a.loaded=e,b.filecomplete(d,m,t,u));U.call(f)}}));a.abort=function(b){b||(c.length=0);this.current=b;m.abort()};m.send(s)})):(b.complete(200==a.status||201==a.status?!1:a.statusText||"error",a,b),s=!0)}).call(this);a.append=function(b,d){b=k._getFilesDataArray([].concat(b));g(b,function(b){h+=b.size;a.files.push(b.file);d?c.unshift(b):
c.push(b)});a.statusText="";s&&r.call(f)};a.remove=function(b){var d=-1;g(c,function(a){d++;if(a.file==b)return c.splice(d,1)})};return a},_getFilesDataArray:function(b){var d=[],a={};if(M.test(b&&b.tagName)){var c=k.getFiles(b);a[b.name||"file"]=null!==b.getAttribute("multiple")?c:c[0]}else u(b)&&M.test(b[0]&&b[0].tagName)?g(b,function(b){a[b.name||"file"]=k.getFiles(b)}):a=b;g(a,function B(b,a){u(b)?g(b,function(b,d){B(b,a)}):b&&b.name&&d.push({name:a,file:b,size:b.size,total:b.size,loaded:0})});
d.length||d.push({file:{name:k.expando}});return d},_getFormData:function(b,d,a){var c=d.file,h=d.name,e=c.name,f=c.type;d=k.support.transform&&b.imageTransform;var r=new k.Form,t=k.queue(function(){a(r)}),s=d&&(0<parseInt(d.maxWidth||d.minWidth||d.width,10)||d.rotate);g(b.data,function aa(b,d){"object"==typeof b?g(b,function(b,a){aa(b,k.postNameConcat(d,a))}):r.append(d,b)});k.Image&&d&&(/image/.test(c.type)||X.test(c.nodeType))?(t.inc(),s&&(d=[d]),k.Image.transform(c,d,b.imageAutoOrientation,function(d,
a){s&&!d?(N||k.flashEngine||(a[0]=k.toBinaryString(a[0]),r.multipart=!0),r.append(h,a[0],e,f)):(d||(g(a,function(b,d){N||k.flashEngine||(b=k.toBinaryString(b),r.multipart=!0);r.append(h+"["+d+"]",b,e,f)}),h+="[original]"),(d||b.imageOriginal)&&r.append(h,c,e,f));t.next()})):e!==k.expando&&r.append(h,c,e);t.check()},reset:function(b,d){var a,c;w?(c=w(b).clone(!0).insertBefore(b).val("")[0],d||w(b).remove()):(a=b.parentNode,c=a.insertBefore(b.cloneNode(!0),b),c.value="",d||a.removeChild(b),g(D[k.uid(b)],
function(d,a){g(d,function(d){m(b,a,d);l(c,a,d)})}));return c},load:function(b,d){var a=k.getXHR();a?(a.open("GET",b,!0),a.overrideMimeType&&a.overrideMimeType("text/plain; charset=x-user-defined"),l(a,"progress",function(b){b.lengthComputable&&d({type:b.type,loaded:b.loaded,total:b.total},a)}),a.onreadystatechange=function(){if(4==a.readyState)if(a.onreadystatechange=null,200==a.status){b=b.split("/");var c={name:b[b.length-1],size:a.getResponseHeader("Content-Length"),type:a.getResponseHeader("Content-Type")};
c.dataURL="data:"+c.type+";base64,"+k.encode64(a.responseBody||a.responseText);d({type:"load",result:c})}else d({type:"error"})},a.send(null)):d({type:"error"});return a},encode64:function(b){var d="",a=0;for("string"!==typeof b&&(b=String(b));a<b.length;){var c=b.charCodeAt(a++)&255,h=b.charCodeAt(a++)&255,e=b.charCodeAt(a++)&255,f=c>>2,c=(c&3)<<4|h>>4;isNaN(h)?h=e=64:(h=(h&15)<<2|e>>6,e=isNaN(e)?64:e&63);d+="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(f)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(c)+
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(h)+"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(e)}return d}};k.addInfoReader(/^image/,function(b,d){if(!b.__dimensions){var a=b.__dimensions=k.defer();k.readAsImage(b,function(b){var d=b.target;a.resolve("load"==b.type?!1:"error",{width:d.width,height:d.height})})}b.__dimensions.then(d)});k.event.dnd=function(b,d,a){var c,h;a||(a=d,d=k.F);v?(l(b,"dragenter dragleave dragover",function(b){for(var a=
((b.originalEvent||b||"").dataTransfer||{}).types,e=a&&a.length;e--;)~a[e].indexOf("File")&&(b.preventDefault(),h!==b.type&&(h=b.type,"dragleave"!=h&&d.call(b.currentTarget,!0,b),clearTimeout(c),c=setTimeout(function(){d.call(b.currentTarget,"dragleave"!=h,b)},50)))}),l(b,"drop",function(b){b.preventDefault();h=0;d.call(b.currentTarget,!1,b);k.getDropFiles(b,function(d){a.call(b.currentTarget,d,b)})})):k.log("Drag'n'Drop -- not supported")};w&&!w.fn.dnd&&(w.fn.dnd=function(b,d){return this.each(function(){k.event.dnd(this,
b,d)})});a.FileAPI=k.extend(k,a.FileAPI);k.log("version: "+k.version);k.log("protocol: "+a.location.protocol);C.doctype?k.log("doctype: ["+C.doctype.name+"] "+C.doctype.publicId+" "+C.doctype.systemId):k.log("doctype: unknown");g(C.getElementsByTagName("meta"),function(b){/x-ua-compatible/i.test(b.getAttribute("http-equiv"))&&k.log("meta.http-equiv: "+b.getAttribute("content"))});k.flashUrl||(k.flashUrl=k.staticPath+"FileAPI.flash.swf");k.flashImageUrl||(k.flashImageUrl=k.staticPath+"FileAPI.flash.image.swf")})(window);
(function(a,q,g){function l(a,c){if(!(this instanceof l))return new l(a);this.file=a;this.better=!c;this.matrix={sx:0,sy:0,sw:0,sh:0,dx:0,dy:0,dw:0,dh:0,resize:0,deg:0}}var m=Math.min,f=Math.round,c=!1,e={8:270,3:180,6:90};try{c=-1<q.createElement("canvas").toDataURL("image/png").indexOf("data:image/png")}catch(n){}l.prototype={constructor:l,set:function(c){a.extend(this.matrix,c);return this},crop:function(a,c,e,f){e===g&&(e=a,f=c,a=c=0);return this.set({sx:a,sy:c,sw:e,sh:f||e})},resize:function(a,
c,e){"string"==typeof c&&(e=c,c=a);return this.set({dw:a,dh:c,resize:e})},preview:function(a,c){return this.set({dw:a,dh:c||a,resize:"preview"})},rotate:function(a){return this.set({deg:a})},_load:function(c,e){var f=this;a.readAsImage(c,function(a){e.call(f,"load"!=a.type,a.result)})},_apply:function(c,e){var f=q.createElement("canvas"),g=this.getMatrix(c),m=f.getContext("2d"),p=g.deg,d=g.dw,h=g.dh,t=c.width,n=c.height,l,v=c,z=a.renderImageToCanvas;c._type=this.file.type;if(this.better)for(;2<Math.min(t/
d,n/h);)t=~~(t/2+0.5),n=~~(n/2+0.5),l=q.createElement("canvas"),l.width=t,l.height=n,v!==c?(z(l,v,0,0,v.width,v.height,0,0,t,n),v=l):(v=l,z(v,c,g.sx,g.sy,g.sw,g.sh,0,0,t,n),g.sx=g.sy=g.sw=g.sh=0);f.width=p%180?h:d;f.height=p%180?d:h;m.rotate(p*Math.PI/180);z(f,v,g.sx,g.sy,g.sw||v.width,g.sh||v.height,180==p||270==p?-d:0,90==p||180==p?-h:0,d,h);e.call(this,!1,f)},getMatrix:function(c){var e=a.extend({},this.matrix),g=e.sw=e.sw||c.width;c=e.sh=e.sh||c.height;var n=e.dw=e.dw||e.sw,l=e.dh=e.dh||e.sh,
p=g/c,d=n/l,h=e.resize;if("preview"==h){if(n!=g||l!=c)if(d>=p?(p=g,h=p/d):(h=c,p=h*d),p!=g||h!=c)e.sx=~~((g-p)/2),e.sy=~~((c-h)/2),g=p,c=h}else h&&(g>n||c>l?"min"==h?(n=f(p<d?m(g,n):l*p),l=f(p<d?n/p:m(c,l))):(n=f(p>=d?m(g,n):l*p),l=f(p>=d?n/p:m(c,l))):(n=g,l=c));e.sw=g;e.sh=c;e.dw=n;e.dh=l;return e},_trans:function(a){this._load(this.file,function(c,e){c?a(c):this._apply(e,a)})},get:function(c){if(a.support.transform){var f=this;"auto"==f.matrix.deg?a.getInfo(this.file,function(a,g){f.matrix.deg=
e[g&&g.exif&&g.exif.Orientation]||0;f._trans(c)}):f._trans(c)}else c("not_support")},toData:function(a){this.get(a)}};l.exifOrientation=e;l.transform=function(c,e,f,n){a.getInfo(c,function(m,p){var d={},h=a.queue(function(a){n(a,d)});m?h.fail():a.each(e,function(a,e){if(!h.isFail()){var n=l(p.nodeType?p:c);if("function"==typeof a)a(p,n);else if(a.width)n[a.preview?"preview":"resize"](a.width,a.height,a.type);else a.maxWidth&&(p.width>a.maxWidth||p.height>a.maxHeight)&&n.resize(a.maxWidth,a.maxHeight,
"max");a.rotate===g&&f&&(a.rotate="auto");n.rotate(a.rotate);h.inc();n.toData(function(a,c){a?h.fail():(d[e]=c,h.next())})}})})};a.renderImageToCanvas=function(a,c,e,f,g,n,d,h,t,m){a.getContext("2d").drawImage(c,e,f,g,n,d,h,t,m);return a};a.support.canvas=a.support.transform=c;a.Image=l})(FileAPI,document);
(function(a,q,g){var l=q.encodeURIComponent,m=q.FormData;q=function(){this.items=[]};q.prototype={append:function(a,c,e,g){this.items.push({name:a,blob:c&&c.blob||(void 0==c?"":c),file:c&&(e||c.name),type:c&&(g||c.type)})},each:function(a){for(var c=0,e=this.items.length;c<e;c++)a.call(this,this.items[c])},toData:function(f,c){c._chunked=a.support.chunked&&0<c.chunkSize&&1==a.filter(this.items,function(a){return a.file}).length;a.support.html5?this.multipart||!m?(a.log("FileAPI.Form.toMultipartData"),
this.toMultipartData(f)):c._chunked?(a.log("FileAPI.Form.toPlainData"),this.toPlainData(f)):(a.log("FileAPI.Form.toFormData"),this.toFormData(f)):(a.log("FileAPI.Form.toHtmlData"),this.toHtmlData(f))},_to:function(f,c,e,g){var m=a.queue(function(){c(f)});this.each(function(a){e(a,f,m,g)});m.check()},toHtmlData:function(f){this._to(g.createDocumentFragment(),f,function(c,e){var f=c.blob,m;c.file?(a.reset(f,!0),f.name=c.name,e.appendChild(f)):(m=g.createElement("input"),m.name=c.name,m.type="hidden",
m.value=f,e.appendChild(m))})},toPlainData:function(a){this._to({},a,function(a,e,f){a.file&&(e.type=a.file);a.blob.toBlob?(f.inc(),a.blob.toBlob(function(g){e.name=a.name;e.file=g;e.size=g.length;e.type=a.type;f.next()},"image/png")):a.file?(e.name=a.blob.name,e.file=a.blob,e.size=a.blob.size,e.type=a.type):(e.params||(e.params=[]),e.params.push(encodeURIComponent(a.name)+"="+encodeURIComponent(a.blob)));e.start=-1;e.end=e.file&&e.file.FileAPIReadPosition||-1;e.retry=0})},toFormData:function(a){this._to(new m,
a,function(a,e,f){a.file&&e.append("_"+a.name,a.file);a.blob&&a.blob.toBlob?(f.inc(),a.blob.toBlob(function(g){e.append(a.name,g,a.file);f.next()},"image/png")):a.file?e.append(a.name,a.blob,a.file):e.append(a.name,a.blob)})},toMultipartData:function(f){this._to([],f,function(c,e,f,g){var m=!!c.file,q=c.blob,x=function(a){e.push("--_"+g+('\r\nContent-Disposition: form-data; name="'+c.name+'"'+(m?'; filename="'+l(c.file)+'"':"")+(m?"\r\nContent-Type: "+(c.type||"application/octet-stream"):"")+"\r\n\r\n"+
(m?a:l(a))+"\r\n"));f.next()};f.inc();a.isFile(q)?a.readAsBinaryString(q,function(a){"load"==a.type&&x(a.result)}):x(q)},a.expando)}};a.Form=q})(FileAPI,window,document);
(function(a,q){var g=function(){},l=function(a){this.uid=q.uid();this.xhr={abort:g,getResponseHeader:g,getAllResponseHeaders:g};this.options=a};l.prototype={status:0,statusText:"",getResponseHeader:function(a){return this.xhr.getResponseHeader(a)},getAllResponseHeaders:function(){return this.xhr.getAllResponseHeaders()||{}},end:function(m,f){var c=this,e=c.options;c.end=c.abort=g;c.status=m;f&&(c.statusText=f);q.log("xhr.end:",m,f);e.complete(200==m||201==m?!1:c.statusText||"unknown",c);c.xhr&&c.xhr.node&&
setTimeout(function(){var e=c.xhr.node;try{e.parentNode.removeChild(e)}catch(f){}try{delete a[c.uid]}catch(g){}a[c.uid]=c.xhr.node=null},9)},abort:function(){this.end(0,"abort");this.xhr&&(this.xhr.aborted=!0,this.xhr.abort())},send:function(a){var f=this,c=this.options;a.toData(function(a){c.upload(c,f);f._send.call(f,c,a)},c)},_send:function(g,f){var c=this,e,n=c.uid,l=g.url;q.log("XHR._send:",f);g.cache||(l+=(~l.indexOf("?")?"&":"?")+q.uid());f.nodeName?(g.upload(g,c),e=document.createElement("div"),
e.innerHTML='<form target="'+n+'" action="'+l+'" method="POST" enctype="multipart/form-data" style="position: absolute; top: -1000px; overflow: hidden; width: 1px; height: 1px;"><iframe name="'+n+'" src="javascript:false;"></iframe><input value="'+n+'" name="callback" type="hidden"/></form>',c.xhr.abort=function(){var a=e.getElementsByName("iframe")[0];if(a)try{a.stop?a.stop():a.contentWindow.stop?a.contentWindow.stop():a.contentWindow.document.execCommand("Stop")}catch(c){}e=null},l=e.getElementsByTagName("form")[0],
l.appendChild(f),q.log(l.parentNode.innerHTML),document.body.appendChild(e),c.xhr.node=e,a[n]=function(a,f,g){c.readyState=4;c.responseText=g;c.end(a,f);e=null},c.readyState=2,l.submit(),l=null):this.xhr&&this.xhr.aborted?q.log("Error: already aborted"):(e=c.xhr=q.getXHR(),f.params&&(l+=(0>l.indexOf("?")?"?":"&")+f.params.join("&")),e.open("POST",l,!0),q.withCredentials&&(e.withCredentials="true"),g.headers&&g.headers["X-Requested-With"]||e.setRequestHeader("X-Requested-With","XMLHttpRequest"),q.each(g.headers,
function(a,c){e.setRequestHeader(c,a)}),g._chunked?(e.upload&&e.upload.addEventListener("progress",function(a){f.retry||g.progress({type:a.type,total:f.size,loaded:f.start+a.loaded,totalSize:f.size},c,g)},!1),e.onreadystatechange=function(){c.status=e.status;c.statusText=e.statusText;c.readyState=e.readyState;if(4==e.readyState){for(var a in{"":1,XML:1,Text:1,Body:1})c["response"+a]=e["response"+a];e.onreadystatechange=null;if(!e.status||0<e.status-201)if(q.log("Error: "+e.status),(!e.status&&!e.aborted||
500==e.status||416==e.status)&&++f.retry<=g.chunkUploadRetry){a=e.status?0:q.chunkNetworkDownRetryTimeout;g.pause(f.file,g);var l=parseInt(e.getResponseHeader("X-Last-Known-Byte"),10);q.log("X-Last-Known-Byte: "+l);f.end=l?l:f.start-1;setTimeout(function(){c._send(g,f)},a)}else c.end(e.status);else f.retry=0,f.end==f.size-1?c.end(e.status):(l=parseInt(e.getResponseHeader("X-Last-Known-Byte"),10),q.log("X-Last-Known-Byte: "+l),l&&(f.end=l),f.file.FileAPIReadPosition=f.end,setTimeout(function(){c._send(g,
f)},0));e=null}},f.start=f.end+1,f.end=Math.max(Math.min(f.start+g.chunkSize,f.size)-1,f.start),(n="slice")in f.file||(n="mozSlice")in f.file||(n="webkitSlice"),e.setRequestHeader("Content-Range","bytes "+f.start+"-"+f.end+"/"+f.size),e.setRequestHeader("Content-Disposition","attachment; filename="+encodeURIComponent(f.name)),e.setRequestHeader("Content-Type",f.type||"application/octet-stream"),n=f.file[n](f.start,f.end+1),e.send(n),n=null):(e.upload&&e.upload.addEventListener("progress",q.throttle(function(a){g.progress(a,
c,g)},100),!1),e.onreadystatechange=function(){c.status=e.status;c.statusText=e.statusText;c.readyState=e.readyState;if(4==e.readyState){for(var a in{"":1,XML:1,Text:1,Body:1})c["response"+a]=e["response"+a];e.onreadystatechange=null;c.end(e.status);e=null}},q.isArray(f)?(e.setRequestHeader("Content-Type","multipart/form-data; boundary=_"+q.expando),f=f.join("")+"--_"+q.expando+"--",e.sendAsBinary?e.sendAsBinary(f):(n=Array.prototype.map.call(f,function(a){return a.charCodeAt(0)&255}),e.send((new Uint8Array(n)).buffer))):
e.send(f)))}};q.XHR=l})(window,FileAPI);
(function(a,q,g){a.support.flash=function(){var g=q.navigator,m=g.mimeTypes,f=!1;if(g.plugins&&"object"==typeof g.plugins["Shockwave Flash"])f=g.plugins["Shockwave Flash"].description&&!(m&&m["application/x-shockwave-flash"]&&!m["application/x-shockwave-flash"].enabledPlugin);else try{f=!(!q.ActiveXObject||!new ActiveXObject("ShockwaveFlash.ShockwaveFlash"))}catch(c){}f||a.log("Flash -- does not supported.");return f}();/^file:/i.test(q.location)?a.log("[warn] Flash does not work on `file:` protocol."):!a.support.flash||
a.html5&&a.support.html5&&(!a.cors||a.support.cors)||function(){function l(a){return('<object id="#id#" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" width="'+(a.width||"100%")+'" height="'+(a.height||"100%")+'"><param name="movie" value="#src#" /><param name="flashvars" value="#flashvars#" /><param name="swliveconnect" value="true" /><param name="allowscriptaccess" value="always" /><param name="allownetworking" value="all" /><param name="menu" value="false" /><param name="wmode" value="#wmode#" /><embed flashvars="#flashvars#" swliveconnect="true" allownetworking="all" allowscriptaccess="always" name="#id#" src="#src#" width="'+
(a.width||"100%")+'" height="'+(a.height||"100%")+'" menu="false" wmode="transparent" type="application/x-shockwave-flash"></embed></object>').replace(/#(\w+)#/ig,function(c,e){return a[e]})}function m(a,c){if(a&&a.style){var e,f;for(e in c){f=c[e];"number"==typeof f&&(f+="px");try{a.style[e]=f}catch(g){}}}}function f(d,c){a.each(c,function(a,c){var e=d[c];d[c]=function(){this.parent=e;return a.apply(this,arguments)}})}function c(d){var c=d.wid=a.uid();p._fn[c]=d;return"FileAPI.Flash._fn."+c}function e(a){try{p._fn[a.wid]=
null,delete p._fn[a.wid]}catch(c){}}function n(a,c){if(!y.test(a)){if(/^\.\//.test(a)||"/"!=a.charAt(0)){var e=location.pathname,e=e.substr(0,e.lastIndexOf("/"));a=(e+"/"+a).replace("/./","/")}"//"!=a.substr(0,2)&&(a="//"+location.host+a);y.test(a)||(a=location.protocol+a)}c&&(a+=(/\?/.test(a)?"&":"?")+c);return a}function r(d,h,f){function q(){try{p.get(v).setImage(h)}catch(d){a.log('flash.setImage -- can not set "base64":',d)}}var r,v=a.uid(),s=g.createElement("div");for(r in d)s.setAttribute("data-img-"+
r,d[r]);m(s,d);s.innerHTML=l(a.extend({id:v,src:n(a.flashImageUrl,"r="+a.uid()),wmode:"opaque",flashvars:"scale="+d.scale+"&callback="+c(function w(){e(w);setTimeout(q,99);return!0})},d));f(!1,s);s=null}var s=a.uid(),u=0,x={},y=/^https?:/i,p={_fn:{},init:function(){var d=g.body&&g.body.firstChild;if(d){do if(1==d.nodeType){a.log("FlashAPI.Flash.init...");var c=g.createElement("div");m(c,{top:1,right:1,width:5,height:5,position:"absolute"});d.parentNode.insertBefore(c,d);p.publish(c,s);return}while(d=
d.nextSibling)}10>u&&setTimeout(p.init,50*++u)},publish:function(d,c){d.innerHTML=l({id:c,src:n(a.flashUrl,"r="+a.version),wmode:"transparent",flashvars:"callback=FileAPI.Flash.event&flashId="+c+"&storeKey="+navigator.userAgent.match(/\d/ig).join("")+"_"+a.version+(p.isReady||(a.pingUrl?"&ping="+a.pingUrl:""))+"&timeout="+a.flashAbortTimeout})},ready:function(){p.ready=a.F;p.isReady=!0;p.patch();a.event.on(g,"mouseover",p.mouseover);a.event.on(g,"click",function(a){p.mouseover(a)&&(a.preventDefault?
a.preventDefault():a.returnValue=!0)})},getWrapper:function(a){do if(/js-fileapi-wrapper/.test(a.className))return a;while((a=a.parentNode)&&a!==g.body)},mouseover:function(d){d=a.event.fix(d).target;if(/input/i.test(d.nodeName)&&"file"==d.type){var c=d.getAttribute(s);if("i"==c||"r"==c)return!1;if("p"!=c){d.setAttribute(s,"i");var c=g.createElement("div"),e=p.getWrapper(d);if(!e){a.log("flash.mouseover.error: js-fileapi-wrapper not found");return}m(c,{top:0,left:0,width:d.offsetWidth+100,height:d.offsetHeight+
100,zIndex:"1000000",position:"absolute"});e.appendChild(c);p.publish(c,a.uid());d.setAttribute(s,"p")}return!0}},event:function(d){var c=d.type;if("ready"==c){try{p.getInput(d.flashId).setAttribute(s,"r")}catch(e){}p.ready();setTimeout(function(){p.mouseenter(d)},50);return!0}"ping"===c?a.log("(flash -> js).ping:",[d.status,d.savedStatus],d.error):"log"===c?a.log("(flash -> js).log:",d.target):c in p&&setTimeout(function(){a.log("Flash.event."+d.type+":",d);p[c](d)},1)},mouseenter:function(d){var c=
p.getInput(d.flashId);if(c){p.cmd(d,"multiple",null!=c.getAttribute("multiple"));var e=[],f={};a.each((c.getAttribute("accept")||"").split(/,\s*/),function(d){a.accept[d]&&a.each(a.accept[d].split(" "),function(a){f[a]=1})});a.each(f,function(a,d){e.push(d)});p.cmd(d,"accept",e.length?e.join(",")+","+e.join(",").toUpperCase():"*")}},get:function(a){return g[a]||q[a]||g.embeds[a]},getInput:function(d){try{var c=p.getWrapper(p.get(d));if(c)return c.getElementsByTagName("input")[0]}catch(e){a.log('Can not find "input" by flashId:',
d,e)}},select:function(d){var c=p.getInput(d.flashId),e=a.uid(c);d=d.target.files;a.each(d,function(d){a.checkFileObj(d)});x[e]=d;g.createEvent?(e=g.createEvent("Event"),e.initEvent("change",!0,!1),c.dispatchEvent(e)):g.createEventObject&&(e=g.createEventObject(),c.fireEvent("onchange",e))},cmd:function(d,c,e,f){try{return a.log("(js -> flash)."+c+":",e),p.get(d.flashId||d).cmd(c,e)}catch(g){a.log("(js -> flash).onError:",g),f||setTimeout(function(){p.cmd(d,c,e,!0)},50)}},patch:function(){a.flashEngine=
a.support.transform=!0;f(a,{getFiles:function(d,c,e){if(e)return a.filterFiles(a.getFiles(d),c,e),null;var f=a.isArray(d)?d:x[a.uid(d.target||d.srcElement||d)];if(!f)return this.parent.apply(this,arguments);c&&(c=a.getFilesFilter(c),f=a.filter(f,function(a){return c.test(a.name)}));return f},getInfo:function(d,f){if(d&&!d.flashId)this.parent.apply(this,arguments);else{if(!d.__info){var g=d.__info=a.defer();p.cmd(d,"getFileInfo",{id:d.id,callback:c(function F(a,c){e(F);g.resolve(a,d.info=c)})})}d.__info.then(f)}}});
a.support.transform=!0;a.Image&&f(a.Image.prototype,{get:function(a,c){this.set({scaleMode:c||"noScale"});this.parent(a)},_load:function(c,e){a.log("FileAPI.Image._load:",c);if(c&&!c.flashId)this.parent.apply(this,arguments);else{var f=this;a.getInfo(c,function(a,g){e.call(f,a,c)})}},_apply:function(d,f){a.log("FileAPI.Image._apply:",d);if(d&&!d.flashId)this.parent.apply(this,arguments);else{var g=this.getMatrix(d.info);p.cmd(d,"imageTransform",{id:d.id,matrix:g,callback:c(function F(c,l){a.log("FileAPI.Image._apply.callback:",
c);e(F);c?f(c):!a.support.dataURI||3E4<l.length?r({width:g.deg%180?g.dh:g.dw,height:g.deg%180?g.dw:g.dh,scale:g.scaleMode},l,f):a.newImage("data:"+d.type+";base64,"+l,f)})})}},toData:function(c){var e=this.file,f=e.info,g=this.getMatrix(f);e&&!e.flashId?this.parent.apply(this,arguments):("auto"==g.deg&&(g.deg=a.Image.exifOrientation[f&&f.exif&&f.exif.Orientation]||0),c.call(this,!e.info,{id:e.id,flashId:e.flashId,name:e.name,type:e.type,matrix:g}))}});f(a.Form.prototype,{toData:function(c){for(var e=
this.items,f=e.length;f--;)if(e[f].file&&e[f].blob&&!e[f].blob.flashId)return this.parent.apply(this,arguments);a.log("flash.Form.toData");c(e)}});f(a.XHR.prototype,{_send:function(d,f){if(f.nodeName||f.append&&a.support.html5||a.isArray(f)&&"string"===typeof f[0])return this.parent.apply(this,arguments);var g={},l={},m=this,q,r;a.each(f,function(a){a.file?(l[a.name]=a={id:a.blob.id,name:a.blob.name,matrix:a.blob.matrix,flashId:a.blob.flashId},r=a.id,q=a.flashId):g[a.name]=a.blob});if(r||q)a.log("flash.XHR._send:",
q,r,l);else return this.parent.apply(this,arguments);m.xhr={headers:{},abort:function(){p.cmd(q,"abort",{id:r})},getResponseHeader:function(a){return this.headers[a]},getAllResponseHeaders:function(){return this.headers}};var s=a.queue(function(){p.cmd(q,"upload",{url:n(d.url),data:g,files:l,headers:d.headers,callback:c(function A(c){var f=c.type,g=c.result;a.log("flash.upload."+f+":",c);if("progress"==f)c.loaded=Math.min(c.loaded,c.total),c.lengthComputable=!0,d.progress(c);else if("complete"==f)e(A),
"string"==typeof g&&(m.responseText=g.replace(/%22/g,'"').replace(/%5c/g,"\\").replace(/%26/g,"&").replace(/%25/g,"%")),m.end(c.status||200);else if("abort"==f||"error"==f)m.end(c.status||0,c.message),e(A)})})});a.each(l,function(c){s.inc();a.getInfo(c,s.next)});s.check()}})}};a.Flash=p;a.newImage("data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==",function(c,e){a.support.dataURI=!(1!=e.width||1!=e.height);p.init()})}()})(FileAPI,window,document);
(function(a){a(FileAPI)})(function(a){if(window.navigator&&window.navigator.platform&&/iP(hone|od|ad)/.test(window.navigator.platform)){var q=a.renderImageToCanvas;a.detectSubsampling=function(a){var l;return 1048576<a.width*a.height?(l=document.createElement("canvas"),l.width=l.height=1,l=l.getContext("2d"),l.drawImage(a,-a.width+1,0),0===l.getImageData(0,0,1,1).data[3]):!1};a.detectVerticalSquash=function(a,l){var m=a.naturalHeight||a.height,f=document.createElement("canvas"),c=f.getContext("2d"),
e,n,q;l&&(m/=2);f.width=1;f.height=m;c.drawImage(a,0,0);f=c.getImageData(0,0,1,m).data;c=0;for(n=e=m;n>c;)q=f[4*(n-1)+3],0===q?e=n:c=n,n=e+c>>1;return n/m||1};a.renderImageToCanvas=function(g,l,m,f,c,e,n,r,s,u){if("image/jpeg"===l._type){var x=g.getContext("2d"),y=document.createElement("canvas"),p=y.getContext("2d"),d,h;y.width=1024;y.height=1024;x.save();if(d=a.detectSubsampling(l))m/=2,f/=2,c/=2,e/=2;h=a.detectVerticalSquash(l,d);if(d||1!==h){f*=h;s=Math.ceil(1024*s/c);u=Math.ceil(1024*u/e/h);
for(h=r=0;h<e;){for(d=n=0;d<c;)p.clearRect(0,0,1024,1024),p.drawImage(l,m,f,c,e,-d,-h,c,e),x.drawImage(y,0,0,1024,1024,n,r,s,u),d+=1024,n+=s;h+=1024;r+=u}x.restore();return g}}return q(g,l,m,f,c,e,n,r,s,u)}}});"undefined"!==typeof ajs&&ajs.loaded&&ajs.loaded("{fileapi}FileAPI.min");"function"===typeof define&&define.amd&&define("FileAPI",[],function(){return window.FileAPI||{}});