/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   lib/utils/gestures.html
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.

/// <reference path="boot.d.ts" />
/// <reference path="async.d.ts" />
/// <reference path="debounce.d.ts" />

declare namespace Polymer {

  /**
   * Module for adding listeners to a node for the following normalized
   * cross-platform "gesture" events:
   * - `down` - mouse or touch went down
   * - `up` - mouse or touch went up
   * - `tap` - mouse click or finger tap
   * - `track` - mouse drag or touch move
   */
  namespace Gestures {


    /**
     * Finds the element rendered on the screen at the provided coordinates.
     *
     * Similar to `document.elementFromPoint`, but pierces through
     * shadow roots.
     *
     * @returns Returns the deepest shadowRoot inclusive element
     * found at the screen position given.
     */
    function deepTargetFind(x: number, y: number): _Element|null;


    /**
     * Adds an event listener to a node for the given gesture type.
     *
     * @returns Returns true if a gesture event listener was added.
     */
    function addListener(node: Node, evType: string, handler: (p0: Event) => void): boolean;


    /**
     * Removes an event listener from a node for the given gesture type.
     *
     * @returns Returns true if a gesture event listener was removed.
     */
    function removeListener(node: Node, evType: string, handler: (p0: Event) => void): boolean;


    /**
     * Registers a new gesture event recognizer for adding new custom
     * gesture event types.
     */
    function register(recog: GestureRecognizer): void;


    /**
     * Sets scrolling direction on node.
     *
     * This value is checked on first move, thus it should be called prior to
     * adding event listeners.
     */
    function setTouchAction(node: _Element, value: string): void;


    /**
     * Prevents the dispatch and default action of the given event name.
     */
    function prevent(evName: string): void;


    /**
     * Reset the 2500ms timeout on processing mouse input after detecting touch input.
     *
     * Touch inputs create synthesized mouse inputs anywhere from 0 to 2000ms after the touch.
     * This method should only be called during testing with simulated touch inputs.
     * Calling this method in production may cause duplicate taps or other Gestures.
     */
    function resetMouseCanceller(): void;
  }
}
